----------------------------------------------------------------
-- Q7:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   WHILE statement with a LEAVE
----------------------------------------------------------------
CREATE FUNCTION all_author_from_country(item_id_in CHARACTER(10),
                                        country VARCHAR(50))
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE total_count INT;
    DECLARE country_name CHARACTER(20);
    DECLARE taupsm_result BOOLEAN;
    DECLARE country_cursor CURSOR FOR
        SELECT a.name_of_country
          FROM author a, item_author ia
          WHERE a.author_id = ia.author_id AND ia.item_id = item_id_i;
    OPEN country_cursor;
    SET total_count = 0;
    SET taupsm_result = TRUE;
    FETCH country_cursor INTO country_name;
    while1: WHILE NOT(country_not_found) DO
      SET total_count = total_count + 1;
      IF (country_name <> country)
        THEN
          SET taupsm_result = FALSE;
          LEAVE while1;
        ELSE FETCH country_cursor INTO country_name;
      END IF;
    END WHILE;
    CLOSE country_cursor;
    IF total_count = 0
      THEN SET taupsm_result = FALSE;
    END IF;
    RETURN taupsm_result;
  END;

SELECT * FROM item WHERE all_author_from_country(item_id, 'Canada');

