----------------------------------------------------------------
-- Q14:
--   Return the names of publishers who publish books between
--   a period of time from 1990-01-01 to 1991-01-01 but
--   do not have FAX number.
-- Feature:
--   Local cursor declaration
--   FETCH, OPEN, and CLOSE statements

-- NOTE: no_tuple is false if there is no tuple returned, i.e., if
--       the publisher published no books during the indicated period.
----------------------------------------------------------------
CREATE FUNCTION is_released_in_period(pid CHARACTER(10),
                                      date1 DATE, date2 DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE item_id_var CHARACTER(10);
    DECLARE no_tuple CONDITION FOR SQLSTATE '02000';
    DECLARE item_cursor CURSOR FOR
        SELECT i.item_id FROM item i, item_publisher ip
          WHERE i.item_id = ip.item_id AND
            ip.publisher_id = pid AND
            i.date_of_release BETWEEN date1 AND date2;
    OPEN item_cursor;
    FETCH item_cursor INTO item_id_var;
    CLOSE item_cursor;
    RETURN no_tuple;
  END;

SELECT name FROM publisher
  WHERE is_released_in_period(publisher_id, '1990-01-01', '1991-01-01')
    AND fax_number IS NULL;

