----------------------------------------------------------------
-- Q11:
--   List the item titles in descending order by date of
--   release with date of release within a certain time
--   range from 1990-01-01 to 1995-01-01.
-- Feature:
--   Temporary Table Creation
----------------------------------------------------------------
CREATE FUNCTION is_publised_in_period(item_id_in CHARACTER(10))
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    CREATE TEMPORARY TABLE temp_item AS (SELECT * FROM item);
    RETURN EXISTS (SELECT * FROM temp_item
                     WHERE item_id = item_id_in AND
                       date_of_release BETWEEN '1990-01-01' AND '1995-01-01');
  END;

SELECT title FROM item
  WHERE is_published_in_period(item_id);

