-- procedure
CREATE PROCEDURE proc_db2_all_author_from_country (item_id_in CHARACTER (10), country VARCHAR (50), OUT result_value INTEGER) NO EXTERNAL ACTION READS SQL DATA LANGUAGE SQL
f1 : BEGIN
    DECLARE total_count INT;
    DECLARE country_name CHARACTER (20);
    DECLARE taupsm_result INTEGER;
    DECLARE not_found INTEGER;
    DECLARE country_not_found CONDITION FOR SQLSTATE '02000';
    DECLARE country_cursor CURSOR FOR SELECT a.name_of_country
        FROM author a, item_author ia
        WHERE a.author_id = ia.author_id
            AND ia.item_id = item_id_in;
    DECLARE CONTINUE HANDLER FOR country_not_found
      SET not_found=1;
    OPEN country_cursor;
    SET total_count = 0;
    SET taupsm_result = 1;
    FETCH country_cursor INTO country_name;
    while1 : WHILE NOT (not_found = 1) DO
        SET total_count = total_count + 1;
        IF (country_name <> country) THEN
            SET taupsm_result = 0;
            LEAVE while1;
            ELSE
                FETCH country_cursor INTO country_name;
        END IF;
    END WHILE;

    CLOSE country_cursor;
    IF total_count = 0 THEN
        SET taupsm_result = 0;
    END IF;
    SET result_value = taupsm_result;
END

-- end
-- function
CREATE FUNCTION db2_all_author_from_country (item_id_in CHARACTER (10), country VARCHAR (50)) RETURNS INTEGER NO EXTERNAL ACTION READS SQL DATA LANGUAGE SQL
BEGIN
    DECLARE proc_result INTEGER;
    CALL proc_db2_all_author_from_country (item_id_in, country, proc_result);
    RETURN proc_result;
END

-- end
-- sql
SELECT *
    FROM item
    WHERE db2_all_author_from_country (item_id, CAST ('Canada' AS VARCHAR (50))) = 1
-- end
