-----------------------------------------------------------------
-- Q10:
--   List the item titles ordered alphabetically by publisher
--   name, with release date within a certain time period
--   (from 1990-01-01 to 1995-01-01)
-- Feature:
--   IF without CURSOR
-----------------------------------------------------------------
-- function
CREATE FUNCTION db2_orig_item_of_90s(rd DATE)
  RETURNS INT
  NO EXTERNAL ACTION
F1:  BEGIN ATOMIC
    DECLARE taupsm_result INT;
    IF (rd >= '1990-01-01') AND (rd < '1995-01-01')
    THEN
      SET taupsm_result = 1;
    ELSE
      SET taupsm_result = 0;
    END IF;
    RETURN taupsm_result;
END
-- end

-- sql
SELECT i.title, p.name
  FROM publisher p, item i, item_publisher ip
  WHERE i.item_id = ip.item_id
    AND ip.publisher_id = p.publisher_id
    AND db2_orig_item_of_90s(i.date_of_release) = 1
  ORDER BY p.name
-- end

