/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.util;

import cs.arizona.util.TauLogger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SchemaPathEvaluator {
    Document schemaDoc;
    String xmlSchemaName = "xsd:";
    Hashtable elementTable;
    Hashtable groupTable;
    Hashtable complexTypeTable;
    Hashtable attributeGroupTable;

    public SchemaPathEvaluator(Document schemaDoc) {
        this.schemaDoc = schemaDoc;
        this.fillHashTables();
    }

    public Element validateSchemaPath(String path) {
        Element topLevelElement = this.getTopLevelElement();
        Element targetElement = this.validatePath(topLevelElement, path);
        return targetElement;
    }

    private Element validatePath(Element currentElement, String path) {
        String elementName = currentElement.getLocalName();
        Element targetElement = null;
        if (elementName == "element") {
            if (currentElement.getAttribute("ref") != "") {
                targetElement = this.validatePath((Element)this.elementTable.get(currentElement.getAttribute("ref")), path);
            } else {
                String name = currentElement.getAttribute("name");
                if (path.startsWith("/" + name)) {
                    if (path.equals("/" + name)) {
                        targetElement = currentElement;
                    } else {
                        String remainingPath = this.getRemainingPath(path);
                        if (currentElement.getAttribute("type") != "") {
                            targetElement = this.validatePath((Element)this.complexTypeTable.get(currentElement.getAttribute("type")), remainingPath);
                        } else {
                            Element element;
                            NodeList nl = currentElement.getChildNodes();
                            for (int i = 0; i < nl.getLength() && (nl.item(i).getNodeType() != 1 || (targetElement = this.validatePath(element = (Element)nl.item(i), remainingPath)) == null); ++i) {
                            }
                        }
                    }
                } else {
                    targetElement = null;
                }
            }
        } else if (elementName == "group") {
            Element element;
            if (currentElement.getAttribute("ref") != "") {
                Element groupElement = (Element)this.groupTable.get(currentElement.getAttribute("ref"));
                targetElement = this.validatePath(groupElement, path);
                return targetElement;
            }
            NodeList nl = currentElement.getChildNodes();
            for (int i = 0; i < nl.getLength() && (nl.item(i).getNodeType() != 1 || (targetElement = this.validatePath(element = (Element)nl.item(i), path)) == null); ++i) {
            }
        } else {
            Element element;
            NodeList nl = currentElement.getChildNodes();
            for (int i = 0; i < nl.getLength() && (nl.item(i).getNodeType() != 1 || (targetElement = this.validatePath(element = (Element)nl.item(i), path)) == null); ++i) {
            }
        }
        return targetElement;
    }

    public boolean validateField(Element element, String fieldPath) {
        if (fieldPath.equals("/text")) {
            return true;
        }
        if (fieldPath.startsWith("/@")) {
            NodeList nl = element.getElementsByTagName(this.xmlSchemaName + "attribute");
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!fieldPath.substring(2).equals(((Element)nl.item(i)).getAttribute("name"))) continue;
                return true;
            }
            TauLogger.logger.error((Object)("Target path \"" + fieldPath + "\" was not found."));
            return false;
        }
        TauLogger.logger.error((Object)("Target path \"" + fieldPath + "\" does not start wtih \"/@\"."));
        return false;
    }

    public Element getTopLevelElement() {
        Hashtable tempElementTable = new Hashtable();
        Enumeration elementKeys = this.elementTable.keys();
        while (elementKeys.hasMoreElements()) {
            String key = (String)elementKeys.nextElement();
            tempElementTable.put(key, this.elementTable.get(key));
        }
        Element schemaElement = this.schemaDoc.getDocumentElement();
        Element topLevelElement = null;
        NodeList nl = schemaElement.getElementsByTagName(this.xmlSchemaName + "element");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (nl.item(i).getNodeType() != 1 || (currentElement = (Element)nl.item(i)).getAttribute("ref") == "") continue;
            tempElementTable.remove(currentElement.getAttribute("ref"));
        }
        Enumeration enumeration = tempElementTable.elements();
        while (enumeration.hasMoreElements()) {
            topLevelElement = (Element)enumeration.nextElement();
        }
        return topLevelElement;
    }

    public Hashtable getChildAttributes(String path) {
        int i;
        Hashtable<String, Element> attributeTable = new Hashtable<String, Element>();
        Element e = this.validateSchemaPath(path);
        NodeList nl = e.getElementsByTagName(this.xmlSchemaName + "attributeGroup");
        for (i = 0; i < nl.getLength(); ++i) {
            Element attrGroupElement = (Element)nl.item(i);
            attrGroupElement = (Element)this.attributeGroupTable.get(attrGroupElement.getAttribute("ref"));
            NodeList nl1 = attrGroupElement.getElementsByTagName(this.xmlSchemaName + "attribute");
            for (int j = 0; j < nl.getLength(); ++j) {
                Element attrElement = (Element)nl1.item(i);
                attributeTable.put(attrElement.getAttribute("name"), attrElement);
            }
        }
        nl = e.getElementsByTagName(this.xmlSchemaName + "attribute");
        for (i = 0; i < nl.getLength(); ++i) {
            Element attrElement = (Element)nl.item(i);
            attributeTable.put(attrElement.getAttribute("name"), attrElement);
        }
        return attributeTable;
    }

    public ArrayList getChildElements(String path) {
        ArrayList<Element> childElementList = new ArrayList<Element>();
        Element e = this.validateSchemaPath(path);
        if (null != e.getAttribute("type")) {
            e = (Element)this.complexTypeTable.get(e.getAttribute("type"));
        }
        this.addGroupElements(childElementList, e);
        NodeList nl = e.getElementsByTagName(this.xmlSchemaName + "element");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element childElement = (Element)nl.item(i);
            childElementList.add(childElement);
        }
        return childElementList;
    }

    private void addGroupElements(ArrayList childElementList, Element e) {
        NodeList nl = e.getElementsByTagName(this.xmlSchemaName + "group");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element groupElement = (Element)nl.item(i);
            groupElement = (Element)this.groupTable.get(groupElement.getAttribute("ref"));
            this.addGroupElements(childElementList, groupElement);
            NodeList nl1 = groupElement.getElementsByTagName(this.xmlSchemaName + "element");
            for (int j = 0; j < nl.getLength(); ++j) {
                Element childElement = (Element)nl1.item(i);
                childElementList.add(childElement);
            }
        }
    }

    private void getXMLSchemaName() {
        NamedNodeMap attributes = this.schemaDoc.getDocumentElement().getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if (attrName.indexOf("xmlns") == -1 || !attrValue.equals("http://www.w3.org/2001/XMLSchema")) continue;
            this.xmlSchemaName = attrName.substring(attrName.indexOf(":") + 1) + ":";
        }
    }

    private void fillHashTables() {
        this.elementTable = new Hashtable();
        this.groupTable = new Hashtable();
        this.complexTypeTable = new Hashtable();
        this.attributeGroupTable = new Hashtable();
        Element schemaElement = this.schemaDoc.getDocumentElement();
        NodeList nl = schemaElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            Element element = (Element)nl.item(i);
            if ("element".equals(element.getLocalName())) {
                this.elementTable.put(element.getAttribute("name"), element);
                continue;
            }
            if ("group".equals(element.getLocalName())) {
                this.groupTable.put(element.getAttribute("name"), element);
                continue;
            }
            if ("complexType".equals(element.getLocalName())) {
                this.complexTypeTable.put(element.getAttribute("name"), element);
                continue;
            }
            if (!"attributeGroup".equals(element.getLocalName())) continue;
            this.attributeGroupTable.put(element.getAttribute("name"), element);
        }
    }

    private String getRemainingPath(String path) {
        return path.substring(path.indexOf("/", 1));
    }

    public String printTable(char c) {
        switch (c) {
            case 'e': {
                return this.elementTable.toString();
            }
            case 'g': {
                return this.groupTable.toString();
            }
            case 'c': {
                return this.complexTypeTable.toString();
            }
            case 'a': {
                return this.attributeGroupTable.toString();
            }
        }
        return "";
    }
}

