/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.util;

import cs.arizona.util.TauLogger;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class ConventionalParser {
    private LSParser lsParser;
    private LSSerializer lsSerializer;
    private LSOutput lsOutput;
    private LSInput lsInput;
    private DOMImplementation impl;
    private static ConventionalParser conventionalParser;

    private ConventionalParser() {
        try {
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS implLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            this.lsParser = implLS.createLSParser((short)1, null);
            this.lsSerializer = implLS.createLSSerializer();
            this.lsOutput = implLS.createLSOutput();
            this.lsInput = implLS.createLSInput();
            this.impl = registry.getDOMImplementation("XML 3.0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConventionalParser getInstance() {
        if (null == conventionalParser) {
            conventionalParser = new ConventionalParser();
        }
        return conventionalParser;
    }

    public Document parseDocument(String documentPath, String schemaType, String schemaLocation) {
        return this.parseDocument(documentPath, schemaType, schemaLocation, true);
    }

    public Document parseDocument(String documentPath, String schemaType, String schemaLocation, boolean vl) throws DOMException, LSException {
        Document document;
        try {
            String current_path = new File(".").getCanonicalPath();
            TauLogger.logger.info((Object)("Parsing document \"" + documentPath + "\""));
            DOMConfiguration domConfig = this.lsParser.getDomConfig();
            schemaType = "http://www.w3.org/2001/XMLSchema";
            domConfig.setParameter("schema-type", schemaType);
            domConfig.setParameter("schema-location", current_path + "/" + schemaLocation);
            domConfig.setParameter("validate", vl);
            document = this.lsParser.parseURI(documentPath);
        }
        catch (DOMException e) {
            e.printStackTrace();
            throw e;
        }
        catch (LSException e) {
            System.out.println("Error Unable to parse document: " + documentPath);
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return document;
    }

    public void writeDocument(Document doc, String path) {
        try {
            TauLogger.logger.info((Object)("Writing document \"" + path + "\""));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new FileOutputStream(path));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeElement(Element element, String path) {
        TauLogger.logger.info((Object)("Writing element to file \"" + path + "\""));
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(element);
            StreamResult result = new StreamResult(new FileOutputStream(path));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType docType) {
        return this.impl.createDocument(namespaceURI, qualifiedName, docType);
    }

    public Document parseURI(String documentPath) {
        DOMConfiguration domConfig = this.lsParser.getDomConfig();
        domConfig.setParameter("schema-type", null);
        domConfig.setParameter("schema-location", null);
        domConfig.setParameter("validate", Boolean.FALSE);
        return this.lsParser.parseURI(documentPath);
    }
}

