/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import cs.arizona.tau.xml.temporalconstraint.TransitionConstraint;
import cs.arizona.util.ConventionalParser;
import java.util.Vector;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

public class TransitionConstraintTest {
    Document temporal_doc_;
    Document annotation_doc_;
    Document schema_doc_;
    Applicability default_applicability_;
    Vector<Constraint> constraints_;
    TemporalConstraintValidator tcv_;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.constraints_ = new Vector();
        String temporalSchema = "test_suites/transition/tempschema.xml";
        Document input_temporal_doc = ConventionalParser.getInstance().parseDocument("test_suites/transition/temporalDocument_squashed.xml", null, null, false);
        this.tcv_ = new TemporalConstraintValidator(input_temporal_doc, temporalSchema);
        this.temporal_doc_ = this.tcv_.GetTemporalDocument();
        this.annotation_doc_ = this.tcv_.GetAnnotationDocument();
        this.tcv_.ExtractConstraints(this.annotation_doc_.getDocumentElement(), "transitionConstraint", this.constraints_);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCheckTransitionConstraint() {
        int num_constraints = this.constraints_.size();
        Assert.assertEquals((long)2L, (long)num_constraints);
        Vector<Constraint> constraint1 = new Vector<Constraint>();
        constraint1.add(this.constraints_.get(0));
        Vector<Constraint> constraint2 = new Vector<Constraint>();
        constraint2.add(this.constraints_.get(1));
        boolean val1 = TransitionConstraint.CheckTransitionConstraint(this.temporal_doc_, constraint1);
        Assert.assertFalse((boolean)val1);
        boolean val2 = TransitionConstraint.CheckTransitionConstraint(this.temporal_doc_, constraint2);
        Assert.assertFalse((boolean)val2);
    }
}

