/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import cs.arizona.tau.xml.temporalconstraint.ValuePair;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransitionConstraint
extends Constraint {
    protected String value_evolution_;
    protected TreeSet<String> value_pair_set_ = null;
    protected int mode_;
    public static int VALUEEVOLUTION = 0;
    public static int VALUEPAIR = 1;

    public TransitionConstraint(String name, String dimension, String selector, String field, int evaluation_window, int slide_size, Applicability applicability, String direction) {
        super(name, dimension, selector, field, evaluation_window, slide_size, applicability);
        this.value_evolution_ = direction;
        this.mode_ = VALUEEVOLUTION;
    }

    public TransitionConstraint(String name, String dimension, String selector, String field, int evaluation_window, int slide_size, Applicability applicability, Vector<ValuePair> value_pairs) {
        super(name, dimension, selector, field, evaluation_window, slide_size, applicability);
        this.value_pair_set_ = new TreeSet();
        for (ValuePair vp : value_pairs) {
            this.value_pair_set_.add(vp.old_val_ + "-" + vp.new_val_);
        }
        this.mode_ = VALUEPAIR;
    }

    public String getDirection() {
        return this.value_evolution_;
    }

    public TreeSet<String> getValuePairSet() {
        return this.value_pair_set_;
    }

    public int getMode() {
        return this.mode_;
    }

    public static boolean CheckTransitionConstraint(Document temporal_doc, Vector<Constraint> constraints) {
        if (constraints == null) {
            return true;
        }
        for (Constraint c : constraints) {
            for (Applicability app : c.eval_windows_) {
                String xpath_query = TemporalConstraintValidator.PrepareXPathString(c.getSelector(), c.getField());
                Vector<Node> result_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, xpath_query, app);
                if (result_nodes == null) {
                    return false;
                }
                if (((TransitionConstraint)c).getMode() == VALUEEVOLUTION) {
                    for (int i = 0; i < result_nodes.size() - 1; ++i) {
                        String direction = ((TransitionConstraint)c).getDirection();
                        if (!(direction.equals("LE") && Integer.parseInt(result_nodes.get(i).getTextContent()) > Integer.parseInt(result_nodes.get(i + 1).getTextContent()) || direction.equals("GE") && Integer.parseInt(result_nodes.get(i).getTextContent()) < Integer.parseInt(result_nodes.get(i + 1).getTextContent()) || direction.equals("LT") && Integer.parseInt(result_nodes.get(i).getTextContent()) >= Integer.parseInt(result_nodes.get(i + 1).getTextContent()) || direction.equals("GT") && Integer.parseInt(result_nodes.get(i).getTextContent()) <= Integer.parseInt(result_nodes.get(i + 1).getTextContent()) || direction.equals("EQ") && Integer.parseInt(result_nodes.get(i).getTextContent()) != Integer.parseInt(result_nodes.get(i + 1).getTextContent())) && (!direction.equals("NE") || Integer.parseInt(result_nodes.get(i).getTextContent()) != Integer.parseInt(result_nodes.get(i + 1).getTextContent()))) continue;
                        System.err.println("In period " + app.toString() + " [" + c.getName() + "] transition violation: previous value " + result_nodes.get(i).getTextContent() + " and later value " + result_nodes.get(i + 1).getTextContent() + " violate the constraint [prev (" + ((TransitionConstraint)c).getDirection() + ") later]");
                        return false;
                    }
                    continue;
                }
                if (((TransitionConstraint)c).getMode() != VALUEPAIR) continue;
                TreeSet<String> vp_set = ((TransitionConstraint)c).getValuePairSet();
                for (int i = 0; i < result_nodes.size() - 1; ++i) {
                    String old_val = result_nodes.get(i).getTextContent();
                    String new_val = result_nodes.get(i + 1).getTextContent();
                    if (vp_set.contains(old_val + "-" + new_val)) continue;
                    System.err.println("In period " + app.toString() + " [" + c.getName() + "] transition violation: value transition from " + old_val + " to " + new_val + " is not allowed.");
                    return false;
                }
            }
        }
        return true;
    }
}

