/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.docs.ConstantSchemaTemporalDocument;
import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.CardinalityConstraint;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.IdentityConstraint;
import cs.arizona.tau.xml.temporalconstraint.ReferentialIntegrityConstraint;
import cs.arizona.tau.xml.temporalconstraint.TransitionConstraint;
import cs.arizona.tau.xml.temporalconstraint.ValuePair;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemporalConstraintValidator {
    private Document temporal_doc_;
    private Document annotation_doc_;
    private Document schema_doc_;
    private HashMap<String, Vector<Constraint>> constraint_map_;
    private Applicability default_applicability_;
    public static String NONSEQKEY = "nonSeqKey";
    public static String NONSEQUNIQUE = "nonSeqUnique";
    public static String UNIQUENULLRESTRICTED = "uniqueNullRestricted";
    public static String SEQCARDINALITY = "seqCardinality";
    public static String NONSEQCARDINALITY = "nonSeqCardinality";
    public static String TRANSITION = "transitionConstraint";
    public static String NONSEQKEYREF = "nonSeqKeyref";

    public TemporalConstraintValidator(Document temporal_doc, String temporal_schema_name) {
        ValidatorProperties vp = ValidatorProperties.getInstance();
        ConventionalParser cp = ConventionalParser.getInstance();
        TemporalSchema ts = new TemporalSchema(vp, cp, temporal_schema_name);
        this.annotation_doc_ = ts.getAnnotationDoc();
        this.schema_doc_ = ts.getConventionalSchemaDoc();
        TargetIdentifier ti = new TargetIdentifier(this.schema_doc_);
        Document defaultAnnotationDoc = Common.createDefaultAnnotationDoc(cp, Common.getTopLevelSchemaElementName(ti));
        LogicalAnnotationValidator lav = new LogicalAnnotationValidator(this.annotation_doc_, this.schema_doc_, ti, true);
        PhysicalAnnotationValidator defaultPav = new PhysicalAnnotationValidator(defaultAnnotationDoc, this.schema_doc_, ti, true);
        ConstantSchemaTemporalDocument internal_temporal_document = new ConstantSchemaTemporalDocument(ti, lav, defaultPav, temporal_doc);
        this.temporal_doc_ = internal_temporal_document.getInternalTemporalDocument();
        Element root_element = this.temporal_doc_.getDocumentElement();
        this.default_applicability_ = new Applicability(root_element.getAttribute("begin"), root_element.getAttribute("end"));
    }

    public Document GetTemporalDocument() {
        return this.temporal_doc_;
    }

    public Document GetAnnotationDocument() {
        return this.annotation_doc_;
    }

    public Document GetSchemaDocument() {
        return this.schema_doc_;
    }

    public void ExtractConstraint(Document annotation_doc) {
        this.constraint_map_ = new HashMap();
        Element annotation_root = annotation_doc.getDocumentElement();
        Vector<Constraint> nonseqkey_fields = new Vector<Constraint>();
        Vector<Constraint> nonsequnique_fields = new Vector<Constraint>();
        Vector<Constraint> uniquenullrestricted_fields = new Vector<Constraint>();
        Vector<Constraint> seqcard_fields = new Vector<Constraint>();
        Vector<Constraint> nonseqcard_fields = new Vector<Constraint>();
        Vector<Constraint> transition_fields = new Vector<Constraint>();
        Vector<Constraint> nonseqkeyref_fields = new Vector<Constraint>();
        Vector keyref_fields = new Vector();
        this.ExtractConstraints(annotation_root, NONSEQKEY, nonseqkey_fields);
        this.constraint_map_.put(NONSEQKEY, nonseqkey_fields);
        this.ExtractConstraints(annotation_root, NONSEQUNIQUE, nonsequnique_fields);
        this.constraint_map_.put(NONSEQUNIQUE, nonsequnique_fields);
        this.ExtractConstraints(annotation_root, UNIQUENULLRESTRICTED, uniquenullrestricted_fields);
        this.constraint_map_.put(NONSEQUNIQUE, nonsequnique_fields);
        this.ExtractConstraints(annotation_root, NONSEQKEYREF, nonseqkeyref_fields);
        this.constraint_map_.put(NONSEQKEYREF, nonseqkeyref_fields);
        this.ExtractConstraints(annotation_root, SEQCARDINALITY, seqcard_fields);
        this.constraint_map_.put(SEQCARDINALITY, seqcard_fields);
        this.ExtractConstraints(annotation_root, NONSEQCARDINALITY, nonseqcard_fields);
        this.constraint_map_.put(NONSEQCARDINALITY, nonseqcard_fields);
        this.ExtractConstraints(annotation_root, TRANSITION, transition_fields);
        this.constraint_map_.put(TRANSITION, transition_fields);
        TauLogger.logger.info((Object)"All Constraints");
        System.out.println("*********************************");
        TauLogger.logger.info((Object)"<nonseqkey>");
        for (Constraint s : nonseqkey_fields) {
            TauLogger.logger.info((Object)s.toString());
        }
        TauLogger.logger.info((Object)"<nonsequnique>");
        for (Constraint s : nonsequnique_fields) {
            TauLogger.logger.info((Object)s.toString());
        }
        TauLogger.logger.info((Object)"<keyref>");
        for (Constraint s : keyref_fields) {
            TauLogger.logger.info((Object)s.toString());
        }
        TauLogger.logger.info((Object)"<nonseqkeyref>");
        for (Constraint s : nonseqkeyref_fields) {
            TauLogger.logger.info((Object)s.toString());
        }
        TauLogger.logger.info((Object)"<uniquenullrestricted>");
        for (Constraint s : uniquenullrestricted_fields) {
            TauLogger.logger.info((Object)s.toString());
        }
        TauLogger.logger.info((Object)"<seqcardinality>");
        for (Constraint s : seqcard_fields) {
            TauLogger.logger.info((Object)(s.toString() + " -- " + ((CardinalityConstraint)s).getMaxOccur()));
        }
        TauLogger.logger.info((Object)"<nonseqcardinality>");
        for (Constraint s : nonseqcard_fields) {
            TauLogger.logger.info((Object)(s.toString() + " -- " + ((CardinalityConstraint)s).getMaxOccur()));
        }
        TauLogger.logger.info((Object)"<transition>");
        for (Constraint s : transition_fields) {
            TauLogger.logger.info((Object)s.toString());
        }
        TauLogger.logger.info((Object)"*********************************");
    }

    public static Vector<String> ConvertConventionalIdentifier(String conv_id_name, Document schema_doc) {
        Vector<String> ret_vec = new Vector<String>();
        int identifier = -1;
        try {
            Node tmp_node;
            int i;
            NodeList keyref_def = schema_doc.getElementsByTagName("xsd:unique");
            Vector<Node> def_vec = new Vector<Node>();
            for (i = 0; i < keyref_def.getLength(); ++i) {
                tmp_node = keyref_def.item(i);
                if (((Element)tmp_node).getAttribute("name").equals(conv_id_name)) {
                    def_vec.add(tmp_node);
                }
                if (def_vec.size() <= 0) continue;
                identifier = 0;
            }
            if (def_vec.size() == 0) {
                keyref_def = schema_doc.getElementsByTagName("xsd:key");
                def_vec = new Vector();
                for (i = 0; i < keyref_def.getLength(); ++i) {
                    tmp_node = keyref_def.item(i);
                    if (!((Element)tmp_node).getAttribute("name").equals(conv_id_name)) continue;
                    def_vec.add(tmp_node);
                }
                if (def_vec.size() > 0) {
                    identifier = 1;
                }
            }
            if (def_vec.size() == 0) {
                keyref_def = schema_doc.getElementsByTagName("xsd:keyref");
                def_vec = new Vector();
                for (i = 0; i < keyref_def.getLength(); ++i) {
                    tmp_node = keyref_def.item(i);
                    if (!((Element)tmp_node).getAttribute("name").equals(conv_id_name)) continue;
                    def_vec.add(tmp_node);
                }
                if (def_vec.size() > 0) {
                    identifier = 2;
                }
            }
            if (def_vec.size() != 1) {
                System.err.println("conventionalIdetifier " + conv_id_name + " not found or not uniquely declared. Def found " + def_vec.size());
                return null;
            }
            Element keyref_element = (Element)def_vec.get(0);
            ret_vec.add(((Element)keyref_element.getElementsByTagName("xsd:selector").item(0)).getAttribute("xpath"));
            ret_vec.add(((Element)keyref_element.getElementsByTagName("xsd:field").item(0)).getAttribute("xpath"));
            if (identifier == 2) {
                ret_vec.add(keyref_element.getAttribute("refer"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return ret_vec;
    }

    public void ExtractConstraints(Element root, String target, Vector<Constraint> results) {
        if (root.getNodeName().equals(target) && root.getNodeType() == 1) {
            String name = root.getAttribute("name");
            String dimension = root.getAttribute("dimension");
            if (dimension == null || dimension.equals("")) {
                dimension = "validTime";
            }
            String selector = null;
            Element selector_element = (Element)root.getElementsByTagName("selector").item(0);
            if (selector_element != null) {
                selector = selector_element.getAttribute("xpath");
            }
            String field = null;
            Element field_element = (Element)root.getElementsByTagName("field").item(0);
            if (field_element != null) {
                field = field_element.getAttribute("xpath");
            }
            String evaluation_window_attr = root.getAttribute("evaluationWindow");
            int evaluation_window = -1;
            if (evaluation_window_attr != null && !evaluation_window_attr.equals("")) {
                evaluation_window = Integer.parseInt(evaluation_window_attr);
            }
            String slide_size_attr = root.getAttribute("slideSize");
            int slide_size = 1;
            if (slide_size_attr != null && !slide_size_attr.equals("")) {
                slide_size = Integer.parseInt(slide_size_attr);
            }
            Applicability applicability = null;
            Element app_element = (Element)root.getElementsByTagName("applicability").item(0);
            applicability = app_element != null ? new Applicability(app_element.getAttribute("begin"), app_element.getAttribute("end")) : this.default_applicability_;
            Constraint new_constraint = null;
            if (target.equals(NONSEQUNIQUE) || target.equals(NONSEQKEY) || target.equals(UNIQUENULLRESTRICTED)) {
                String conventional_identifier;
                String null_cnt_max_attr;
                String scope = root.getAttribute("scope");
                int null_count_min = -1;
                int null_count_max = -1;
                String null_cnt_min_attr = root.getAttribute("nullCountMin");
                if (null_cnt_min_attr != null && !null_cnt_min_attr.equals("")) {
                    null_count_min = Integer.parseInt(null_cnt_min_attr);
                }
                if ((null_cnt_max_attr = root.getAttribute("nullCountMax")) != null && !null_cnt_max_attr.equals("")) {
                    null_count_max = Integer.parseInt(null_cnt_max_attr);
                }
                if ((conventional_identifier = root.getAttribute("conventionalIdentifier")) == null || conventional_identifier.equals("")) {
                    conventional_identifier = null;
                } else {
                    Vector<String> selector_field = TemporalConstraintValidator.ConvertConventionalIdentifier(conventional_identifier, this.schema_doc_);
                    if (selector_field == null) {
                        System.exit(3);
                    }
                    selector = selector_field.get(0);
                    field = selector_field.get(1);
                }
                new_constraint = new IdentityConstraint(name, dimension, selector, field, evaluation_window, slide_size, applicability, scope, conventional_identifier, null_count_min, null_count_max);
            } else if (target.equals(SEQCARDINALITY) || target.equals(NONSEQCARDINALITY)) {
                String maxoccur_attr = root.getAttribute("maxOccurs");
                int max_occur = -1;
                if (maxoccur_attr != null && !maxoccur_attr.equals("")) {
                    max_occur = Integer.parseInt(maxoccur_attr);
                }
                String minoccur_attr = root.getAttribute("minOccurs");
                int min_occur = -1;
                if (minoccur_attr != null && !minoccur_attr.equals("")) {
                    min_occur = Integer.parseInt(minoccur_attr);
                }
                NodeList grp_node = root.getElementsByTagName("group");
                String group = null;
                if (grp_node != null && grp_node.getLength() > 0) {
                    group = ((Element)grp_node.item(0)).getAttribute("xpath");
                }
                String new_only_attr = root.getAttribute("newOnly");
                boolean new_only = false;
                if (new_only_attr != null && new_only_attr.equals("true")) {
                    new_only = true;
                }
                new_constraint = new CardinalityConstraint(name, dimension, selector, field, group, evaluation_window, slide_size, applicability, new_only, max_occur, min_occur);
            } else if (target.equals(TRANSITION)) {
                NodeList ve_node = root.getElementsByTagName("valueEvolution");
                if (ve_node != null && ve_node.getLength() > 0) {
                    String direction = ((Element)ve_node.item(0)).getAttribute("direction");
                    new_constraint = new TransitionConstraint(name, dimension, selector, field, evaluation_window, slide_size, applicability, direction);
                } else {
                    NodeList vp_nodes = root.getElementsByTagName("valuePair");
                    Vector<ValuePair> value_pairs = new Vector<ValuePair>();
                    for (int i = 0; i < vp_nodes.getLength(); ++i) {
                        Element tmp_element = (Element)vp_nodes.item(i);
                        ValuePair new_vp = new ValuePair(tmp_element.getElementsByTagName("old").item(0).getTextContent(), tmp_element.getElementsByTagName("new").item(0).getTextContent());
                        value_pairs.add(new_vp);
                    }
                    new_constraint = new TransitionConstraint(name, dimension, selector, field, evaluation_window, slide_size, applicability, value_pairs);
                }
            } else if (target.equals(NONSEQKEYREF)) {
                String ref_selector = null;
                String ref_field = null;
                String refer = root.getAttribute("refer");
                String conventional_constraint = root.getAttribute("conventionalConstraint");
                if (conventional_constraint == null || conventional_constraint.equals("")) {
                    Vector<String> selector_field;
                    conventional_constraint = null;
                    if (refer == null || refer.equals("")) {
                        System.err.println("nonseqkeyref definition of " + name + "doesn't have " + "conventionalIdentifier and refer");
                        System.exit(4);
                    }
                    if ((selector_field = TemporalConstraintValidator.ConvertConventionalIdentifier(refer, this.schema_doc_)) == null) {
                        System.exit(3);
                    }
                    ref_selector = selector_field.get(0);
                    ref_field = selector_field.get(1);
                } else {
                    Vector<String> selector_field = TemporalConstraintValidator.ConvertConventionalIdentifier(conventional_constraint, this.schema_doc_);
                    if (selector_field == null) {
                        System.exit(3);
                    }
                    selector = selector_field.get(0);
                    field = selector_field.get(1);
                    String tmp_ref = selector_field.get(2);
                    Vector<String> ref_selector_field = TemporalConstraintValidator.ConvertConventionalIdentifier(tmp_ref, this.schema_doc_);
                    ref_selector = ref_selector_field.get(0);
                    ref_field = ref_selector_field.get(1);
                }
                new_constraint = new ReferentialIntegrityConstraint(name, dimension, selector, field, evaluation_window, slide_size, applicability, conventional_constraint, refer, ref_selector, ref_field);
            }
            results.add(new_constraint);
            return;
        }
        NodeList child_nodes = root.getChildNodes();
        for (int i = 0; i < child_nodes.getLength(); ++i) {
            Node temp_node = child_nodes.item(i);
            if (temp_node.getNodeType() != 1) continue;
            this.ExtractConstraints((Element)temp_node, target, results);
        }
    }

    public static String PrepareXPathString(String selector, String field) {
        return selector + field;
    }

    public static Vector<Node> GetCandidateNodes(Document temporal_doc, String xpath_query, Applicability applicability) {
        Vector<Node> result_nodes = new Vector<Node>();
        if (xpath_query.equals(".")) {
            result_nodes.add(temporal_doc.getDocumentElement());
            return result_nodes;
        }
        try {
            boolean has_attribute = false;
            String attr_name = null;
            int attr_flag = xpath_query.indexOf("@");
            if (attr_flag > 0) {
                has_attribute = true;
                attr_name = xpath_query.substring(attr_flag + 1, xpath_query.length());
                xpath_query = xpath_query.substring(0, attr_flag);
            }
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(xpath_query);
            NodeList candidates = (NodeList)expr.evaluate(temporal_doc, XPathConstants.NODESET);
            for (int i = 0; i < candidates.getLength(); ++i) {
                Node can_node;
                Node tmp_can_node = can_node = candidates.item(i);
                if (has_attribute) {
                    can_node = tmp_can_node.getAttributes().getNamedItem(attr_name);
                }
                if (applicability != null) {
                    String end_time;
                    String start_time;
                    Node par_node = null;
                    while (!(par_node = tmp_can_node.getParentNode()).getNodeName().endsWith("_Version")) {
                        tmp_can_node = par_node;
                        if (par_node != null) continue;
                    }
                    if (par_node == null) {
                        System.err.println("Can't ever identify the timestamp");
                        System.exit(2);
                    }
                    if (!applicability.IsIntersect(start_time = ((Element)par_node).getAttribute("begin"), end_time = ((Element)par_node).getAttribute("end"))) continue;
                    result_nodes.add(can_node);
                    continue;
                }
                result_nodes.add(can_node);
            }
            return result_nodes;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected boolean CheckIdentityConstraint(Document temporal_doc) {
        boolean nonseq_unique = IdentityConstraint.CheckNonSeqUnique(temporal_doc, this.constraint_map_.get(NONSEQUNIQUE));
        boolean nonseq_key = IdentityConstraint.CheckNonSeqKey(temporal_doc, this.constraint_map_.get(NONSEQKEY));
        boolean unique_null_restricted = IdentityConstraint.CheckUniqueNullRestricted(temporal_doc, this.constraint_map_.get(UNIQUENULLRESTRICTED));
        return nonseq_unique && nonseq_key && unique_null_restricted;
    }

    protected boolean CheckCardinalityConstraint(Document temporal_doc) {
        boolean seq_val = CardinalityConstraint.CheckSeqCardinality(temporal_doc, this.constraint_map_.get(SEQCARDINALITY));
        boolean nonseq_val = CardinalityConstraint.CheckNonSeqCardinality(temporal_doc, this.constraint_map_.get(NONSEQCARDINALITY));
        return seq_val && nonseq_val;
    }

    protected boolean CheckRefIntegrityConstraint() {
        return ReferentialIntegrityConstraint.CheckNonSeqKeyRef(this.temporal_doc_, this.schema_doc_, this.constraint_map_.get(NONSEQKEYREF));
    }

    public boolean PerformValidation() {
        this.ExtractConstraint(this.annotation_doc_);
        boolean identity_val = this.CheckIdentityConstraint(this.temporal_doc_);
        boolean cardinality_val = this.CheckCardinalityConstraint(this.temporal_doc_);
        boolean trans_val = TransitionConstraint.CheckTransitionConstraint(this.temporal_doc_, this.constraint_map_.get(TRANSITION));
        boolean refkey_val = this.CheckRefIntegrityConstraint();
        return identity_val && cardinality_val && trans_val && refkey_val;
    }
}

