/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ReferentialIntegrityConstraint
extends Constraint {
    protected String conventional_constraint_;
    protected String refer_;
    protected String ref_selector_;
    protected String ref_field_;

    public ReferentialIntegrityConstraint(String name, String dimension, String selector, String field, int evaluation_window, int slide_size, Applicability applicability, String conventional_constraint, String refer, String ref_selector, String ref_field) {
        super(name, dimension, selector, field, evaluation_window, slide_size, applicability);
        if (refer != null && !refer.equals("")) {
            this.refer_ = refer;
        }
        this.conventional_constraint_ = conventional_constraint;
        this.ref_selector_ = ref_selector;
        this.ref_field_ = ref_field;
        if (this.ref_selector_ != null) {
            if (this.ref_selector_.startsWith("/")) {
                this.ref_selector_ = this.ref_selector_.replaceFirst("/", "//");
            } else if (!this.ref_selector_.equals(".") && !this.ref_selector_.startsWith("//")) {
                this.ref_selector_ = "//" + this.ref_selector_;
            }
        }
        if (this.ref_field_ != null) {
            if (this.ref_field_.startsWith("/")) {
                this.ref_field_ = this.ref_field_.replaceFirst("/", "//");
            } else if (!this.ref_field_.equals(".") && !this.ref_field_.startsWith("//")) {
                this.ref_field_ = "//" + this.ref_field_;
            }
        }
    }

    public String getConventionalConstraint() {
        return this.conventional_constraint_;
    }

    public String getRefer() {
        return this.refer_;
    }

    public String getRefSelector() {
        return this.ref_selector_;
    }

    public String getRefField() {
        return this.ref_field_;
    }

    public static boolean CheckNonSeqKeyRef(Document temporal_doc, Document schema_doc, Vector<Constraint> constraints) {
        if (constraints == null) {
            return true;
        }
        for (Constraint c : constraints) {
            for (Applicability app : c.eval_windows_) {
                try {
                    String keynode_query = TemporalConstraintValidator.PrepareXPathString(((ReferentialIntegrityConstraint)c).getRefSelector(), ((ReferentialIntegrityConstraint)c).getRefField());
                    Vector<Node> all_key_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, keynode_query, app);
                    TreeSet<String> key_value_set = new TreeSet<String>();
                    for (Node n : all_key_nodes) {
                        key_value_set.add(n.getTextContent());
                    }
                    String xpath_query = TemporalConstraintValidator.PrepareXPathString(c.getSelector(), c.getField());
                    Vector<Node> result_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, xpath_query, app);
                    for (Node n : result_nodes) {
                        if (key_value_set.contains(n.getTextContent())) continue;
                        System.err.println("In period " + app.toString() + " [" + c.getName() + "] nonSeqKeyref violation: " + "Key " + n.getTextContent() + " can't " + "be found by keyref definition");
                        return false;
                    }
                    if (result_nodes != null) continue;
                    return false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }
}

