/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.IdentityConstraint;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import cs.arizona.util.ConventionalParser;
import java.util.Vector;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

public class IdentityConstraintTest {
    Document temporal_doc_;
    Document annotation_doc_;
    Document schema_doc_;
    Applicability default_applicability_;
    Vector<Constraint> nonseqkey_constraints_;
    Vector<Constraint> nonsequnique_constraints_;
    Vector<Constraint> uniquenullrestricted_constraints_;
    TemporalConstraintValidator tcv_;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.nonseqkey_constraints_ = new Vector();
        this.nonsequnique_constraints_ = new Vector();
        this.uniquenullrestricted_constraints_ = new Vector();
        String temporalSchema = "test_suites/identity/tempschema.xml";
        Document input_temporal_doc = ConventionalParser.getInstance().parseDocument("test_suites/identity/temporalDocument_squashed.xml", null, null, false);
        this.tcv_ = new TemporalConstraintValidator(input_temporal_doc, temporalSchema);
        this.temporal_doc_ = this.tcv_.GetTemporalDocument();
        this.annotation_doc_ = this.tcv_.GetAnnotationDocument();
        this.tcv_.ExtractConstraints(this.annotation_doc_.getDocumentElement(), "nonSeqKey", this.nonseqkey_constraints_);
        this.tcv_.ExtractConstraints(this.annotation_doc_.getDocumentElement(), "nonSeqUnique", this.nonsequnique_constraints_);
        this.tcv_.ExtractConstraints(this.annotation_doc_.getDocumentElement(), "uniqueNullRestricted", this.uniquenullrestricted_constraints_);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCheckNonSeqKey() {
        int num_constraints = this.nonseqkey_constraints_.size();
        Assert.assertEquals((int)0, (int)num_constraints);
    }

    @Test
    public void testCheckNonSeqUnique() {
        int num_constraints = this.nonsequnique_constraints_.size();
        Assert.assertEquals((int)2, (int)num_constraints);
        Vector<Constraint> constraint1 = new Vector<Constraint>();
        constraint1.add(this.nonsequnique_constraints_.get(0));
        boolean val1 = IdentityConstraint.CheckNonSeqUnique(this.temporal_doc_, constraint1);
        Assert.assertFalse((boolean)val1);
        Vector<Constraint> constraint2 = new Vector<Constraint>();
        constraint2.add(this.nonsequnique_constraints_.get(1));
        boolean val2 = IdentityConstraint.CheckNonSeqUnique(this.temporal_doc_, constraint2);
        Assert.assertFalse((boolean)val2);
    }

    @Test
    public void testCheckUniqueNullRestricted() {
        int num_constraints = this.uniquenullrestricted_constraints_.size();
        Assert.assertEquals((int)0, (int)num_constraints);
    }
}

