/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IdentityConstraint
extends Constraint {
    protected String scope_ = "between";
    protected String conventional_identifier_ = null;
    protected int null_count_min_ = -1;
    protected int null_count_max_ = -1;

    public IdentityConstraint(String name, String dimension, String selector, String field, int evaluation_window, int slide_size, Applicability applicability, String scope, String conventional_identifier, int null_count_min, int null_count_max) {
        super(name, dimension, selector, field, evaluation_window, slide_size, applicability);
        if (scope != null && !scope.equals("")) {
            this.scope_ = scope;
        }
        this.conventional_identifier_ = conventional_identifier;
        this.null_count_min_ = null_count_min;
        this.null_count_max_ = null_count_max;
    }

    public String getScope() {
        return this.scope_;
    }

    public int getNullCountMin() {
        return this.null_count_min_;
    }

    public int getNullCountMax() {
        return this.null_count_max_;
    }

    public static boolean CheckNonSeqUnique(Document temporal_doc, Vector<Constraint> constraints) {
        if (constraints == null) {
            return true;
        }
        for (Constraint c : constraints) {
            for (Applicability app : c.eval_windows_) {
                TreeSet<String> ts;
                String xpath_query = TemporalConstraintValidator.PrepareXPathString(c.getSelector(), c.getField());
                Vector<Node> result_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, xpath_query, app);
                if (result_nodes == null) {
                    return false;
                }
                if (((IdentityConstraint)c).scope_.equals("between")) {
                    ts = new TreeSet<String>();
                    for (Node temp_node : result_nodes) {
                        if (ts.add(temp_node.getTextContent())) continue;
                        System.err.println("In period " + app.toString() + " [" + c.getName() + "] violation of nonSeqUnique " + "(scope=between) duplicated values in node: " + temp_node.getNodeName() + " - " + temp_node.getTextContent());
                        return false;
                    }
                    continue;
                }
                if (!((IdentityConstraint)c).scope_.equals("within")) continue;
                ts = new TreeSet();
                for (Node temp_node : result_nodes) {
                    ts.add(temp_node.getTextContent());
                }
                if (ts.size() <= 1) continue;
                System.err.println("In period " + app.toString() + " [" + c.getName() + "] violation of nonSeqUnique" + "(scope=within) with values: " + ts.toString());
                return false;
            }
        }
        return true;
    }

    public static boolean CheckNonSeqKey(Document temporal_doc, Vector<Constraint> constraints) {
        if (constraints == null) {
            return true;
        }
        for (Constraint c : constraints) {
            for (Applicability app : c.eval_windows_) {
                String value;
                TreeSet<String> ts;
                String xpath_query = TemporalConstraintValidator.PrepareXPathString(c.getSelector(), c.getField());
                Vector<Node> result_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, xpath_query, app);
                if (result_nodes == null) {
                    return false;
                }
                if (((IdentityConstraint)c).scope_.equals("between")) {
                    ts = new TreeSet<String>();
                    for (Node temp_node : result_nodes) {
                        value = temp_node.getTextContent();
                        if (value == null || value.equals("")) {
                            System.err.println("In period " + app.toString() + " [" + c.getName() + "] null value for KEY found.");
                            return false;
                        }
                        if (ts.add(value)) continue;
                        System.err.println("In period " + app.toString() + " [" + c.getName() + "] violation of nonSeqUnique " + "(scope=between) duplicated values in node: " + temp_node.getNodeName() + " - " + temp_node.getTextContent() + " (violating \"between\")");
                        return false;
                    }
                    continue;
                }
                if (!((IdentityConstraint)c).scope_.equals("within")) continue;
                ts = new TreeSet();
                for (Node temp_node : result_nodes) {
                    value = temp_node.getTextContent();
                    if (value == null || value.equals("")) {
                        System.err.println("In period " + app.toString() + " [" + c.getName() + "] null value for KEY found.");
                        return false;
                    }
                    ts.add(value);
                }
                if (ts.size() <= 1) continue;
                System.err.println("In period " + app.toString() + " [" + c.getName() + "] violation of nonSeqUnique (within)");
                return false;
            }
        }
        return true;
    }

    public static boolean CheckUniqueNullRestricted(Document temporal_doc, Vector<Constraint> constraints) {
        if (constraints == null) {
            return true;
        }
        for (Constraint c : constraints) {
            int min_null = ((IdentityConstraint)c).getNullCountMin();
            int max_null = ((IdentityConstraint)c).getNullCountMax();
            if (min_null == -1 && max_null == -1) {
                return true;
            }
            for (Applicability app : c.eval_windows_) {
                String xpath_query = TemporalConstraintValidator.PrepareXPathString(c.getSelector(), c.getField());
                Vector<Node> result_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, xpath_query, app);
                if (result_nodes == null) {
                    return false;
                }
                int null_count = 0;
                for (Node n : result_nodes) {
                    if (!n.getTextContent().equals("null")) continue;
                    ++null_count;
                }
                if (min_null != -1 && null_count < min_null) {
                    System.err.println("In period " + app.toString() + " [" + c.getName() + "] violation of min null value allowed: " + "actual = " + null_count + " min = " + min_null);
                    return false;
                }
                if (max_null == -1 || null_count <= max_null) continue;
                System.err.println("In period " + app.toString() + " [" + c.getName() + "] violation of max null value allowed: " + "actual = " + null_count + " max = " + max_null);
                return false;
            }
        }
        return true;
    }
}

