/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import java.util.Vector;

public class Constraint {
    protected String selector_;
    protected String field_;
    protected String name_;
    protected String dimension_;
    protected int evaluation_window_ = -1;
    protected int slide_size_ = 1;
    protected Applicability general_applicability_;
    protected Vector<Applicability> eval_windows_;

    public Constraint(String name, String dimension, String selector, String field, int evaluation_window, int slide_size, Applicability applicability) {
        this.name_ = name;
        this.dimension_ = dimension;
        this.selector_ = selector;
        this.field_ = field;
        this.evaluation_window_ = evaluation_window;
        this.slide_size_ = slide_size;
        this.general_applicability_ = applicability;
        if (this.selector_ != null) {
            if (this.selector_.startsWith("/")) {
                this.selector_ = this.selector_.replaceFirst("/", "//");
            } else if (!selector.equals(".") && !this.selector_.startsWith("//")) {
                this.selector_ = "//" + this.selector_;
            }
        }
        if (this.field_ != null) {
            if (this.field_.startsWith("/")) {
                this.field_ = this.field_.replaceFirst("/", "//");
            } else if (!(this.field_.equals(".") || this.field_.startsWith("@") || this.field_.startsWith("//"))) {
                this.field_ = "//" + this.field_;
            }
        }
        this.LoadEvaluationWindow(this.general_applicability_);
    }

    public void LoadEvaluationWindow(Applicability applicability) {
        this.eval_windows_ = new Vector();
        if (this.evaluation_window_ == -1) {
            this.eval_windows_.add(new Applicability(applicability.GetStartTime(), applicability.GetEndTime()));
            return;
        }
        String start = applicability.GetStartTime();
        String end = applicability.GetEndTime();
        String current_begin = start;
        String current_end = "";
        while (true) {
            if (Applicability.CompareTime(current_end = Applicability.GetPeriodBound(current_begin, this.evaluation_window_), end) >= 0) {
                this.eval_windows_.add(new Applicability(current_begin, end));
                return;
            }
            this.eval_windows_.add(new Applicability(current_begin, current_end));
            current_begin = Applicability.GetPeriodBound(current_begin, this.slide_size_);
        }
    }

    public String getName() {
        return this.name_;
    }

    public String getDimension() {
        return this.dimension_;
    }

    public String getSelector() {
        return this.selector_;
    }

    public String getField() {
        return this.field_;
    }

    public int getEvaluationWindow() {
        return this.evaluation_window_;
    }

    public int getSlideSize() {
        return this.slide_size_;
    }

    public Applicability getApplicability() {
        return this.general_applicability_;
    }

    public String toString() {
        StringBuffer content_buf = new StringBuffer();
        content_buf.append(this.getName() + ": ");
        content_buf.append(this.getDimension() + " - ");
        content_buf.append(this.getSelector() + " - ");
        content_buf.append(this.getField());
        if (this.general_applicability_ != null) {
            content_buf.append(" [" + this.general_applicability_.GetStartTime() + ", " + this.general_applicability_.GetEndTime() + "]");
        }
        if (this.eval_windows_.size() > 0) {
            content_buf.append(" - evals: " + this.eval_windows_.toString());
        }
        return content_buf.toString();
    }
}

