/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.CardinalityConstraint;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import cs.arizona.util.ConventionalParser;
import java.util.Vector;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

public class CardinalityConstraintTest {
    Document temporal_doc_;
    Document annotation_doc_;
    Document schema_doc_;
    Applicability default_applicability_;
    Vector<Constraint> seq_constraints_;
    Vector<Constraint> nonseq_constraints_;
    TemporalConstraintValidator tcv_;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.seq_constraints_ = new Vector();
        this.nonseq_constraints_ = new Vector();
        String temporalSchema = "test_suites/cardinality/tempschema.xml";
        Document input_temporal_doc = ConventionalParser.getInstance().parseDocument("test_suites/cardinality/temporalDocument_squashed.xml", null, null, false);
        this.tcv_ = new TemporalConstraintValidator(input_temporal_doc, temporalSchema);
        this.temporal_doc_ = this.tcv_.GetTemporalDocument();
        this.annotation_doc_ = this.tcv_.GetAnnotationDocument();
        this.tcv_.ExtractConstraints(this.annotation_doc_.getDocumentElement(), "seqCardinality", this.seq_constraints_);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCheckNonSeqCardinality() {
        int num_constraints = this.nonseq_constraints_.size();
        Assert.assertEquals((int)0, (int)num_constraints);
        boolean val = CardinalityConstraint.CheckNonSeqCardinality(this.temporal_doc_, this.nonseq_constraints_);
        Assert.assertTrue((boolean)val);
    }

    @Test
    public void testCheckSeqCardinality() {
        int num_constraints = this.seq_constraints_.size();
        Assert.assertEquals((int)2, (int)num_constraints);
        Vector<Constraint> constraint1 = new Vector<Constraint>();
        constraint1.add(this.seq_constraints_.get(0));
        Vector<Constraint> constraint2 = new Vector<Constraint>();
        constraint2.add(this.seq_constraints_.get(1));
        boolean val1 = CardinalityConstraint.CheckSeqCardinality(this.temporal_doc_, constraint1);
        Assert.assertFalse((boolean)val1);
        boolean val2 = CardinalityConstraint.CheckSeqCardinality(this.temporal_doc_, constraint2);
        Assert.assertFalse((boolean)val2);
    }
}

