/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml.temporalconstraint;

import cs.arizona.tau.xml.temporalconstraint.Applicability;
import cs.arizona.tau.xml.temporalconstraint.Constraint;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CardinalityConstraint
extends Constraint {
    protected int max_occur_;
    protected int min_occur_ = 0;
    protected boolean new_only_ = false;
    protected String group_;

    public CardinalityConstraint(String name, String dimension, String selector, String field, String group, int evaluation_window, int slide_size, Applicability applicability, boolean new_only, int max_occur, int min_occur) {
        super(name, dimension, selector, field, evaluation_window, slide_size, applicability);
        this.max_occur_ = max_occur;
        this.min_occur_ = min_occur;
        this.new_only_ = new_only;
        this.group_ = group;
    }

    public int getMaxOccur() {
        return this.max_occur_;
    }

    public int getMinOccur() {
        return this.min_occur_;
    }

    public String getGroup() {
        return this.group_;
    }

    public boolean getNewOnly() {
        return this.new_only_;
    }

    public static boolean CheckNonSeqCardinality(Document temporal_doc, Vector<Constraint> constraints) {
        if (constraints == null) {
            return true;
        }
        for (Constraint c : constraints) {
            for (Applicability app : c.eval_windows_) {
                String xpath_query = TemporalConstraintValidator.PrepareXPathString(c.getSelector(), c.getField());
                Vector<Node> result_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, xpath_query, app);
                if (result_nodes == null) {
                    return false;
                }
                if (!((CardinalityConstraint)c).getNewOnly()) {
                    TreeSet<String> distinct_items = new TreeSet<String>();
                    for (Node temp_node : result_nodes) {
                        distinct_items.add(temp_node.getTextContent());
                    }
                    if (distinct_items.size() > ((CardinalityConstraint)c).getMaxOccur()) {
                        System.err.println("In period " + app.toString() + " [" + c.getName() + "] non-seq cardinality violation: " + "max is " + ((CardinalityConstraint)c).getMaxOccur() + " actual is " + distinct_items.size() + "[" + distinct_items.toString());
                        return false;
                    }
                    if (distinct_items.size() >= ((CardinalityConstraint)c).getMinOccur()) continue;
                    System.err.println("In period " + app.toString() + " [" + c.getName() + "] non-seq cardinality violation: " + "min is " + ((CardinalityConstraint)c).getMinOccur() + " actual is " + distinct_items.size() + "[" + distinct_items.toString() + "]");
                    return false;
                }
                int changed_times = 0;
                String prev_node_name = "";
                for (int i = 0; i < result_nodes.size(); ++i) {
                    String curr_node_name = result_nodes.get(i).getTextContent();
                    if (i == 0) {
                        prev_node_name = curr_node_name;
                        continue;
                    }
                    if (curr_node_name.equals(prev_node_name)) continue;
                    ++changed_times;
                    prev_node_name = curr_node_name;
                }
                if (changed_times > ((CardinalityConstraint)c).getMaxOccur()) {
                    System.err.println("In period " + app.toString() + " [" + c.getName() + "] non-seq cardinality violation " + "(new only): max is " + ((CardinalityConstraint)c).getMaxOccur() + " actual is " + changed_times);
                    return false;
                }
                if (changed_times >= ((CardinalityConstraint)c).getMinOccur()) continue;
                System.err.println("In period " + app.toString() + " [" + c.getName() + "] non-seq cardinality violation " + "(new only): min is " + ((CardinalityConstraint)c).getMinOccur() + " actual is " + changed_times);
                return false;
            }
        }
        return true;
    }

    public static boolean CheckSeqCardinality(Document temporal_doc, Vector<Constraint> constraints) {
        if (constraints == null) {
            return true;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (Constraint c : constraints) {
            for (Applicability app : c.eval_windows_) {
                try {
                    boolean use_group = false;
                    String xpath_query = null;
                    use_group = ((CardinalityConstraint)c).getGroup() != null;
                    xpath_query = TemporalConstraintValidator.PrepareXPathString(c.getSelector(), "");
                    Vector<Node> result_nodes = TemporalConstraintValidator.GetCandidateNodes(temporal_doc, xpath_query, app);
                    for (Node tmp_element : result_nodes) {
                        if (!use_group) {
                            XPathExpression exp2 = xpath.compile("." + ((CardinalityConstraint)c).getField());
                            NodeList node_list = (NodeList)exp2.evaluate(tmp_element, XPathConstants.NODESET);
                            TreeSet<String> value_set = new TreeSet<String>();
                            for (int j = 0; j < node_list.getLength(); ++j) {
                                value_set.add(node_list.item(j).getTextContent());
                            }
                            if (value_set.size() > ((CardinalityConstraint)c).getMaxOccur()) {
                                System.err.println("In period " + app.toString() + " [" + c.getName() + "] seq cardinality violation: " + "max is " + ((CardinalityConstraint)c).getMaxOccur() + " actual is " + value_set.size() + "[" + value_set.toString() + "]");
                                return false;
                            }
                            if (value_set.size() >= ((CardinalityConstraint)c).getMinOccur()) continue;
                            System.err.println("In period " + app.toString() + " [" + c.getName() + "] non-seq cardinality violation: " + "min is " + ((CardinalityConstraint)c).getMinOccur() + " actual is " + value_set.size() + "[" + value_set.toString() + "]");
                            return false;
                        }
                        XPathExpression exp_group = xpath.compile(".//" + ((CardinalityConstraint)c).getGroup());
                        XPathExpression exp_individual = xpath.compile("." + ((CardinalityConstraint)c).getField());
                        NodeList group_elements = (NodeList)exp_group.evaluate(tmp_element, XPathConstants.NODESET);
                        TreeSet<String> distinct_elements = new TreeSet<String>();
                        for (int i = 0; i < group_elements.getLength(); ++i) {
                            Node single_group_node = group_elements.item(i);
                            NodeList individual_elements = (NodeList)exp_individual.evaluate(single_group_node, XPathConstants.NODESET);
                            for (int j = 0; j < individual_elements.getLength(); ++j) {
                                distinct_elements.add("[" + i + "]_" + ((Element)individual_elements.item(j)).getTextContent());
                            }
                        }
                        if (distinct_elements.size() > ((CardinalityConstraint)c).getMaxOccur()) {
                            System.err.println("In period " + app.toString() + " [" + c.getName() + "] seq cardinality violation: " + "(with group) max is " + ((CardinalityConstraint)c).getMaxOccur() + " actual is " + distinct_elements.size() + "[" + distinct_elements.toString() + "]");
                            return false;
                        }
                        if (distinct_elements.size() >= ((CardinalityConstraint)c).getMinOccur()) continue;
                        System.err.println("In period " + app.toString() + " [" + c.getName() + "] non-seq cardinality violation: " + "(with group) min is " + ((CardinalityConstraint)c).getMinOccur() + " actual is " + distinct_elements.size() + "[" + distinct_elements.toString() + "]");
                        return false;
                    }
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }
}

