/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.DecomposedRepresentationFactory;
import cs.arizona.tau.xml.IDoUnSquashing;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TauLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Element;

public class UnSquash {
    public static void main(String[] args) {
        long t1 = System.nanoTime();
        ConventionalParser cp = ConventionalParser.getInstance();
        String snapshotFile = "";
        String start = "";
        String end = "";
        String temporalDocument = "";
        boolean schemaVersioningFlag = false;
        TauLogger.init();
        TauLogger.setLevel(1);
        if (args.length < 2) {
            System.out.println("usage: unsquash [-o outFile] [-d debugLevel] temp_data_dir squashed_document");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                ++i;
            }
            if (args[i].equals("-s")) {
                schemaVersioningFlag = Boolean.parseBoolean(args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].equals("-d")) continue;
            TauLogger.setLevel(Integer.parseInt(args[i + 1]));
            ++i;
        }
        String tempDataDir = args[args.length - 2];
        temporalDocument = args[args.length - 1];
        Common.checkFileExists(tempDataDir + "/" + temporalDocument);
        TauLogger.logger.info((Object)("Unsquashing documents (schemaVersioningFlag = " + schemaVersioningFlag + ")..."));
        DecomposedRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
        IDoUnSquashing doUnSquashing = iRepFactory.createUnSquashingObj(tempDataDir, temporalDocument, schemaVersioningFlag);
        Hashtable snapshots = doUnSquashing.unSquash(tempDataDir, temporalDocument);
        if (snapshots == null) {
            TauLogger.logger.fatal((Object)"No snapshots could be created.");
            System.exit(2);
        }
        Enumeration enumeration = snapshots.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            ITimePeriod tp = (ITimePeriod)enumeration.nextElement();
            Element e = (Element)snapshots.get(tp);
            start = Common.formatDate(tp.getBeginDate());
            end = Common.formatDate(tp.getEndDate());
            snapshotFile = tempDataDir + "/slice" + "_" + start + "_" + end + ".xml";
            cp.writeElement(e, snapshotFile);
            ++i;
        }
        TauLogger.logger.info((Object)"Done.");
        long t2 = System.nanoTime();
        Common.printElaspedTime("Unsquash", t1, t2);
    }
}

