/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.DecomposedRepresentationFactory;
import cs.arizona.tau.xml.IDoTemporalValidation;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TauLogger;

public class TemporalValidator {
    public static void main(String[] args) {
        long t1 = System.nanoTime();
        boolean schemaVersioningFlag = false;
        ConventionalParser cp = ConventionalParser.getInstance();
        TauLogger.init();
        TauLogger.setLevel(1);
        if (args.length < 2) {
            System.out.println("usage: txmllint [-s schemaVersFlag] [-d debugLevel] temp_data_dir temporal_document");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-s")) {
                schemaVersioningFlag = Boolean.parseBoolean(args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].equals("-d")) continue;
            TauLogger.setLevel(Integer.parseInt(args[i + 1]));
            ++i;
        }
        String temp_data_dir = args[args.length - 2];
        String temporalDocument = args[args.length - 1];
        Common.checkFileExists(temp_data_dir + "/" + temporalDocument);
        TauLogger.logger.info((Object)("Validating document " + temporalDocument + "..."));
        DecomposedRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
        IDoTemporalValidation doTemporalValidation = iRepFactory.createTemporalValidationObj(temp_data_dir, temporalDocument, schemaVersioningFlag);
        if (doTemporalValidation.validate(temp_data_dir, temporalDocument)) {
            System.out.println(temp_data_dir + "/" + temporalDocument + " validates");
        } else {
            System.out.println(temporalDocument + " fails to validate");
        }
        long t2 = System.nanoTime();
        Common.printElaspedTime("tXMLLint", t1, t2);
    }
}

