/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.DecomposedRepresentationFactory;
import cs.arizona.tau.xml.IDoSquashing;
import cs.arizona.util.TauLogger;

public class Squash {
    public static void main(String[] args) {
        long t1 = System.nanoTime();
        TauLogger.init();
        TauLogger.setLevel(1);
        if (args.length < 2) {
            System.out.println("usage: squash [-o outputFile] [-s schemaVersFlag] [-d debugLevel] temp_data_dir temporal_file");
            System.exit(1);
        }
        String tempDataDir = args[args.length - 2];
        String tempDataFile = args[args.length - 1];
        Common.checkFileExists(tempDataDir + "/" + tempDataFile);
        String outName = tempDataFile.substring(0, tempDataFile.indexOf(".xml")) + "_squashed.xml";
        boolean schemaVersioningFlag = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                outName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-s")) {
                schemaVersioningFlag = Boolean.parseBoolean(args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].equals("-d")) continue;
            TauLogger.setLevel(Integer.parseInt(args[i + 1]));
            ++i;
        }
        TauLogger.logger.info((Object)("Squashing documents (schemaVersioningFlag = " + schemaVersioningFlag + ")..."));
        DecomposedRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
        IDoSquashing doSquashing = iRepFactory.createSquashingObj(tempDataDir, tempDataFile, schemaVersioningFlag);
        doSquashing.setOutputFileName(tempDataDir, outName);
        doSquashing.squash(tempDataDir, tempDataFile);
        TauLogger.logger.info((Object)"Done.");
        long t2 = System.nanoTime();
        Common.printElaspedTime("Squash", t1, t2);
    }
}

