/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.xml.BaseItem;
import cs.arizona.tau.xml.Item;
import cs.arizona.tau.xml.ItemIdentifier;
import cs.arizona.tau.xml.ItemIdentifierCorr;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.RepItem;
import cs.arizona.util.TargetIdentifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

public class SchemaItem {
    private ArrayList itemList = new ArrayList();

    public void SchemaItem() {
    }

    public boolean canBeBridged(Item dataItem, ArrayList itemIdCorrList, int numScp) {
        Hashtable itemIdCorrMap = (Hashtable)itemIdCorrList.get(numScp);
        Item itemFragment = (Item)this.itemList.get(numScp - 1);
        ItemIdentifierCorr itemIdCorr = (ItemIdentifierCorr)itemIdCorrMap.get(dataItem.getItemIdentifier().getName());
        if (null != itemIdCorr) {
            if (itemFragment.getItemIdentifier().getName().equals(itemIdCorr.getOldRef())) {
                return this.canBeBridged(itemFragment, dataItem, itemIdCorr.getMappingType());
            }
            return false;
        }
        return itemFragment.getItemIdentifier().equals(dataItem.getItemIdentifier());
    }

    private boolean canBeBridged(Item oldDataItem, Item newDataItem, String mappingType) {
        if ("useOld".equals(mappingType)) {
            Element newVersion = newDataItem.getVersion(0);
            return this.canBeBridged(oldDataItem.getItemIdentifier(), newVersion);
        }
        if ("useNew".equals(mappingType)) {
            Element oldVersion = oldDataItem.getVersion(oldDataItem.getVersionCount() - 1);
            return this.canBeBridged(newDataItem.getItemIdentifier(), oldVersion);
        }
        if ("useBoth".equals(mappingType)) {
            return oldDataItem.getItemIdentifier().getFieldValue().equals(newDataItem.getItemIdentifier().getFieldValue());
        }
        return false;
    }

    private boolean canBeBridged(ItemIdentifier ii, Element version) {
        XPathEvaluatorImpl evaluator = new XPathEvaluatorImpl(version.getOwnerDocument());
        XPathNSResolver resolver = evaluator.createNSResolver(version.getOwnerDocument());
        Hashtable fieldTable = ii.getFieldTable();
        Enumeration enum1 = fieldTable.keys();
        while (enum1.hasMoreElements()) {
            String fieldPath = (String)enum1.nextElement();
            if (fieldPath.endsWith("text")) {
                fieldPath = fieldPath + "()";
                String tempFieldValue = "";
                XPathResult result = (XPathResult)evaluator.evaluate(fieldPath, version, resolver, (short)5, null);
                Node n = result.iterateNext();
                if (n != null) {
                    tempFieldValue = tempFieldValue + n.getNodeValue();
                }
                if (tempFieldValue.equals(fieldTable.get(fieldPath))) continue;
                return false;
            }
            XPathResult result = (XPathResult)evaluator.evaluate(fieldPath, version, resolver, (short)5, null);
            Node n = result.iterateNext();
            if (n == null || n.getNodeValue().equals(fieldTable.get(fieldPath))) continue;
            return false;
        }
        return true;
    }

    public void addItem(Item dataItem, int scpIndex) {
        if (this.itemList.size() < scpIndex) {
            for (int i = this.itemList.size(); i < scpIndex; ++i) {
                this.itemList.add(i, null);
            }
        }
        this.itemList.add(scpIndex, dataItem);
    }

    public boolean validate(ArrayList<TargetIdentifier> tiList, ArrayList<LogicalAnnotationValidator> tavList, Hashtable itemFragmentItemMap) {
        boolean valid = true;
        int i = 0;
        int j = 0;
        Item dataItem1 = null;
        Item dataItem2 = null;
        Iterator itr = this.itemList.iterator();
        while (itr.hasNext() && null == (dataItem2 = (Item)itr.next())) {
            ++j;
        }
        while (itr.hasNext()) {
            dataItem1 = dataItem2;
            i = j;
            dataItem2 = null;
            while (itr.hasNext() && null == (dataItem2 = (Item)itr.next())) {
                ++j;
            }
            if (null == dataItem2) break;
            if (BaseItem.CONTENT_CONSTANT != dataItem1.getContent() || BaseItem.CONTENT_CONSTANT != dataItem2.getContent()) continue;
            TargetIdentifier ti1 = tiList.get(i);
            TargetIdentifier ti2 = tiList.get(j);
            LogicalAnnotationValidator tav1 = tavList.get(i);
            LogicalAnnotationValidator tav2 = tavList.get(j);
            if (this.haveConstantSchemas(dataItem1.getTarget(), dataItem2.getTarget(), ti1, ti2, tav1, tav2)) {
                valid = this.areContentConstant(dataItem1.getVersion(dataItem1.getVersionCount() - 1), dataItem2.getVersion(dataItem2.getVersionCount() - 1), tav1, tav2, itemFragmentItemMap);
                continue;
            }
            valid = true;
        }
        return valid;
    }

    public boolean existsVersion(int index) {
        return null != this.itemList.get(index);
    }

    public Item getItemFragment(int numScp) {
        return (Item)this.itemList.get(numScp);
    }

    private boolean haveConstantSchemas(String path1, String path2, TargetIdentifier ti1, TargetIdentifier ti2, LogicalAnnotationValidator tav1, LogicalAnnotationValidator tav2) {
        boolean areConstant = true;
        Hashtable<String, Element> ht1 = ti1.getChildAttributes(path1);
        Hashtable<String, Element> ht2 = ti2.getChildAttributes(path2);
        Enumeration<String> enum1 = ht1.keys();
        while (enum1.hasMoreElements() && areConstant) {
            String attrName = enum1.nextElement();
            Element attrElement1 = ht1.get(attrName);
            Element attrElement2 = ht2.get(attrName);
            areConstant = this.areSameElements(attrElement1, attrElement2);
        }
        if (areConstant) {
            ArrayList<Element> elementList1 = ti1.getChildElements(path1);
            ArrayList<Element> elementList2 = ti1.getChildElements(path1);
            if (elementList1.size() == elementList2.size()) {
                for (int i = 0; i < elementList1.size() && areConstant; ++i) {
                    Element e2;
                    Element e1 = elementList1.get(i);
                    if (!this.areSameElements(e1, e2 = elementList2.get(i))) continue;
                    String newPath1 = path1 + "/" + e1.getLocalName();
                    String newPath2 = path2 + "/" + e2.getLocalName();
                    if (tav1.containsTarget(newPath1) == tav2.containsTarget(newPath2)) {
                        if (tav1.containsTarget(newPath1)) continue;
                        areConstant = this.haveConstantSchemas(newPath1, newPath2, ti1, ti2, tav1, tav2);
                        continue;
                    }
                    areConstant = false;
                }
            } else {
                areConstant = false;
            }
        }
        return areConstant;
    }

    private boolean areContentConstant(Element e1, Element e2, LogicalAnnotationValidator tav1, LogicalAnnotationValidator tav2, Hashtable itemFragmentItemMap) {
        int i;
        String targetName1 = "";
        String targetName2 = "";
        if ("y".equals(e1.getAttribute("isItem"))) {
            targetName1 = e1.getAttribute("originalElement");
            targetName2 = e2.getAttribute("originalElement");
        } else {
            targetName1 = e1.getLocalName();
            targetName2 = e2.getLocalName();
        }
        if ("y".equals(e1.getAttribute("isItem")) && "y".equals(e2.getAttribute("isItem"))) {
            Item item1 = tav1.getItemPrototype(targetName1);
            RepItem repItem1 = new RepItem(e1, targetName1);
            item1.addVersionAll(repItem1.getVersions(), repItem1.getTemporalElement());
            item1.getItemIdentifier().updateFieldValues(item1.getVersion(0));
            Item item2 = tav2.getItemPrototype(targetName2);
            RepItem repItem2 = new RepItem(e2, targetName2);
            item2.addVersionAll(repItem2.getVersions(), repItem2.getTemporalElement());
            item2.getItemIdentifier().updateFieldValues(item2.getVersion(0));
            return itemFragmentItemMap.get(item1) == itemFragmentItemMap.get(item2);
        }
        NodeList nl = e1.getChildNodes();
        ArrayList<Node> nonAttrNodes1 = new ArrayList<Node>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            if (nl.item(i2).getNodeType() != 1 && nl.item(i2).getNodeType() != 3) continue;
            nonAttrNodes1.add(nl.item(i2));
        }
        NamedNodeMap nnm = e1.getAttributes();
        Attr attr = null;
        for (int i3 = 0; i3 < nnm.getLength(); ++i3) {
            attr = (Attr)nnm.item(i3);
            if (e2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        nl = e2.getChildNodes();
        ArrayList<Node> nonAttrNodes2 = new ArrayList<Node>();
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 && nl.item(i).getNodeType() != 3) continue;
            nonAttrNodes2.add(nl.item(i));
        }
        nnm = e1.getAttributes();
        attr = null;
        for (i = 0; i < nnm.getLength(); ++i) {
            attr = (Attr)nnm.item(i);
            if (e2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        if (nonAttrNodes1.size() == nonAttrNodes2.size()) {
            for (i = 0; i < nonAttrNodes1.size(); ++i) {
                Node n = (Node)nonAttrNodes1.get(i);
                Node m = (Node)nonAttrNodes2.get(i);
                if (n.getNodeType() == 3) {
                    if (m.getNodeType() == 3) {
                        if (m.getNodeValue().equals(n.getNodeValue())) continue;
                        return false;
                    }
                    return false;
                }
                if (!m.getNodeName().equals(n.getNodeName())) {
                    return false;
                }
                if (this.areContentConstant((Element)n, (Element)m, tav1, tav2, itemFragmentItemMap)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean areSameElements(Element e1, Element e2) {
        int i;
        NodeList nl = e1.getChildNodes();
        ArrayList<Node> nonAttrNodes1 = new ArrayList<Node>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            if (nl.item(i2).getNodeType() != 1 && nl.item(i2).getNodeType() != 3) continue;
            nonAttrNodes1.add(nl.item(i2));
        }
        NamedNodeMap nnm = e1.getAttributes();
        Attr attr = null;
        for (int i3 = 0; i3 < nnm.getLength(); ++i3) {
            attr = (Attr)nnm.item(i3);
            if (e2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        nl = e2.getChildNodes();
        ArrayList<Node> nonAttrNodes2 = new ArrayList<Node>();
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 && nl.item(i).getNodeType() != 3) continue;
            nonAttrNodes2.add(nl.item(i));
        }
        nnm = e1.getAttributes();
        attr = null;
        for (i = 0; i < nnm.getLength(); ++i) {
            attr = (Attr)nnm.item(i);
            if (e2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        if (nonAttrNodes1.size() == nonAttrNodes2.size()) {
            for (i = 0; i < nonAttrNodes1.size(); ++i) {
                Node n = (Node)nonAttrNodes1.get(i);
                Node m = (Node)nonAttrNodes2.get(i);
                if (n.getNodeType() == 3) {
                    if (m.getNodeType() == 3) {
                        if (m.getNodeValue().equals(n.getNodeValue())) continue;
                        return false;
                    }
                    return false;
                }
                if (m.getNodeName().equals(n.getNodeName())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

