/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TemporalRegion;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.BaseItem;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepItem
extends BaseItem {
    protected int timeRepresentation;

    public RepItem() {
    }

    public RepItem(RepItem repItem) {
        super(repItem);
        this.timeRepresentation = repItem.timeRepresentation;
    }

    public RepItem(String target, int timeDimension, int timeRepresentation) {
        this.target = target;
        this.timeDimension = timeDimension;
        this.timeRepresentation = timeRepresentation;
        this.temporalElement.setNumDimensions(timeDimension);
    }

    public String toString() {
        return super.toString();
    }

    public RepItem(Element xmlRepItemSchemaElement) {
        this.target = xmlRepItemSchemaElement.getAttribute("target");
        NodeList nl1 = xmlRepItemSchemaElement.getChildNodes();
        for (int i = 0; i < nl1.getLength(); ++i) {
            Element childElement;
            if (nl1.item(i).getNodeType() != 1 || (childElement = (Element)nl1.item(i)).getLocalName() != "stampKind") continue;
            this.timeDimension = childElement.getAttribute("timeDimension") == "valid" ? 2 : (childElement.getAttribute("timeDimension") == "transaction" ? 1 : 3);
            this.timeRepresentation = childElement.getAttribute("stampBounds") == "stamp" ? 1 : 2;
        }
    }

    public RepItem(Node repItemElement, String target) {
        this.target = target;
        NodeList nl = repItemElement.getChildNodes();
        long time_tag = System.currentTimeMillis();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            Element childElement = (Element)nl.item(i);
            this.addVersion(childElement);
        }
        this.timeRepresentation = 1;
    }

    @Override
    public int getTimeDimension() {
        return this.timeDimension;
    }

    @Override
    public void setTimeDimension(int timeDimension) {
        this.timeDimension = timeDimension;
    }

    public int getTimeRepresentation() {
        return this.timeRepresentation;
    }

    public void setTimeRepresentation(int timeRepresentation) {
        this.timeRepresentation = timeRepresentation;
    }

    public Element toXML(Document doc, String repSchemaNameAlias) {
        Element repItemElement = doc.createElement(repSchemaNameAlias + this.target + "_RepItem");
        repItemElement.setAttribute("isItem", "y");
        repItemElement.setAttribute("originalElement", this.target);
        Iterator teIterator = this.temporalElement.iterator();
        Iterator versionsIterator = this.versions.iterator();
        while (versionsIterator.hasNext()) {
            Element currVersion = (Element)((Element)versionsIterator.next()).cloneNode(true);
            ITime time1 = (ITime)teIterator.next();
            repItemElement.appendChild(this.toXMLVersion(currVersion, time1, doc));
        }
        return repItemElement;
    }

    public void chopVersions(ITimePeriod tp) {
        Iterator versionIterator = this.versions.iterator();
        Iterator teIterator = this.temporalElement.iterator();
        ArrayList<Element> versionsToRemove = new ArrayList<Element>();
        ArrayList<ITimePeriod> timePeriodToRemove = new ArrayList<ITimePeriod>();
        while (teIterator.hasNext() && versionIterator.hasNext()) {
            ITimePeriod tp1 = (ITimePeriod)teIterator.next();
            Element version = (Element)versionIterator.next();
            int relationship = tp1.getRelationship(tp);
            if (relationship <= 0) {
                versionsToRemove.add(version);
                timePeriodToRemove.add(tp1);
                continue;
            }
            switch (relationship) {
                case 1: {
                    tp1.setBeginDate(tp.getBeginDate());
                    break;
                }
                case 2: {
                    tp1.setEndDate(tp.getEndDate());
                    break;
                }
                case 5: {
                    tp1.setEndDate(tp.getEndDate());
                    break;
                }
                case 7: {
                    tp1.setBeginDate(tp.getBeginDate());
                    break;
                }
                case 9: {
                    tp1.setBeginDate(tp.getBeginDate());
                    tp1.setEndDate(tp.getEndDate());
                }
            }
        }
        versionIterator = versionsToRemove.iterator();
        teIterator = timePeriodToRemove.iterator();
        while (teIterator.hasNext() && versionIterator.hasNext()) {
            this.versions.remove(versionIterator.next());
            this.temporalElement.remove((ITime)teIterator.next());
        }
    }

    private int getTimeDimensionFromXML(Element e) {
        String name = e.getNodeName();
        if ("timeStamp_TransExtent".equalsIgnoreCase(name = name.substring(name.indexOf(58) + 1)) || "timeStamp_TransStep".equalsIgnoreCase(name)) {
            return 1;
        }
        if ("timeStamp_ValidExtent".equalsIgnoreCase(name) || "timeStamp_ValidStep".equalsIgnoreCase(name)) {
            return 2;
        }
        return 0;
    }

    private void addVersion(Element xmlVersionElement) {
        NodeList nl = xmlVersionElement.getChildNodes();
        Element e = null;
        ITime validPeriod = null;
        TimePeriod transactionPeriod = null;
        if (!xmlVersionElement.getAttribute("begin").equals("") && !xmlVersionElement.getAttribute("end").equals("")) {
            transactionPeriod = new TimePeriod(xmlVersionElement.getAttribute("begin"), xmlVersionElement.getAttribute("end"));
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currElement;
            if (nl.item(i).getNodeType() != 1 || this.getTimeDimensionFromXML(currElement = (Element)nl.item(i)) != 0) continue;
            e = currElement;
        }
        this.versions.add(e);
        if (validPeriod != null && transactionPeriod != null) {
            TemporalRegion tr = new TemporalRegion();
            this.temporalElement.add(tr);
            this.temporalElement.setNumDimensions(2);
            this.timeDimension = 3;
        } else if (validPeriod != null) {
            this.temporalElement.add(validPeriod);
            this.timeDimension = 2;
            this.temporalElement.setNumDimensions(1);
        } else {
            this.temporalElement.add(transactionPeriod);
            this.timeDimension = 1;
            this.temporalElement.setNumDimensions(1);
        }
    }

    private Element toXMLVersion(Element e, ITime time1, Document doc) {
        Element versionElement = doc.createElement(this.target + "_Version");
        if ("cs.arizona.tau.time.TimePeriod".equals(time1.getClass().getName())) {
            TimePeriod tp = (TimePeriod)time1;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            versionElement.setAttribute("begin", sdf.format(tp.getBeginDate()));
            versionElement.setAttribute("end", sdf.format(tp.getEndDate()));
        } else {
            TemporalRegion tr = (TemporalRegion)time1;
            versionElement.appendChild(tr.getTransactionPeriod().toXML(1, this.timeRepresentation, doc));
            versionElement.appendChild(tr.getTransactionPeriod().toXML(2, this.timeRepresentation, doc));
        }
        if (e != null) {
            versionElement.appendChild(e);
        }
        return versionElement;
    }
}

