/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.ITemporalElement;
import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TemporalElement;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.Item;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.tau.xml.RepItem;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathNSResolver;

public class Primitives {
    private Document bundleDoc;
    private String temporalBundle;
    private Document temporalDoc;
    private TargetIdentifier ti;
    private LogicalAnnotationValidator tav;
    private PhysicalAnnotationValidator pav;
    private XPathEvaluator evaluator;
    private XPathNSResolver resolver;
    private ConventionalParser cp;
    private ValidatorProperties vp;
    private String repSchemaNameAlias;
    private int cnt = 0;

    public Primitives(Document bundleDoc, String repSchemaNameAlias) {
        this.bundleDoc = bundleDoc;
        this.repSchemaNameAlias = repSchemaNameAlias;
    }

    public Primitives(TargetIdentifier ti, LogicalAnnotationValidator tav, PhysicalAnnotationValidator pav, String repSchemaNameAlias) {
        this.ti = ti;
        this.tav = tav;
        this.pav = pav;
        this.init();
        this.repSchemaNameAlias = repSchemaNameAlias;
    }

    private void init() {
        this.cp = ConventionalParser.getInstance();
        this.vp = ValidatorProperties.getInstance();
    }

    public Element physicalToTemporalConversion_Rui(Document temporalDoc) {
        RepItem rootRepItem;
        this.temporalDoc = temporalDoc;
        Element temporalRoot = temporalDoc.getDocumentElement();
        TimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
        Element originalRoot = null;
        NodeList nl = temporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!Common.isElement(nl.item(i))) continue;
            originalRoot = (Element)nl.item(i);
            TauLogger.logger.info((Object)("Found original root of non-temp document: " + originalRoot.getNodeName()));
            break;
        }
        long t1p = System.nanoTime();
        TauLogger.logger.info((Object)"Marking items");
        this.markItems(originalRoot, tp, "");
        long t2p = System.nanoTime();
        Common.printElaspedTime("      MarkItems", t1p, t2p);
        String target = "";
        Element newRoot = null;
        if ("y".equals(originalRoot.getAttribute("isItem"))) {
            target = originalRoot.getAttribute("originalElement");
            rootRepItem = new RepItem(originalRoot, target);
            TauLogger.logger.info((Object)("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " + rootRepItem.toString()));
            long t1c = System.nanoTime();
            newRoot = this.pushDown(rootRepItem);
            long t2c = System.nanoTime();
            Common.printElaspedTime("      PushDown", t1c, t2c);
        } else {
            target = originalRoot.getLocalName();
            rootRepItem = new RepItem(target, 1, 1);
            rootRepItem.addVersion(originalRoot, tp);
            TauLogger.logger.info((Object)("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " + rootRepItem.toString()));
            long t1c = System.nanoTime();
            newRoot = this.pushDown(rootRepItem);
            long t2c = System.nanoTime();
            Common.printElaspedTime("      PushDown", t1c, t2c);
        }
        temporalRoot.replaceChild(newRoot, originalRoot);
        long t1c = System.nanoTime();
        this.coalsceDocument(newRoot);
        long t2c = System.nanoTime();
        Common.printElaspedTime("      Coalesce", t1c, t2c);
        return temporalRoot;
    }

    public Element physicalToTemporalConversion(Document temporalDoc) {
        RepItem rootRepItem;
        this.temporalDoc = temporalDoc;
        Element temporalRoot = temporalDoc.getDocumentElement();
        TimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
        Element originalRoot = null;
        NodeList nl = temporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equals("temporalSchemaSet") || !Common.isElement(nl.item(i))) continue;
            originalRoot = (Element)nl.item(i);
            TauLogger.logger.info((Object)("Found original root of non-temp document: " + originalRoot.getNodeName()));
            break;
        }
        long t1p = System.nanoTime();
        TauLogger.logger.info((Object)"Marking items");
        this.markItems(originalRoot, tp, "");
        long t2p = System.nanoTime();
        Common.printElaspedTime("      MarkItems", t1p, t2p);
        String target = "";
        Element newRoot = null;
        if ("y".equals(originalRoot.getAttribute("isItem"))) {
            target = originalRoot.getAttribute("originalElement");
            rootRepItem = new RepItem(originalRoot, target);
            TauLogger.logger.info((Object)("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " + rootRepItem.toString()));
            long t1c = System.nanoTime();
            newRoot = this.pushDown(rootRepItem);
            long t2c = System.nanoTime();
            Common.printElaspedTime("      PushDown", t1c, t2c);
        } else {
            target = originalRoot.getLocalName();
            rootRepItem = new RepItem(target, 1, 1);
            rootRepItem.addVersion(originalRoot, tp);
            TauLogger.logger.info((Object)("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " + rootRepItem.toString()));
            long t1c = System.nanoTime();
            newRoot = this.pushDown(rootRepItem);
            long t2c = System.nanoTime();
            Common.printElaspedTime("      PushDown", t1c, t2c);
        }
        temporalRoot.replaceChild(newRoot, originalRoot);
        long t1c = System.nanoTime();
        this.coalsceDocument(newRoot);
        long t2c = System.nanoTime();
        Common.printElaspedTime("      Coalesce", t1c, t2c);
        return temporalRoot;
    }

    public Element rootToPhysicalConversion(Document temporalDoc) {
        this.temporalDoc = temporalDoc;
        Element temporalRoot = temporalDoc.getDocumentElement();
        TimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
        Element originalRoot = null;
        NodeList nl = temporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            originalRoot = (Element)nl.item(i);
            TauLogger.logger.info((Object)("Found original root of non-temp document: " + originalRoot.getNodeName()));
            break;
        }
        this.markItems2(originalRoot, tp, "");
        String targetName = "";
        Element newRoot = null;
        if ("y".equals(originalRoot.getAttribute("isItem"))) {
            targetName = originalRoot.getAttribute("originalElement");
            RepItem rootRepItem = new RepItem(originalRoot, targetName);
            TauLogger.logger.info((Object)("Pushing down RepItem with  " + originalRoot.getNodeName() + " " + targetName));
            newRoot = this.pushDown2(rootRepItem);
        } else {
            targetName = originalRoot.getLocalName();
            RepItem rootRepItem = new RepItem(targetName, 1, 1);
            rootRepItem.addVersion(originalRoot, tp);
            newRoot = this.pushDown2(rootRepItem);
        }
        temporalRoot.removeChild(temporalRoot.getFirstChild());
        temporalRoot.appendChild(newRoot);
        return temporalRoot;
    }

    public void markItems2(Element e, ITime time1, String path) {
        String newPath = "";
        newPath = "y".equals(e.getAttribute("isItem")) ? path + "/" + e.getAttribute("originalElement") : path + "/" + e.getLocalName();
        RepItem repItem = null;
        if (this.pav.containsTarget(newPath)) {
            if (!newPath.equals("/inventory")) {
                Item item = new Item(e, true);
                item.getItemIdentifier().updateFieldValues(e, this.temporalDoc);
                item.addVersion((Element)e.cloneNode(true), time1);
                repItem = item.toRepItem(1);
                e.getParentNode().replaceChild(repItem.toXML(this.temporalDoc, this.repSchemaNameAlias), e);
            } else {
                repItem = new RepItem(e, newPath);
            }
            Iterator versionIterator = repItem.getVersionIterator();
            Iterator teIterator = repItem.getTemporalElement().iterator();
            while (versionIterator.hasNext()) {
                Element currVersion = (Element)versionIterator.next();
                ITime currTime1 = (ITime)teIterator.next();
                NodeList nl = currVersion.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (!Common.isElement(nl.item(i))) continue;
                    Element currElement = (Element)nl.item(i);
                    this.markItems2(currElement, currTime1, newPath);
                }
            }
        } else {
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!Common.isElement(nl.item(i))) continue;
                this.markItems2((Element)nl.item(i), time1, newPath);
            }
        }
    }

    public Element pushDown2(RepItem repItem) {
        String path = repItem.getTarget();
        if (this.pav.containsTarget(path)) {
            this.processChildElements(repItem);
            return repItem.toXML(this.temporalDoc, this.repSchemaNameAlias);
        }
        if (repItem.getVersionCount() == 1) {
            this.processChildElements(repItem);
        } else {
            this.mergeVersions(repItem);
            this.processChildElements(repItem);
        }
        return repItem.getVersion(0);
    }

    private void processChildElements(RepItem repItem) {
        String target = repItem.getTarget();
        TauLogger.logger.info((Object)("Processesing target " + target));
        Iterator versionIterator = repItem.getVersionIterator();
        Iterator teIterator = repItem.getTemporalElement().iterator();
        while (versionIterator.hasNext()) {
            ArrayList<Element> childElementList = new ArrayList<Element>();
            Element ev = (Element)versionIterator.next();
            ITime time1 = (ITime)teIterator.next();
            NodeList nl = ev.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                RepItem childRepItem;
                if (nl.item(i).getNodeType() != 1) continue;
                Element currElement = (Element)nl.item(i);
                String targetName = "";
                if (currElement.getAttribute("isItem") == "y") {
                    targetName = currElement.getAttribute("originalElement");
                    childRepItem = new RepItem(currElement, targetName);
                    childElementList.add(this.pushDown(childRepItem));
                    continue;
                }
                targetName = currElement.getLocalName();
                childRepItem = new RepItem(targetName, repItem.getTimeDimension(), repItem.getTimeRepresentation());
                childRepItem.addVersion(currElement, time1);
                childElementList.add(this.pushDown(childRepItem));
            }
            int childElementListCounter = 0;
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                Element e1 = (Element)childElementList.get(childElementListCounter);
                Node e2 = nl.item(i);
                ev.replaceChild(e1, e2);
                ++childElementListCounter;
            }
        }
    }

    public void markItems_Rui(Element e, ITime time1, String target) {
        TauLogger.logger.info((Object)("Marking items of element " + e.getLocalName()));
        String targetName = "";
        targetName = "y".equals(e.getAttribute("isItem")) ? e.getAttribute("originalElement") : e.getLocalName();
        RepItem repItem = null;
        if (this.pav.containsTarget(targetName)) {
            if (targetName.equals("person")) {
                System.out.println("Rui Stop");
            }
            repItem = new RepItem(e, targetName);
        } else if (this.tav.containsTarget(targetName)) {
            Item item = this.tav.getItemPrototype(targetName);
            item.getItemIdentifier().updateFieldValues(e, this.temporalDoc);
            item.addVersion((Element)e.cloneNode(true), time1);
            repItem = item.toRepItem(1);
            e.getParentNode().replaceChild(repItem.toXML(this.temporalDoc, this.repSchemaNameAlias), e);
        }
        if (this.tav.containsTarget(targetName) || this.pav.containsTarget(targetName)) {
            Iterator versionIterator = repItem.getVersionIterator();
            Iterator teIterator = repItem.getTemporalElement().iterator();
            while (versionIterator.hasNext()) {
                Element currVersion = (Element)versionIterator.next();
                System.err.println(currVersion.getTagName() + ": " + currVersion.getTextContent());
                ITime currTime1 = (ITime)teIterator.next();
                NodeList nl = currVersion.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getNodeType() != 1) continue;
                    this.markItems((Element)nl.item(i), currTime1, targetName);
                }
            }
        } else {
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                this.markItems((Element)nl.item(i), time1, targetName);
            }
        }
    }

    public void markItems(Element e, ITime time1, String target) {
        TauLogger.logger.info((Object)("Marking items of element " + e.getLocalName()));
        String targetName = "";
        targetName = "y".equals(e.getAttribute("isItem")) ? e.getAttribute("originalElement") : e.getLocalName();
        RepItem repItem = null;
        if (this.pav.containsTarget(targetName)) {
            repItem = new RepItem(e, targetName);
        } else if (this.tav.containsTarget(targetName)) {
            Item item = this.tav.getItemPrototype(targetName);
            item.getItemIdentifier().updateFieldValues(e, this.temporalDoc);
            item.addVersion((Element)e.cloneNode(true), time1);
            repItem = item.toRepItem(1);
            e.getParentNode().replaceChild(repItem.toXML(this.temporalDoc, this.repSchemaNameAlias), e);
        }
        if (this.tav.containsTarget(targetName) || this.pav.containsTarget(targetName)) {
            Iterator versionIterator = repItem.getVersionIterator();
            Iterator teIterator = repItem.getTemporalElement().iterator();
            while (versionIterator.hasNext()) {
                Element currVersion = (Element)versionIterator.next();
                ITime currTime1 = (ITime)teIterator.next();
                NodeList nl = currVersion.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getNodeType() != 1) continue;
                    this.markItems((Element)nl.item(i), currTime1, targetName);
                }
            }
        } else {
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                this.markItems((Element)nl.item(i), time1, targetName);
            }
        }
    }

    private void mergeVersions(RepItem repItem) {
        TauLogger.logger.info((Object)"Merging Versions.");
        String target = repItem.getTarget();
        Iterator versionIterator = repItem.getVersionIterator();
        ArrayList<Element> versionToBeRemoved = new ArrayList<Element>();
        Element ev1 = null;
        Element ev2 = null;
        if (versionIterator.hasNext()) {
            ev1 = (Element)versionIterator.next();
        }
        while (versionIterator.hasNext()) {
            Hashtable ht = new Hashtable();
            ev2 = (Element)versionIterator.next();
            if (this.glueItemsFromTwoVersions(ev1, ev2, ht, target)) {
                this.mergeTwoVersions(ev1, ht);
                versionToBeRemoved.add(ev2);
                continue;
            }
            TauLogger.logger.debug((Object)("Couldn't glue two versions: " + ev1.toString() + " and " + ev2.toString()));
            TauLogger.logger.fatal((Object)"Inconsistency between logical annotations, physical annotations, and/or slices.");
            System.exit(3);
        }
        for (int i = 0; i < versionToBeRemoved.size(); ++i) {
            repItem.removeVersion((Element)versionToBeRemoved.get(i));
        }
    }

    private void mergeTwoVersions(Element ev1, Hashtable ht) {
        TauLogger.logger.info((Object)"Merging 2 Versions.");
        NodeList nl = ev1.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            Element e = (Element)nl.item(i);
            if (ht.containsKey(e)) {
                Item item = (Item)ht.get(e);
                RepItem repItem = item.toRepItem(1);
                e.getParentNode().replaceChild(repItem.toXML(this.temporalDoc, this.repSchemaNameAlias), e);
                continue;
            }
            this.mergeTwoVersions(e, ht);
        }
    }

    private boolean glueItemsFromTwoVersions(Element ev1, Element ev2, Hashtable ht, String target) {
        int i;
        String targetName = "";
        targetName = "y".equals(ev1.getAttribute("isItem")) ? ev1.getAttribute("originalElement") : ev1.getLocalName();
        if (this.tav.containsTarget(targetName)) {
            if ("y".equals(ev1.getAttribute("isItem")) && "y".equals(ev2.getAttribute("isItem"))) {
                Item item1 = this.tav.getItemPrototype(targetName);
                RepItem repItem1 = new RepItem(ev1, targetName);
                item1.addVersionAll(repItem1.getVersions(), repItem1.getTemporalElement());
                item1.getItemIdentifier().updateFieldValues(item1.getVersion(0), this.temporalDoc);
                Item item2 = this.tav.getItemPrototype(targetName);
                RepItem repItem2 = new RepItem(ev2, targetName);
                item2.addVersionAll(repItem2.getVersions(), repItem2.getTemporalElement());
                item2.getItemIdentifier().updateFieldValues(item2.getVersion(0), this.temporalDoc);
                if (item1.getItemIdentifier().equals(item2.getItemIdentifier())) {
                    item1.merge(item2);
                    ht.put(ev1, item1);
                    return true;
                }
                TauLogger.logger.info((Object)("Item identifiers not the same: \"" + item1.getItemIdentifier() + "\" and \"" + item2.getItemIdentifier() + "\""));
                return false;
            }
            TauLogger.logger.info((Object)("Elements aren't items: \"" + ev1.getNodeName() + "\" and \"" + ev2.getNodeName() + "\""));
            return false;
        }
        NodeList nl = ev1.getChildNodes();
        ArrayList<Node> nonAttrNodes1 = new ArrayList<Node>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            if (nl.item(i2).getNodeType() != 1 && nl.item(i2).getNodeType() != 3) continue;
            nonAttrNodes1.add(nl.item(i2));
        }
        NamedNodeMap nnm = ev1.getAttributes();
        Attr attr = null;
        for (int i3 = 0; i3 < nnm.getLength(); ++i3) {
            attr = (Attr)nnm.item(i3);
            if (ev2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            TauLogger.logger.info((Object)("Attribute names not the same: " + ev2.getAttribute(attr.getName()) + " and " + attr.getValue()));
            return false;
        }
        nl = ev2.getChildNodes();
        ArrayList<Node> nonAttrNodes2 = new ArrayList<Node>();
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 && nl.item(i).getNodeType() != 3) continue;
            nonAttrNodes2.add(nl.item(i));
        }
        nnm = ev1.getAttributes();
        for (i = 0; i < nnm.getLength(); ++i) {
            attr = (Attr)nnm.item(i);
            if (ev2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            TauLogger.logger.info((Object)("Attribute names not the same: " + ev2.getAttribute(attr.getName()) + " and " + attr.getValue()));
            return false;
        }
        if (nonAttrNodes1.size() == nonAttrNodes2.size()) {
            for (i = 0; i < nonAttrNodes1.size(); ++i) {
                Node n = (Node)nonAttrNodes1.get(i);
                Node m = (Node)nonAttrNodes2.get(i);
                if (n.getNodeType() == 3) {
                    if (m.getNodeType() == 3) {
                        String s2;
                        String s1 = m.getNodeValue();
                        if (s1.equals(s2 = n.getNodeValue())) continue;
                        TauLogger.logger.info((Object)("Two nodes values not equal (\"" + m.getNodeValue() + "\" !=  \"" + n.getNodeValue() + "\")."));
                        TauLogger.logger.info((Object)("First node name: \"" + m.getNodeName() + "\", second node name: \"" + n.getNodeName() + "\"."));
                        return false;
                    }
                    TauLogger.logger.info((Object)"M node not text, N is.");
                    return false;
                }
                if (!m.getNodeName().equals(n.getNodeName())) {
                    TauLogger.logger.info((Object)"Node names not equal");
                    return false;
                }
                if (this.glueItemsFromTwoVersions((Element)n, (Element)m, ht, targetName)) continue;
                TauLogger.logger.info((Object)"Can't glue n and m");
                return false;
            }
        }
        return true;
    }

    private void coalsceDocument(Element e) {
        String targetName = "";
        if ("y".equals(e.getAttribute("isItem"))) {
            targetName = e.getAttribute("originalElement");
            Item item = this.tav.getItemPrototype(targetName);
            if (item == null) {
                TauLogger.logger.info((Object)("Cannot coelesce document. Path \"" + targetName + "\" invalid."));
                System.exit(3);
            }
            RepItem repItem1 = new RepItem(e, targetName);
            item.addVersionAll(repItem1.getVersions(), repItem1.getTemporalElement());
            item.getItemIdentifier().updateFieldValues(item.getVersion(0), this.temporalDoc);
            item.coalsce(this.temporalDoc, this.tav, this.repSchemaNameAlias);
            Iterator versionIterator = item.getVersionIterator();
            while (versionIterator.hasNext()) {
                Element ev = (Element)versionIterator.next();
                NodeList nl = ev.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getNodeType() != 1) continue;
                    Element currElement = (Element)nl.item(i);
                    this.coalsceDocument(currElement);
                }
            }
            e.getParentNode().replaceChild(item.toRepItem(1).toXML(this.temporalDoc, this.repSchemaNameAlias), e);
        } else {
            targetName = e.getLocalName();
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                Element currElement = (Element)nl.item(i);
                this.coalsceDocument(currElement);
            }
        }
    }

    public Element temporalToPhysicalConversion_Rui(Document temporalDoc) {
        this.temporalDoc = temporalDoc;
        Element temporalRoot = temporalDoc.getDocumentElement();
        TimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
        Element originalRoot = null;
        NodeList nl = temporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!Common.isElement(nl.item(i))) continue;
            originalRoot = (Element)nl.item(i);
            TauLogger.logger.info((Object)("Found original root of non-temp document: " + originalRoot.getNodeName()));
            break;
        }
        long t1p = System.nanoTime();
        TauLogger.logger.info((Object)"Marking items");
        this.markItems(originalRoot, tp, "");
        long t2p = System.nanoTime();
        Common.printElaspedTime("      MarkItems", t1p, t2p);
        String target = "";
        Element newRoot = null;
        if ("y".equals(originalRoot.getAttribute("isItem"))) {
            target = originalRoot.getAttribute("originalElement");
            RepItem rootRepItem = new RepItem(originalRoot, target);
            TauLogger.logger.info((Object)("Pushing up RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " + rootRepItem.toString()));
            long t1c = System.nanoTime();
            newRoot = this.pushUp(rootRepItem).toXML(temporalDoc, this.repSchemaNameAlias);
            long t2c = System.nanoTime();
            Common.printElaspedTime("      PushUp", t1c, t2c);
        } else {
            target = originalRoot.getLocalName();
            RepItem rootRepItem = new RepItem(target, 1, 1);
            rootRepItem.addVersion(originalRoot, tp);
            TauLogger.logger.info((Object)("Pushing up RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " + rootRepItem.toString()));
            long t1c = System.nanoTime();
            newRoot = this.pushUp(rootRepItem).toXML(temporalDoc, this.repSchemaNameAlias);
            long t2c = System.nanoTime();
            Common.printElaspedTime("      PushUp", t1c, t2c);
        }
        temporalRoot.replaceChild(newRoot, originalRoot);
        return temporalRoot;
    }

    public Element temporalToPhysicalConversion(Document temporalDoc) {
        this.temporalDoc = temporalDoc;
        Element temporalRoot = temporalDoc.getDocumentElement();
        TimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
        Element originalRoot = null;
        NodeList nl = temporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeName().equals("temporalSchemaSet") || nl.item(i).getNodeType() != 1) continue;
            originalRoot = (Element)nl.item(i);
            break;
        }
        String targetName = "";
        RepItem rootRepItem = null;
        if ("y".equals(originalRoot.getAttribute("isItem"))) {
            targetName = originalRoot.getAttribute("originalElement");
            rootRepItem = new RepItem(originalRoot, targetName);
        } else {
            targetName = originalRoot.getLocalName();
            rootRepItem = new RepItem(targetName, 1, 1);
            rootRepItem.addVersion(originalRoot, tp);
        }
        RepItem newRootRepItem = this.pushUp(rootRepItem);
        String originalRootName = "y".equals(originalRoot.getAttribute("isItem")) ? originalRoot.getAttribute("originalElement") : originalRoot.getLocalName();
        if (this.pav.containsTarget(originalRootName)) {
            temporalRoot.replaceChild(newRootRepItem.toXML(temporalDoc, this.repSchemaNameAlias), originalRoot);
        } else {
            temporalRoot.replaceChild(newRootRepItem.getVersion(0), originalRoot);
        }
        return null;
    }

    public Element pushDown(RepItem repItem) {
        ++this.cnt;
        String target = repItem.getTarget();
        if (this.tav.containsTarget(target)) {
            this.processChildElements(repItem);
            return repItem.toXML(this.temporalDoc, this.repSchemaNameAlias);
        }
        if (repItem.getVersionCount() == 1) {
            this.processChildElements(repItem);
        } else {
            TauLogger.logger.info((Object)"Merging versions.");
            this.mergeVersions(repItem);
            TauLogger.logger.info((Object)"Processing child elements.");
            this.processChildElements(repItem);
        }
        return repItem.getVersion(0);
    }

    private RepItem pushUp(RepItem repItem) {
        ArrayList newElementVersions = new ArrayList();
        TemporalElement newTemporalElement = new TemporalElement();
        Iterator elementVersionIterator = repItem.getVersionIterator();
        Iterator teIterator = repItem.getTemporalElement().iterator();
        boolean hasChildItems = false;
        while (elementVersionIterator.hasNext() && teIterator.hasNext()) {
            ArrayList<RepItem> childItems = new ArrayList<RepItem>();
            Element ev = (Element)elementVersionIterator.next();
            ITime time1 = (ITime)teIterator.next();
            NodeList nl = ev.getChildNodes();
            for (int j = 0; j < nl.getLength(); ++j) {
                if (nl.item(j).getNodeType() == 1) {
                    RepItem newRepItem;
                    String targetName;
                    Element currElement = (Element)nl.item(j);
                    if ("y".equals(currElement.getAttribute("isItem"))) {
                        targetName = currElement.getAttribute("originalElement");
                        newRepItem = new RepItem(currElement, targetName);
                        childItems.add(this.pushUp(newRepItem));
                        hasChildItems = true;
                        continue;
                    }
                    targetName = currElement.getLocalName();
                    newRepItem = new RepItem(targetName, repItem.getTimeDimension(), repItem.getTimeRepresentation());
                    newRepItem.addVersion(currElement, time1);
                    childItems.add(this.pushUp(newRepItem));
                    hasChildItems = true;
                    continue;
                }
                childItems.add(null);
            }
            if (!hasChildItems) continue;
            this.splitVersions(ev, (ITimePeriod)time1, childItems, newElementVersions, newTemporalElement);
            hasChildItems = true;
        }
        if (hasChildItems) {
            repItem.clearVersions();
            Iterator it1 = newElementVersions.iterator();
            Iterator it2 = newTemporalElement.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                repItem.addVersion((Element)it1.next(), (ITime)it2.next());
            }
        }
        return repItem;
    }

    private void splitVersions(Element versionElement, ITimePeriod tp, ArrayList childItems, ArrayList newElementVersions, ITemporalElement te) {
        ArrayList<Element> newVersions = new ArrayList<Element>();
        newVersions.add(versionElement);
        TemporalElement newTE = new TemporalElement();
        newTE.setNumDimensions(te.getNumDimensions());
        newTE.add(tp);
        for (int i = 0; i < childItems.size(); ++i) {
            if (childItems.get(i) == null) continue;
            RepItem currChildRepItem = (RepItem)childItems.get(i);
            if (!this.pav.containsTarget(currChildRepItem.getTarget())) {
                Iterator versionIterator = currChildRepItem.getVersionIterator();
                Iterator timePeriodIterator = currChildRepItem.getTemporalElement().iterator();
                while (versionIterator.hasNext()) {
                    TauLogger.logger.info((Object)("Calling replacteItemByVersion 1 on " + currChildRepItem.getTarget()));
                    this.replaceItemByVersion(newVersions, newTE, (Element)versionIterator.next(), (ITimePeriod)timePeriodIterator.next(), i);
                }
                continue;
            }
            TauLogger.logger.info((Object)("Calling replacteItemByVersion 2 on " + currChildRepItem.getTarget()));
            Element ver_ele = currChildRepItem.toXML(this.temporalDoc, this.repSchemaNameAlias);
            this.replaceItemByVersion(newVersions, newTE, ver_ele, (ITimePeriod)currChildRepItem.getTemporalElement().getTimeSpan(), i);
        }
        Iterator versionItr = newVersions.iterator();
        Iterator teItr = newTE.iterator();
        while (versionItr.hasNext()) {
            newElementVersions.add(versionItr.next());
            te.add((ITime)teItr.next());
        }
    }

    private void replaceItemByVersion(ArrayList parentVersions, ITemporalElement parentTemporalElement, Element childVersionElement, ITimePeriod childTP, int childIndex) {
        ArrayList<Element> newParentVersions = new ArrayList<Element>();
        TemporalElement newParentTemporalElement = new TemporalElement();
        newParentTemporalElement.setNumDimensions(parentTemporalElement.getNumDimensions());
        ArrayList<Element> parentVersionsToBeRemoved = new ArrayList<Element>();
        TemporalElement parentTimePeriodsToBeRemoved = new TemporalElement();
        Element parentVersionElement = null;
        ITimePeriod parentTP = null;
        Iterator parentVersionIterator = parentVersions.iterator();
        Iterator parentTEIterator = parentTemporalElement.iterator();
        while (parentVersionIterator.hasNext()) {
            parentVersionElement = (Element)parentVersionIterator.next();
            parentTP = (ITimePeriod)parentTEIterator.next();
            if (parentTP.getRelationship(childTP) <= 0) continue;
            Iterator splitPeriodIterator = parentTP.split(childTP);
            while (splitPeriodIterator.hasNext()) {
                Element cloneParentVersionElement;
                TimePeriod tp = (TimePeriod)splitPeriodIterator.next();
                if (tp.getRelationship(childTP) == 3) {
                    cloneParentVersionElement = (Element)parentVersionElement.cloneNode(true);
                    NodeList nl = cloneParentVersionElement.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        if (childIndex != i) continue;
                        if (Common.isElement(nl.item(i))) {
                            Element new_ch_ele = (Element)childVersionElement.cloneNode(true);
                            cloneParentVersionElement.replaceChild(new_ch_ele, (Element)nl.item(i));
                            continue;
                        }
                        TauLogger.logger.fatal((Object)("Unsquash error: " + n.getNodeName() + " : " + n.getTextContent()));
                        System.exit(2);
                    }
                    this.chopChildItems(cloneParentVersionElement, tp);
                    newParentVersions.add(cloneParentVersionElement);
                    newParentTemporalElement.add(tp);
                    continue;
                }
                cloneParentVersionElement = (Element)parentVersionElement.cloneNode(true);
                this.chopChildItems(cloneParentVersionElement, tp);
                newParentVersions.add(cloneParentVersionElement);
                newParentTemporalElement.add(tp);
            }
            parentVersionsToBeRemoved.add(parentVersionElement);
            parentTimePeriodsToBeRemoved.add(parentTP);
        }
        Iterator versionItr = parentVersionsToBeRemoved.iterator();
        Iterator teItr = parentTimePeriodsToBeRemoved.iterator();
        while (versionItr.hasNext()) {
            parentVersions.remove(versionItr.next());
            parentTemporalElement.remove((ITime)teItr.next());
        }
        versionItr = newParentVersions.iterator();
        teItr = newParentTemporalElement.iterator();
        while (versionItr.hasNext()) {
            parentVersions.add(versionItr.next());
            parentTemporalElement.add((ITime)teItr.next());
        }
    }

    private void chopChildItems(Element e, ITimePeriod tp) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element;
            if (nl.item(i).getNodeType() != 1) continue;
            Element newElement = element = (Element)nl.item(i);
            String targetName = element.getLocalName();
            if ("y".equals(element.getAttribute("isItem"))) {
                targetName = element.getAttribute("originalElement");
                RepItem repItem = new RepItem(element, targetName);
                repItem.chopVersions(tp);
                newElement = repItem.toXML(this.temporalDoc, this.repSchemaNameAlias);
                e.replaceChild(newElement, element);
            }
            this.chopChildItems(newElement, tp);
        }
    }
}

