/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.GenericValidator;
import cs.arizona.tau.xml.IPhysicalAnnotationValidator;
import cs.arizona.tau.xml.Item;
import cs.arizona.tau.xml.RepItem;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PhysicalAnnotationValidator
extends GenericValidator
implements IPhysicalAnnotationValidator {
    private Hashtable<String, Item> itemPrototypes = new Hashtable();
    private Document snapshotSchemaDocument;
    private Element physical;
    private TargetIdentifier ti;
    private String repType;
    private Hashtable<String, Element> targetElements;
    private ArrayList<String> targets = new ArrayList();
    private Hashtable<String, RepItem> repItemPrototypes = new Hashtable();
    private RepItem topLevelRepItemPrototype = null;

    public PhysicalAnnotationValidator(String physicalAnnotation, String snapshotSchema, boolean createRepItemPrototypes) {
        Document annotationDocument = this.cp.parseDocument(physicalAnnotation, this.vp.getProperty("PXSchemaURL"), this.vp.getProperty("PXSchema"));
        this.snapshotSchemaDocument = this.cp.parseDocument(snapshotSchema, this.vp.getProperty("XMLSchemaURL"), this.vp.getProperty("XMLSchema"));
        NodeList physicalList = annotationDocument.getElementsByTagName("physical");
        this.physical = physicalList.getLength() > 0 ? (Element)physicalList.item(0) : null;
        this.collectTargets();
        this.createItemPrototypes();
        if (createRepItemPrototypes) {
            this.createRepItemPrototypes();
            this.createTopLevelRepItemPrototype();
        }
    }

    public PhysicalAnnotationValidator(Document annotationDocument, Document snapshotSchemaDocument, TargetIdentifier ti, boolean createRepItemPrototypes) {
        this.snapshotSchemaDocument = snapshotSchemaDocument;
        this.ti = ti;
        this.targetElements = new Hashtable();
        NodeList physicalList = annotationDocument.getElementsByTagName("physical");
        this.physical = physicalList.getLength() > 0 ? (Element)physicalList.item(0) : null;
        this.createItemPrototypes();
        this.determineRepType();
        this.collectTargets();
        if (createRepItemPrototypes) {
            this.createRepItemPrototypes();
            this.createTopLevelRepItemPrototype();
        }
    }

    public String getRepType() {
        return this.repType;
    }

    @Override
    public boolean validatePhysicalAnnotation() {
        return this.checkConsistency();
    }

    public String getTopTarget() {
        String str = this.targets.get(0);
        String prevSubStr = "";
        String subStr = "";
        StringTokenizer st = new StringTokenizer(str, "/");
        while (st.hasMoreTokens()) {
            prevSubStr = subStr;
            subStr = subStr + "/" + st.nextToken();
            Iterator<String> itr = this.targets.iterator();
            while (itr.hasNext() && itr.next().startsWith(subStr)) {
            }
        }
        return prevSubStr;
    }

    public boolean validateTopTarget(String topTarget) {
        return true;
    }

    public void createItemPrototypes() {
        if (this.physical == null) {
            return;
        }
        NodeList nl = this.physical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (nl.item(i).getNodeType() != 1 || (currentElement = (Element)nl.item(i)).getLocalName() != "stamp") continue;
            Item item = new Item(currentElement);
            String tgt = currentElement.getAttribute("target");
            this.itemPrototypes.put(tgt, item);
        }
    }

    public Item getItemPrototype(String target) {
        Item o = this.itemPrototypes.get(target);
        if (o != null) {
            return o.cloneItem();
        }
        return null;
    }

    private boolean checkConsistency() {
        if (this.physical == null) {
            return true;
        }
        NodeList nl = this.physical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (nl.item(i).getNodeType() != 1 || (currentElement = (Element)nl.item(i)).getLocalName() != "stamp") continue;
            String target = currentElement.getAttribute("target");
            Element targetElement = this.ti.getTarget(target);
            if (targetElement == null) {
                TauLogger.logger.error((Object)("Could not validate physical annotation on \"" + target + "\""));
                return false;
            }
            TauLogger.logger.debug((Object)("Adding target \"" + target + "\""));
            this.targetElements.put(targetElement.getAttribute("name"), targetElement);
        }
        TauLogger.logger.info((Object)"Physical Annotations validated successfully.");
        return true;
    }

    public Hashtable<String, Element> getTargetElements() {
        return this.targetElements;
    }

    public void collectTargets() {
        if (this.physical == null) {
            return;
        }
        NodeList nl = this.physical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (!Common.isElement(nl.item(i)) || (currentElement = (Element)nl.item(i)).getLocalName() != "stamp" && currentElement.getNodeName() != "stamp") continue;
            String tgt = currentElement.getAttribute("target");
            TauLogger.logger.info((Object)("Adding target \"" + tgt + "\""));
            this.targets.add(tgt);
        }
    }

    private void determineRepType() {
        if (this.physical == null) {
            return;
        }
        this.repType = this.physical.getAttribute("representationType");
        if (this.repType.equals("")) {
            this.repType = "versioned";
        }
    }

    public boolean containsTarget(String target) {
        return this.targets.contains(target);
    }

    public void createRepItemPrototypes() {
        if (this.physical == null) {
            return;
        }
        NodeList nl = this.physical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (nl.item(i).getNodeType() != 1 || (currentElement = (Element)nl.item(i)).getLocalName() != "stamp" && currentElement.getNodeName() != "stamp") continue;
            RepItem repItem = new RepItem(currentElement);
            this.repItemPrototypes.put(currentElement.getAttribute("target"), repItem);
        }
    }

    private void createTopLevelRepItemPrototype() {
        String target;
        String topLevelElementPath = target = this.targets.get(0);
        this.topLevelRepItemPrototype = new RepItem(topLevelElementPath, 1, 1);
    }

    public RepItem getRepItemPrototype(String target) {
        return this.repItemPrototypes.get(target);
    }

    public Iterator getTargetIterator() {
        return this.targets.iterator();
    }
}

