/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.xml.GenericValidator;
import cs.arizona.tau.xml.ILogicalAnnotationValidator;
import cs.arizona.tau.xml.Item;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LogicalAnnotationValidator
extends GenericValidator
implements ILogicalAnnotationValidator {
    private Document snapshotSchemaDocument;
    private Element logical;
    private TargetIdentifier ti;
    private ArrayList<String> targets = new ArrayList();
    private Hashtable<String, Item> itemPrototypes = new Hashtable();
    private Hashtable<String, Integer> itemCounters = new Hashtable();

    public LogicalAnnotationValidator(String temporalAnnotation, String snapshotSchema, boolean createItemPrototypes) {
        this.init();
        Document annotationDocument = this.cp.parseDocument(temporalAnnotation, this.vp.getProperty("TXSchemaURL"), this.vp.getProperty("TXSchema"));
        this.snapshotSchemaDocument = this.cp.parseDocument(snapshotSchema, this.vp.getProperty("XMLSchemaURL"), this.vp.getProperty("XMLSchema"));
        this.ti = new TargetIdentifier(this.snapshotSchemaDocument);
        NodeList logicalList = annotationDocument.getElementsByTagName("logical");
        this.logical = logicalList.getLength() > 0 ? (Element)logicalList.item(0) : null;
        this.collectTargets();
        if (createItemPrototypes) {
            this.createItemPrototypes();
        }
    }

    public LogicalAnnotationValidator(Document annotationDocument, Document snapshotSchemaDocument, TargetIdentifier ti, boolean createItemPrototypes) {
        this.snapshotSchemaDocument = snapshotSchemaDocument;
        this.ti = ti;
        NodeList logicalList = annotationDocument.getElementsByTagName("logical");
        this.logical = logicalList.getLength() > 0 ? (Element)logicalList.item(0) : null;
        this.collectTargets();
        if (createItemPrototypes) {
            this.createItemPrototypes();
        }
    }

    @Override
    public boolean validateLogicalAnnotation() {
        return this.checkConsistency();
    }

    public String getTopTarget() {
        String str = this.targets.get(0);
        String prevSubStr = "";
        String subStr = "";
        StringTokenizer st = new StringTokenizer(str, "/");
        while (st.hasMoreTokens()) {
            prevSubStr = subStr;
            subStr = subStr + "/" + st.nextToken();
            Iterator<String> itr = this.targets.iterator();
            while (itr.hasNext() && itr.next().startsWith(subStr)) {
            }
        }
        return prevSubStr;
    }

    private boolean checkConsistency() {
        if (this.logical == null) {
            return true;
        }
        NodeList nl = this.logical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String target;
            Element itemElement;
            if (nl.item(i).getNodeType() != 1 || (itemElement = (Element)nl.item(i)).getLocalName() != "item" || this.validateTarget(target = itemElement.getAttribute("target")) != null) continue;
            TauLogger.logger.error((Object)("Could not validate temporal annotation on \"" + target + "\""));
            return false;
        }
        TauLogger.logger.info((Object)"Temporal Annotations validated successfully.");
        return true;
    }

    private Element validateTarget(String target) {
        Element r = this.ti.getTarget(target);
        if (r == null) {
            TauLogger.logger.error((Object)("Target Identifier does not have target \"" + target + "\"."));
        }
        return r;
    }

    private boolean validateField(Element element, String fieldPath) {
        return this.ti.validateField(element, fieldPath);
    }

    private void collectTargets() {
        if (this.logical == null) {
            return;
        }
        NodeList nl = this.logical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (nl.item(i).getNodeType() != 1 || (currentElement = (Element)nl.item(i)).getLocalName() != "item") continue;
            this.targets.add(currentElement.getAttribute("target"));
        }
    }

    public boolean containsTarget(String target) {
        return this.targets.contains(target);
    }

    public void createItemPrototypes() {
        if (this.logical == null) {
            return;
        }
        NodeList nl = this.logical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (nl.item(i).getNodeType() != 1 || (currentElement = (Element)nl.item(i)).getLocalName() != "item") continue;
            Item item = new Item(currentElement);
            this.itemPrototypes.put(currentElement.getAttribute("target"), item);
        }
    }

    public void resetItemCounters() {
        if (this.logical == null) {
            return;
        }
        NodeList nl = this.logical.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currentElement;
            if (nl.item(i).getNodeType() != 1 || (currentElement = (Element)nl.item(i)).getLocalName() != "item") continue;
            this.itemCounters.put(currentElement.getAttribute("target"), new Integer(0));
        }
    }

    public Item getItemPrototype(String target) {
        Item o = this.itemPrototypes.get(target);
        if (o != null) {
            return o.cloneItem();
        }
        return null;
    }

    public String getNextItemID(String target) {
        int currCounter = this.itemCounters.get(target) + 1;
        this.itemCounters.put(target, new Integer(currCounter));
        return target.replace('/', '_') + String.valueOf(currCounter);
    }

    public Iterator getTargetIterator() {
        return this.targets.iterator();
    }
}

