/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.ITemporalRegion;
import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.BaseItem;
import cs.arizona.tau.xml.ItemIdentifier;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.RepItem;
import cs.arizona.util.TauLogger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Item
extends BaseItem
implements Cloneable {
    private ItemIdentifier itemIdentifier;
    private boolean coalsced;
    private ITimePeriod contentVaryingApplicabilityPeriod;
    private ITimePeriod maximalExistencePeriod;
    private int validTimeFrequency;
    private int content;
    private int existence;
    private int kind;
    private int transactionTimeFrequency = 0;

    public Item() {
    }

    public String toString() {
        String result = "Target \"" + this.target + "\" with id \"" + this.itemID + "\"";
        return result;
    }

    public Item(Item item) {
        super(item);
        this.itemIdentifier = item.itemIdentifier.cloneItemIdentifier();
        this.coalsced = item.isCoalsced();
        this.contentVaryingApplicabilityPeriod = item.getContentVaryingApplicabilityPeriod();
        this.maximalExistencePeriod = item.getMaximalExistencePeriod();
        this.validTimeFrequency = item.getValidTimeFrequency();
        this.content = item.getContent();
        this.existence = item.getExistence();
        this.kind = item.getKind();
        this.transactionTimeFrequency = item.getTransactionTimeFrequency();
    }

    public Item(Element xmlSchemaElement) {
        this.target = xmlSchemaElement.getAttribute("target");
        NodeList nl = xmlSchemaElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element ce1;
            int j;
            NodeList nl1;
            if (nl.item(i).getNodeType() != 1) continue;
            Element childElement = (Element)nl.item(i);
            if ("itemIdentifier".equals(childElement.getLocalName())) {
                this.itemIdentifier = new ItemIdentifier(childElement);
                continue;
            }
            if ("validTime".equals(childElement.getLocalName())) {
                this.timeDimension = 2;
                int n = this.content = "constant".equals(childElement.getAttribute("content")) ? BaseItem.CONTENT_CONSTANT : BaseItem.CONTENT_VARYING;
                this.existence = "constant".equals(childElement.getAttribute("existence")) ? BaseItem.EXISTENCE_CONSTANT : ("varyingWithGaps".equals(childElement.getAttribute("existence")) ? BaseItem.EXISTENCE_VARYING_WITH_GAPS : BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS);
                this.kind = "state".equals(childElement.getAttribute("kind")) ? BaseItem.KIND_STATE : BaseItem.KIND_EVENT;
                nl1 = childElement.getChildNodes();
                for (j = 0; j < nl1.getLength(); ++j) {
                    if (nl.item(j).getNodeType() != 1) continue;
                    ce1 = (Element)nl1.item(j);
                    if ("contentVaryingApplicability".equals(ce1.getLocalName())) {
                        this.contentVaryingApplicabilityPeriod = new TimePeriod(ce1.getAttribute("begin"), ce1.getAttribute("end"));
                        continue;
                    }
                    if ("maximalExistence".equals(ce1.getLocalName())) {
                        this.maximalExistencePeriod = new TimePeriod(ce1.getAttribute("begin"), ce1.getAttribute("end"));
                        continue;
                    }
                    this.validTimeFrequency = Integer.parseInt(ce1.getNodeValue());
                }
                continue;
            }
            if (!"transactionTime".equals(childElement.getLocalName())) continue;
            this.timeDimension = this.timeDimension == 2 ? 3 : 1;
            int n = this.content = "constant".equals(childElement.getAttribute("content")) ? BaseItem.CONTENT_CONSTANT : BaseItem.CONTENT_VARYING;
            this.existence = "constant".equals(childElement.getAttribute("existence")) ? BaseItem.EXISTENCE_CONSTANT : ("varyingWithGaps".equals(childElement.getAttribute("existence")) ? BaseItem.EXISTENCE_VARYING_WITH_GAPS : BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS);
            this.kind = "state".equals(childElement.getAttribute("kind")) ? BaseItem.KIND_STATE : BaseItem.KIND_EVENT;
            nl1 = childElement.getChildNodes();
            for (j = 0; j < nl1.getLength(); ++j) {
                if (nl.item(j).getNodeType() != 1 || !"frequency".equals((ce1 = (Element)nl1.item(j)).getLocalName())) continue;
                this.transactionTimeFrequency = Integer.parseInt(ce1.getNodeValue());
            }
        }
    }

    public Item(Element xmlSchemaElement, boolean dummy) {
        this.target = xmlSchemaElement.getAttribute("target");
        this.timeDimension = 1;
        this.content = BaseItem.CONTENT_CONSTANT;
        this.existence = BaseItem.EXISTENCE_CONSTANT;
        this.kind = BaseItem.KIND_STATE;
        this.itemIdentifier = new ItemIdentifier();
        this.itemIdentifier.setName("id1");
        this.itemIdentifier.setTarget(this.target);
        this.itemIdentifier.fieldTable.put("./text()", "");
    }

    public int getContent() {
        return this.content;
    }

    public void setContent(int content) {
        this.content = content;
    }

    public int getExistence() {
        return this.existence;
    }

    public void setExistence(int existence) {
        this.existence = existence;
    }

    public ItemIdentifier getItemIdentifier() {
        return this.itemIdentifier;
    }

    public void setItemIdentifier(ItemIdentifier itemIdentifier) {
        this.itemIdentifier = itemIdentifier;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public boolean isCoalsced() {
        return this.coalsced;
    }

    public ITimePeriod getContentVaryingApplicabilityPeriod() {
        return this.contentVaryingApplicabilityPeriod;
    }

    public void setContentVaryingApplicabilityPeriod(ITimePeriod contentVaryingApplicabilityPeriod) {
        this.contentVaryingApplicabilityPeriod = contentVaryingApplicabilityPeriod;
    }

    public ITimePeriod getMaximalExistencePeriod() {
        return this.maximalExistencePeriod;
    }

    public void setMaximalExistencePeriod(ITimePeriod maximalExistencePeriod) {
        this.maximalExistencePeriod = maximalExistencePeriod;
    }

    public int getTransactionTimeFrequency() {
        return this.transactionTimeFrequency;
    }

    public void setTransactionTimeFrequency(int transactionTimeFrequency) {
        this.transactionTimeFrequency = transactionTimeFrequency;
    }

    public int getValidTimeFrequency() {
        return this.validTimeFrequency;
    }

    public void setValidTimeFrequency(int validTimeFrequency) {
        this.validTimeFrequency = validTimeFrequency;
    }

    public RepItem toRepItem(int timeRepresentation) {
        RepItem repItem = new RepItem(this.target, this.timeDimension, timeRepresentation);
        repItem.addVersionAll(this.versions, this.temporalElement);
        return repItem;
    }

    public Item cloneItem() {
        Item item1 = new Item(this);
        return item1;
    }

    public void coalsce(Document temporalDoc, LogicalAnnotationValidator tav, String repSchemaNameAlias) {
        Iterator versionIterator = this.getVersionIterator();
        Iterator teIterator = this.temporalElement.iterator();
        ArrayList<Element> versionToBeRemoved = new ArrayList<Element>();
        Element ev1 = null;
        Element ev2 = null;
        ITime time1 = null;
        ITime time2 = null;
        if (versionIterator.hasNext()) {
            ev1 = (Element)versionIterator.next();
            time1 = (ITime)teIterator.next();
        }
        while (versionIterator.hasNext()) {
            Hashtable ht = new Hashtable();
            ev2 = (Element)versionIterator.next();
            time2 = (ITime)teIterator.next();
            if (((ITimePeriod)time1).getRelationship((ITimePeriod)time2) == -3) {
                if (this.canBeCoalsced(ev1, ev2, ht, temporalDoc, tav)) {
                    this.coalsceTwoVersions(ev1, ht, temporalDoc, repSchemaNameAlias);
                    versionToBeRemoved.add(ev2);
                    ((ITimePeriod)time1).setEndDate(((ITimePeriod)time2).getEndDate());
                    continue;
                }
                ev1 = ev2;
                time1 = time2;
                continue;
            }
            ev1 = ev2;
            time1 = time2;
        }
        for (int i = 0; i < versionToBeRemoved.size(); ++i) {
            this.removeVersion((Element)versionToBeRemoved.get(i));
        }
        this.coalsced = true;
    }

    public boolean validate(ITime documentExistenceTime, LogicalAnnotationValidator tav, Document temporalDoc) {
        boolean isValid = false;
        switch (this.timeDimension) {
            case 3: {
                isValid = this.validateContent(tav, temporalDoc) && this.validateExistence((ITimePeriod)documentExistenceTime) && this.validateKind() && this.validateContentVaryingApplicability() && this.validateMaximalExistence() && this.validateValidTimeFrequency(tav, temporalDoc) && this.validateTransactionTimeFrequency(tav, temporalDoc);
                break;
            }
            case 2: {
                isValid = this.validateContent(tav, temporalDoc) && this.validateExistence((ITimePeriod)documentExistenceTime) && this.validateKind() && this.validateContentVaryingApplicability() && this.validateMaximalExistence() && this.validateValidTimeFrequency(tav, temporalDoc);
                break;
            }
            case 1: {
                isValid = this.validateContent(tav, temporalDoc) && this.validateExistence((ITimePeriod)documentExistenceTime) && this.validateKind() && this.validateTransactionTimeFrequency(tav, temporalDoc);
            }
        }
        return isValid;
    }

    private boolean canBeCoalsced(Element ev1, Element ev2, Hashtable ht, Document temporalDoc, LogicalAnnotationValidator tav) {
        int i;
        String targetName = "";
        targetName = "y".equals(ev1.getAttribute("isItem")) ? ev1.getAttribute("originalElement") : ev1.getLocalName();
        if ("y".equals(ev1.getAttribute("isItem")) && "y".equals(ev2.getAttribute("isItem"))) {
            Item item1 = tav.getItemPrototype(targetName);
            RepItem repItem1 = new RepItem(ev1, targetName);
            item1.addVersionAll(repItem1.getVersions(), repItem1.getTemporalElement());
            item1.getItemIdentifier().updateFieldValues(item1.getVersion(0), temporalDoc);
            Item item2 = tav.getItemPrototype(targetName);
            RepItem repItem2 = new RepItem(ev2, targetName);
            item2.addVersionAll(repItem2.getVersions(), repItem2.getTemporalElement());
            item2.getItemIdentifier().updateFieldValues(item2.getVersion(0), temporalDoc);
            if (item1.getItemIdentifier().equals(item2.getItemIdentifier())) {
                item1.merge(item2);
                ht.put(ev1, item1);
                return true;
            }
            return false;
        }
        NodeList nl = ev1.getChildNodes();
        ArrayList<Node> nonAttrNodes1 = new ArrayList<Node>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            if (nl.item(i2).getNodeType() != 1 && nl.item(i2).getNodeType() != 3) continue;
            nonAttrNodes1.add(nl.item(i2));
        }
        NamedNodeMap nnm = ev1.getAttributes();
        Attr attr = null;
        for (int i3 = 0; i3 < nnm.getLength(); ++i3) {
            attr = (Attr)nnm.item(i3);
            if (ev2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        nl = ev2.getChildNodes();
        ArrayList<Node> nonAttrNodes2 = new ArrayList<Node>();
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 && nl.item(i).getNodeType() != 3) continue;
            nonAttrNodes2.add(nl.item(i));
        }
        nnm = ev1.getAttributes();
        attr = null;
        for (i = 0; i < nnm.getLength(); ++i) {
            attr = (Attr)nnm.item(i);
            if (ev2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        if (nonAttrNodes1.size() == nonAttrNodes2.size()) {
            for (i = 0; i < nonAttrNodes1.size(); ++i) {
                Node n = (Node)nonAttrNodes1.get(i);
                Node m = (Node)nonAttrNodes2.get(i);
                if (n.getNodeType() == 3) {
                    if (m.getNodeType() == 3) {
                        if (m.getNodeValue().equals(n.getNodeValue())) continue;
                        return false;
                    }
                    return false;
                }
                if (!m.getNodeName().equals(n.getNodeName())) {
                    return false;
                }
                if (this.canBeCoalsced((Element)n, (Element)m, ht, temporalDoc, tav)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void coalsceTwoVersions(Element ev1, Hashtable ht, Document temporalDoc, String repSchemaNameAlias) {
        NodeList nl = ev1.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            Element e = (Element)nl.item(i);
            if (ht.containsKey(e)) {
                Item item = (Item)ht.get(e);
                RepItem repItem = item.toRepItem(1);
                Element temp = repItem.toXML(temporalDoc, repSchemaNameAlias);
                e.getParentNode().replaceChild(temp, e);
                continue;
            }
            this.coalsceTwoVersions(e, ht, temporalDoc, repSchemaNameAlias);
        }
    }

    private boolean validateContent(LogicalAnnotationValidator tav, Document temporalDoc) {
        if (this.content == BaseItem.CONTENT_CONSTANT) {
            Iterator versionIterator = this.getVersionIterator();
            Element ev1 = null;
            Element ev2 = null;
            if (versionIterator.hasNext()) {
                ev2 = (Element)versionIterator.next();
            }
            while (versionIterator.hasNext()) {
                ev1 = ev2;
                if (this.areConstantContentVersions(ev1, ev2 = (Element)versionIterator.next(), tav, temporalDoc)) continue;
                TauLogger.logger.fatal((Object)("Content is specified as CONTENT_CONSTANT but is not CONSTANT for Item with Item Identifier:\n" + this.itemIdentifier.toString()));
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean validateExistence(ITimePeriod documentExistencePeriod) {
        Iterator teItr = this.temporalElement.iterator();
        ITimePeriod tp2 = this.timeDimension == 3 ? ((ITemporalRegion)teItr.next()).getValidPeriod() : (ITimePeriod)teItr.next();
        if (this.existence == BaseItem.EXISTENCE_CONSTANT) {
            ITimePeriod ts = null;
            if (this.timeDimension != 3) {
                ts = (ITimePeriod)this.temporalElement.getTimeSpan();
            }
            if (documentExistencePeriod.getRelationship(ts) != 3) {
                System.out.println("Existence is specified as constant, but it is not constant for the item with Item Identifier - " + this.itemIdentifier.toString());
                return false;
            }
        }
        if (this.existence == BaseItem.EXISTENCE_CONSTANT || this.existence == BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS) {
            while (teItr.hasNext()) {
                ITimePeriod tp1 = tp2;
                int rel = tp1.getRelationship(tp2 = this.timeDimension == 3 ? ((ITemporalRegion)teItr.next()).getValidPeriod() : (ITimePeriod)teItr.next());
                if (rel == -4 || rel == -3) continue;
                TauLogger.logger.fatal((Object)("Existence is specified as 'EXISTENCE CONSTANT' or 'EXISTENCE VARYING WITH GAPS', but constraint is not satisfied for the item with Item Identifier - " + this.itemIdentifier.toString()));
                TauLogger.logger.fatal((Object)("Timeperiods: " + tp1.toString() + " and " + tp2.toString()));
                return false;
            }
        }
        return true;
    }

    private boolean validateKind() {
        return true;
    }

    private boolean validateContentVaryingApplicability() {
        Iterator teIterator = this.temporalElement.iterator();
        int beforeCount = 0;
        int afterCount = 0;
        ITimePeriod tp = null;
        while (teIterator.hasNext()) {
            tp = this.timeDimension == 3 ? ((ITemporalRegion)teIterator.next()).getValidPeriod() : (ITimePeriod)teIterator.next();
            int rel = this.contentVaryingApplicabilityPeriod.getRelationship(tp);
            if (rel == -2 || rel == -4) {
                ++beforeCount;
            }
            if (rel != -1 && rel != -3) continue;
            ++afterCount;
        }
        return beforeCount <= 1 && afterCount <= 1;
    }

    private boolean validateMaximalExistence() {
        if (this.timeDimension != 3) {
            ITimePeriod ts = (ITimePeriod)this.temporalElement.getTimeSpan();
            int rel = this.maximalExistencePeriod.getRelationship(ts);
            return rel != -1 && rel != -3 && rel != -4 && rel != -2 && rel != 1 && rel != 2;
        }
        return true;
    }

    private boolean validateValidTimeFrequency(LogicalAnnotationValidator tav, Document temporalDoc) {
        int frequency = 0;
        if (3 == this.timeDimension) {
            return true;
        }
        if (2 == this.timeDimension) {
            Iterator versionIterator = this.getVersionIterator();
            Iterator teIterator = this.temporalElement.iterator();
            Element ev1 = null;
            Element ev2 = null;
            ITime time1 = null;
            ITime time2 = null;
            if (versionIterator.hasNext()) {
                ev1 = (Element)versionIterator.next();
                time1 = (ITime)teIterator.next();
            }
            while (versionIterator.hasNext()) {
                ev1 = ev2;
                time1 = time2;
                ev2 = (Element)versionIterator.next();
                time2 = (ITime)teIterator.next();
                if (this.areConstantContentVersions(ev1, ev2, tav, temporalDoc)) continue;
                ++frequency;
            }
            return frequency <= this.validTimeFrequency;
        }
        return true;
    }

    private boolean validateTransactionTimeFrequency(LogicalAnnotationValidator tav, Document temporalDoc) {
        int frequency = 0;
        if (this.transactionTimeFrequency != 0) {
            Iterator versionIterator = this.getVersionIterator();
            Element ev1 = null;
            Element ev2 = null;
            if (versionIterator.hasNext()) {
                ev1 = (Element)versionIterator.next();
            }
            while (versionIterator.hasNext()) {
                ev1 = ev2;
                if (this.areConstantContentVersions(ev1, ev2 = (Element)versionIterator.next(), tav, temporalDoc)) continue;
                ++frequency;
            }
            return frequency <= this.transactionTimeFrequency;
        }
        return true;
    }

    private boolean areConstantContentVersions(Element ev1, Element ev2, LogicalAnnotationValidator tav, Document temporalDoc) {
        int i;
        String targetName = "";
        targetName = "y".equals(ev1.getAttribute("isItem")) ? ev1.getAttribute("originalElement") : ev1.getLocalName();
        if ("y".equals(ev1.getAttribute("isItem")) && "y".equals(ev2.getAttribute("isItem"))) {
            Item item1 = tav.getItemPrototype(targetName);
            RepItem repItem1 = new RepItem(ev1, targetName);
            item1.addVersionAll(repItem1.getVersions(), repItem1.getTemporalElement());
            item1.getItemIdentifier().updateFieldValues(item1.getVersion(0), temporalDoc);
            Item item2 = tav.getItemPrototype(targetName);
            RepItem repItem2 = new RepItem(ev2, targetName);
            item2.addVersionAll(repItem2.getVersions(), repItem2.getTemporalElement());
            item2.getItemIdentifier().updateFieldValues(item2.getVersion(0), temporalDoc);
            return item1.getItemIdentifier().equals(item2.getItemIdentifier());
        }
        NodeList nl = ev1.getChildNodes();
        ArrayList<Node> nonAttrNodes1 = new ArrayList<Node>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            if (nl.item(i2).getNodeType() != 1 && nl.item(i2).getNodeType() != 3) continue;
            nonAttrNodes1.add(nl.item(i2));
        }
        NamedNodeMap nnm = ev1.getAttributes();
        Attr attr = null;
        for (int i3 = 0; i3 < nnm.getLength(); ++i3) {
            attr = (Attr)nnm.item(i3);
            if (ev2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        nl = ev2.getChildNodes();
        ArrayList<Node> nonAttrNodes2 = new ArrayList<Node>();
        for (i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 && nl.item(i).getNodeType() != 3) continue;
            nonAttrNodes2.add(nl.item(i));
        }
        nnm = ev1.getAttributes();
        attr = null;
        for (i = 0; i < nnm.getLength(); ++i) {
            attr = (Attr)nnm.item(i);
            if (ev2.getAttribute(attr.getName()).equals(attr.getValue())) continue;
            return false;
        }
        if (nonAttrNodes1.size() == nonAttrNodes2.size()) {
            for (i = 0; i < nonAttrNodes1.size(); ++i) {
                Node n = (Node)nonAttrNodes1.get(i);
                Node m = (Node)nonAttrNodes2.get(i);
                if (n.getNodeType() == 3) {
                    if (m.getNodeType() == 3) {
                        if (m.getNodeValue().equals(n.getNodeValue())) continue;
                        return false;
                    }
                    return false;
                }
                if (!m.getNodeName().equals(n.getNodeName())) {
                    return false;
                }
                if (this.areConstantContentVersions((Element)n, (Element)m, tav, temporalDoc)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void orderVersions() {
        ITimePeriod tp1 = null;
        ITimePeriod tp2 = null;
        for (int i = 0; i < this.versions.size(); ++i) {
            for (int j = i + 1; j < this.versions.size(); ++j) {
                if (this.timeDimension == 3) {
                    tp1 = ((ITemporalRegion)this.temporalElement.get(i)).getValidPeriod();
                    tp2 = ((ITemporalRegion)this.temporalElement.get(j)).getValidPeriod();
                } else {
                    tp1 = (ITimePeriod)this.temporalElement.get(i);
                    tp2 = (ITimePeriod)this.temporalElement.get(j);
                }
                int rel = tp1.getRelationship(tp2);
                if (rel == -1 || rel == -3) {
                    this.temporalElement.swap(i, j);
                    this.swapVersions(i, j);
                    continue;
                }
                if (rel != 1 && rel != 5 && rel != 7 && rel != 9) continue;
            }
        }
    }

    private void swapVersions(int ind1, int ind2) {
        Object o = this.versions.get(ind1);
        this.versions.set(ind2, this.versions.get(ind1));
        this.versions.set(ind1, o);
    }

    public boolean equals(Object o) {
        Item i = (Item)o;
        return this.itemIdentifier.equals(i.getItemIdentifier());
    }

    public int hashCode() {
        return this.itemIdentifier.hashCode();
    }
}

