/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.DoSchemaMapping;
import cs.arizona.tau.xml.IDoUnSquashing;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.tau.xml.Primitives;
import cs.arizona.tau.xml.RepItem;
import cs.arizona.tau.xml.SnapshotContainer;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathNSResolver;

public class DoUnSquashing
implements IDoUnSquashing {
    private Document bundleDoc;
    private String temporalBundle_;
    private Document temporalSchemaDoc;
    private String temporalSchema;
    private String conventionalSchema;
    private String annotation;
    private String repSchema;
    private Document _snapshotSchemaDoc;
    private Document _temporalAnnotationDoc;
    private Document _physicalAnnotationDoc;
    private Document temporalDoc;
    private Document defaultPhysicalAnnotationDoc = null;
    private Document annotationDoc;
    private Document conventionalSchemaDoc;
    private Document defaultAnnotationDoc = null;
    TargetIdentifier ti;
    LogicalAnnotationValidator lav;
    PhysicalAnnotationValidator pav;
    PhysicalAnnotationValidator defaultPav;
    XPathEvaluator evaluator;
    XPathNSResolver resolver;
    ConventionalParser cp;
    ValidatorProperties vp;
    String repSchemaNameAlias;
    private ArrayList<SnapshotContainer> snapshotsEdit;

    public DoUnSquashing(String temporalSchema, int schemaVersion) {
        this.temporalSchema = temporalSchema;
        this.init();
        this.repSchemaNameAlias = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":" : "";
        TemporalSchema ts = new TemporalSchema(this.vp, this.cp, temporalSchema);
        this.temporalSchemaDoc = ts.getTemporalSchemaDoc();
        this.annotationDoc = ts.getAnnotationDoc();
        this.conventionalSchemaDoc = ts.getConventionalSchemaDoc();
        this.ti = new TargetIdentifier(this.conventionalSchemaDoc);
        this.defaultAnnotationDoc = Common.createDefaultAnnotationDoc(this.cp, Common.getTopLevelSchemaElementName(this.ti));
        this.lav = new LogicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.pav = new PhysicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.defaultPav = new PhysicalAnnotationValidator(this.defaultAnnotationDoc, this.conventionalSchemaDoc, this.ti, true);
        DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
        Document repSchemaDoc = doSchemaMapping.createRepresentationalSchema(temporalSchema, 0);
        this.repSchema = ts.getTemporalSchemaDir() + "myRepSchema.xsd";
        this.cp.writeDocument(repSchemaDoc, this.repSchema);
    }

    public DoUnSquashing(String snapshotSchema, String temporalAnnotation, String physicalAnnotation, int schemaVersion) {
        this.init();
        this.repSchemaNameAlias = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":" : "";
        this.ti = new TargetIdentifier(this.conventionalSchemaDoc);
        this.lav = new LogicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.pav = new PhysicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.defaultPav = new PhysicalAnnotationValidator(this.defaultAnnotationDoc, this.conventionalSchemaDoc, this.ti, true);
        DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
        Document repSchemaDoc = doSchemaMapping.createRepresentationalSchema(snapshotSchema, temporalAnnotation, physicalAnnotation, 0);
        this.cp.writeDocument(repSchemaDoc, this.repSchema);
    }

    private void init() {
        this.cp = ConventionalParser.getInstance();
        this.vp = ValidatorProperties.getInstance();
    }

    @Override
    public Hashtable unSquash(String tempDataDir, String temporalDocument) {
        if (this.pav.getRepType().equals("edit")) {
            System.out.println("edit based unsquash");
            return this.unSquashEdit(temporalDocument);
        }
        if (this.pav.getRepType().equals("versioned")) {
            System.out.println("item based unsquash");
            return this.unSquashVer(tempDataDir, temporalDocument);
        }
        TauLogger.logger.info((Object)("Unknown representation type \"" + this.pav.getRepType() + "\""));
        System.exit(3);
        return null;
    }

    @Override
    public ArrayList getSnapshots() {
        if (this.pav.getRepType().equals("edit")) {
            return this.snapshotsEdit;
        }
        if (this.pav.getRepType().equals("versioned")) {
            // empty if block
        }
        TauLogger.logger.info((Object)("Unknown representation type \"" + this.pav.getRepType() + "\""));
        System.exit(3);
        return null;
    }

    public Hashtable unSquashVer(String tempDataDir, String temporalDocument) {
        long t1 = System.nanoTime();
        TauLogger.logger.info((Object)"UnSquashing with version-based representation.");
        this.temporalDoc = this.cp.parseDocument(tempDataDir + "/" + temporalDocument, null, this.conventionalSchema, false);
        Primitives primitives = null;
        long t1t = System.nanoTime();
        primitives = new Primitives(this.ti, this.lav, this.defaultPav, this.repSchemaNameAlias);
        primitives.temporalToPhysicalConversion(this.temporalDoc);
        long t2t = System.nanoTime();
        Common.printElaspedTime("   TempToPhysical", t1t, t2t);
        t1t = System.nanoTime();
        Element temporalRoot = this.temporalDoc.getDocumentElement();
        Hashtable snapshots = this.getSnapshots(temporalRoot);
        t2t = System.nanoTime();
        Common.printElaspedTime("   getSnapshots", t1t, t2t);
        long t2 = System.nanoTime();
        Common.printElaspedTime("unsquashItem", t1, t2);
        return snapshots;
    }

    public Hashtable unSquash(Element temporalRoot) {
        this.temporalDoc = this.cp.createDocument(this.vp.getProperty("RepSchemaURL"), this.repSchemaNameAlias + "temporalRoot", null);
        Element newtemporalRoot = this.temporalDoc.getDocumentElement();
        Element importedtemporalRoot = (Element)this.temporalDoc.importNode(temporalRoot, true);
        NodeList nl = importedtemporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            newtemporalRoot.appendChild(nl.item(i));
        }
        newtemporalRoot.setAttribute("begin", temporalRoot.getAttribute("begin"));
        newtemporalRoot.setAttribute("end", temporalRoot.getAttribute("end"));
        newtemporalRoot.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        Primitives primitives = new Primitives(this.ti, this.lav, this.pav, this.repSchemaNameAlias);
        primitives.physicalToTemporalConversion(this.temporalDoc);
        primitives = new Primitives(this.ti, this.lav, this.defaultPav, this.repSchemaNameAlias);
        primitives.temporalToPhysicalConversion(this.temporalDoc);
        Hashtable snapshots = this.getSnapshots(newtemporalRoot);
        return snapshots;
    }

    public Hashtable getSnapshots(Element temporalRoot) {
        Hashtable<ITimePeriod, Element> snapshots = new Hashtable<ITimePeriod, Element>();
        Node originalRoot = null;
        NodeList nl = temporalRoot.getChildNodes();
        for (int i = 2; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            originalRoot = (Element)nl.item(i);
            break;
        }
        RepItem rootRepItem = new RepItem(originalRoot, originalRoot.getLocalName());
        Iterator versionIterator = rootRepItem.getVersionIterator();
        Iterator teIterator = rootRepItem.getTemporalElement().iterator();
        while (versionIterator.hasNext() && teIterator.hasNext()) {
            Element version = (Element)versionIterator.next();
            ITimePeriod tp = (ITimePeriod)teIterator.next();
            snapshots.put(tp, version);
        }
        return snapshots;
    }

    public Document getSnapshot(String temporalDocument, String strDate) {
        this.temporalDoc = this.cp.parseDocument(temporalDocument, null, this.repSchema);
        Element temporalRoot = this.temporalDoc.getDocumentElement();
        return this.getSnapshot(temporalRoot, strDate);
    }

    public Document getSnapshot(Element temporalRoot, String strDate) {
        Date endDate;
        Date beginDate;
        Date date;
        String strBeginDate = temporalRoot.getAttribute("begin");
        String strEndDate = temporalRoot.getAttribute("end");
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(strDate);
            beginDate = sdf.parse(strBeginDate);
            endDate = sdf.parse(strEndDate);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Document snapshotDoc = this.cp.createDocument(null, "root", null);
        if (beginDate.equals(date) || beginDate.before(date) && endDate.after(date)) {
            Element originalRoot = null;
            NodeList nl = temporalRoot.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                originalRoot = (Element)nl.item(i);
                break;
            }
            Element importedRoot = (Element)snapshotDoc.importNode(originalRoot, true);
            snapshotDoc.getDocumentElement().appendChild(importedRoot);
            this.extractSnapshot(snapshotDoc, importedRoot, date);
        }
        return snapshotDoc;
    }

    private void extractSnapshot(Document doc, Element e, Date date) {
        Element snapshotElement;
        if ("y".equals(e.getAttribute("isItem"))) {
            RepItem repItem = new RepItem(e, "");
            snapshotElement = repItem.getSnapshot(date);
            if (snapshotElement != null) {
                e.getParentNode().replaceChild(snapshotElement, e);
            } else {
                e.getParentNode().removeChild(e);
            }
        } else {
            snapshotElement = e;
        }
        if (snapshotElement != null) {
            NodeList nl = snapshotElement.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                this.extractSnapshot(doc, (Element)nl.item(i), date);
            }
        }
    }

    public Hashtable unSquashEdit(String temporalDocument) {
        long t1s = System.nanoTime();
        this.snapshotsEdit = new ArrayList();
        TauLogger.logger.info((Object)"UnSquashing with edit-based representation.");
        this.cp.parseDocument(this.repSchema, null, this.vp.getProperty("XMLSchema"), false);
        this.temporalDoc = this.cp.parseDocument(temporalDocument, null, this.repSchema, false);
        Element temporalRoot = this.temporalDoc.getDocumentElement();
        NodeList nl = temporalRoot.getChildNodes();
        boolean firstElementFound = false;
        String lastFileName = "";
        String lastDate = "";
        String date = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            String fileName;
            Node a = nl.item(i);
            if (!Common.isElement(a) || !Common.isNamed(a, "timestamp_TransExtent")) continue;
            String beginDate = ((Element)a).getAttribute("begin");
            String endDate = ((Element)a).getAttribute("end");
            if (endDate.equals("")) {
                endDate = "9999-12-31";
            }
            TimePeriod tp = new TimePeriod(beginDate, endDate);
            if (!firstElementFound) {
                firstElementFound = true;
                Element version = Common.getNextElement(a);
                fileName = "slice_" + beginDate + "_" + endDate + ".xml";
                this.cp.writeElement(version, fileName);
                Common.filterEditOutput(fileName);
                lastFileName = fileName;
                lastDate = endDate;
                SnapshotContainer sc = new SnapshotContainer(tp, fileName);
                this.snapshotsEdit.add(sc);
                long t2 = System.nanoTime();
                continue;
            }
            date = ((Element)a).getAttribute("begin");
            fileName = "slice_" + beginDate + "_" + endDate + ".xml";
            Common.runPatchCommand((Element)a, lastFileName, fileName);
            lastFileName = fileName;
            SnapshotContainer sc = new SnapshotContainer(tp, fileName);
            this.snapshotsEdit.add(sc);
            lastDate = date;
            long t2 = System.nanoTime();
        }
        long t2s = System.nanoTime();
        Common.printElaspedTime("unsquashEdit total", t1s, t2s);
        return new Hashtable();
    }

    private void createDefaultPhysicalAnnotationDoc() {
        String topLevelElementName = this.getTopLevelSchemaElementName();
        try {
            this.defaultPhysicalAnnotationDoc = this.cp.createDocument(null, "physicalAnnotations", null);
            Element rootElement = this.defaultPhysicalAnnotationDoc.getDocumentElement();
            Element stampElement = this.defaultPhysicalAnnotationDoc.createElement("stamp");
            Element stampKindElement = this.defaultPhysicalAnnotationDoc.createElement("stampKind");
            stampKindElement.setAttribute("timeDimension", "transactionTime");
            stampKindElement.setAttribute("stampBounds", "extent");
            stampElement.appendChild(stampKindElement);
            stampElement.setAttribute("target", "/" + topLevelElementName);
            stampElement.setAttribute("dataInclusion", "expandedVersion");
            rootElement.appendChild(stampElement);
            String temporalDocFile = this.vp.getProperty("Scratch") + this.vp.getProperty("DefaultPhysicalAnnotationFile");
            this.cp.writeDocument(this.defaultPhysicalAnnotationDoc, temporalDocFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTopLevelSchemaElementName() {
        return this.ti.getTopLevelElement().getAttribute("name");
    }
}

