/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.DecomposedRepresentationFactory;
import cs.arizona.tau.xml.DoSchemaMapping;
import cs.arizona.tau.xml.DoSquashing;
import cs.arizona.tau.xml.IDoTemporalValidation;
import cs.arizona.tau.xml.IDoUnSquashing;
import cs.arizona.tau.xml.Item;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.tau.xml.Primitives;
import cs.arizona.tau.xml.RepItem;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DoTemporalValidation
implements IDoTemporalValidation {
    private ConventionalParser cp;
    private ValidatorProperties vp;
    private Document bundleDoc;
    private String temporalSchema;
    private Hashtable itemTable = new Hashtable();
    private ArrayList itemList;
    Document temporalDoc;
    private Document defaultPhysicalAnnotationDoc = null;
    TargetIdentifier ti;
    LogicalAnnotationValidator tav;
    PhysicalAnnotationValidator pav;
    PhysicalAnnotationValidator defaultPav;
    String repSchemaNameAlias;
    private boolean schemaVersion;
    private Document annotationDoc;
    private Document conventionalSchemaDoc;

    public DoTemporalValidation(Document bundleDoc, int schemaVersion) {
        this.bundleDoc = bundleDoc;
        this.init();
        this.repSchemaNameAlias = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":" : "";
    }

    public DoTemporalValidation(String temporalBundle, int schemaVersion) {
        this.temporalSchema = temporalBundle;
        this.schemaVersion = Boolean.parseBoolean(Integer.toString(schemaVersion));
        this.init();
        this.repSchemaNameAlias = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":" : "";
        TemporalSchema ts = new TemporalSchema(this.vp, this.cp, this.temporalSchema);
        this.annotationDoc = ts.getAnnotationDoc();
        this.conventionalSchemaDoc = ts.getConventionalSchemaDoc();
        this.ti = new TargetIdentifier(this.conventionalSchemaDoc);
        this.tav = new LogicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.tav.validateLogicalAnnotation();
        this.pav = new PhysicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.pav.validatePhysicalAnnotation();
        this.defaultPhysicalAnnotationDoc = Common.createDefaultAnnotationDoc(this.cp, Common.getTopLevelSchemaElementName(this.ti));
        this.defaultPav = new PhysicalAnnotationValidator(this.defaultPhysicalAnnotationDoc, this.conventionalSchemaDoc, this.ti, true);
    }

    public DoTemporalValidation(String snapshotSchema, String temporalAnnotation, String physicalAnnotation, int schemaVersion) {
        this.init();
        this.repSchemaNameAlias = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":" : "";
        Document snapshotSchemaDoc = this.cp.parseDocument(snapshotSchema, null, this.vp.getProperty("XMLSchema"), false);
        this.ti = new TargetIdentifier(snapshotSchemaDoc);
        Document temporalAnnotationDoc = this.cp.parseDocument(temporalAnnotation, null, this.vp.getProperty("TXSchema"));
        Document physicalAnnotationDoc = this.cp.parseDocument(physicalAnnotation, null, this.vp.getProperty("PXSchema"));
        this.tav = new LogicalAnnotationValidator(temporalAnnotationDoc, snapshotSchemaDoc, this.ti, true);
        this.pav = new PhysicalAnnotationValidator(physicalAnnotationDoc, snapshotSchemaDoc, this.ti, true);
        this.defaultPav = new PhysicalAnnotationValidator(this.defaultPhysicalAnnotationDoc, snapshotSchemaDoc, this.ti, true);
        Common.validateAnnotations(this.tav, this.pav);
    }

    public DoTemporalValidation(TargetIdentifier ti, LogicalAnnotationValidator tav, PhysicalAnnotationValidator pav, int schemaVersion) {
        this.ti = ti;
        this.tav = tav;
        this.pav = pav;
        this.repSchemaNameAlias = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":" : "";
        this.init();
    }

    private void init() {
        this.cp = ConventionalParser.getInstance();
        this.vp = ValidatorProperties.getInstance();
        this.itemList = new ArrayList();
    }

    private void collectItems(Element e) {
        String targetName = "";
        RepItem repItem = null;
        if ("y".equals(e.getAttribute("isItem"))) {
            targetName = e.getAttribute("originalElement");
            repItem = new RepItem(e, targetName);
            Item item = this.tav.getItemPrototype(targetName);
            item.getItemIdentifier().updateFieldValues(repItem.getVersion(0), this.temporalDoc);
            item.addVersionAll(repItem.getVersions(), repItem.getTemporalElement());
            Item oldItem = null;
            Enumeration items = this.itemTable.elements();
            boolean found = false;
            while (items.hasMoreElements()) {
                oldItem = (Item)items.nextElement();
                if (!oldItem.getItemIdentifier().equals(item.getItemIdentifier())) continue;
                found = true;
                break;
            }
            if (found) {
                oldItem.addVersionAll(item.getVersions(), item.getTemporalElement());
            } else {
                this.itemTable.put(item.getItemIdentifier(), item);
            }
            Iterator versionIterator = repItem.getVersionIterator();
            while (versionIterator.hasNext()) {
                Element currVersion = (Element)versionIterator.next();
                NodeList nl = currVersion.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    if (nl.item(i).getNodeType() != 1) continue;
                    this.collectItems((Element)nl.item(i));
                }
            }
        } else {
            targetName = e.getLocalName();
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                this.collectItems((Element)nl.item(i));
            }
        }
    }

    @Override
    public boolean validate(String temp_data_dir, String temporalDocument) {
        if (this.pav.getRepType().equals("edit")) {
            return this.validateEdit(temporalDocument);
        }
        if (this.pav.getRepType().equals("versioned")) {
            return this.validateVer(temp_data_dir, temporalDocument);
        }
        TauLogger.logger.info((Object)("Unknown representation type \"" + this.pav.getRepType() + "\""));
        System.exit(3);
        return false;
    }

    public boolean validateVer(String temp_data_dir, String strTemporalDoc) {
        String strRepSchemaDoc = "";
        String strScratchBase = "";
        try {
            DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
            Document repSchemaDoc = doSchemaMapping.createRepresentationalSchema(this.temporalSchema, -1);
            strRepSchemaDoc = temp_data_dir + "/tempRepSchema.xsd";
            this.cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.temporalDoc = this.cp.parseDocument(temp_data_dir + "/" + strTemporalDoc, null, strRepSchemaDoc, false);
        TemporalConstraintValidator tcv = new TemporalConstraintValidator(this.temporalDoc, this.temporalSchema);
        return tcv.PerformValidation();
    }

    public boolean validateVer(Document d) {
        long t1 = System.nanoTime();
        this.temporalDoc = d;
        Primitives primitives = new Primitives(this.ti, this.tav, this.defaultPav, this.repSchemaNameAlias);
        primitives.physicalToTemporalConversion(d);
        Element temporalRoot = d.getDocumentElement();
        TimePeriod documentExistencePeriod = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
        Element originalRoot = null;
        NodeList nl = temporalRoot.getChildNodes();
        for (int i = 2; i < nl.getLength(); ++i) {
            if (!Common.isElement(nl.item(i))) continue;
            originalRoot = (Element)nl.item(i);
            break;
        }
        this.collectItems(originalRoot);
        boolean valid = true;
        Enumeration items = this.itemTable.elements();
        while (items.hasMoreElements()) {
            Item item = (Item)items.nextElement();
            this.itemList.add(item);
            TauLogger.logger.info((Object)("Validating item: " + item.toString()));
            if (item.validate(documentExistencePeriod, this.tav, d)) continue;
            valid = false;
        }
        long t2 = System.nanoTime();
        Common.printElaspedTime("ValidateItem total", t1, t2);
        return valid;
    }

    public boolean validate(Element temporalRoot) {
        Element originalRoot = null;
        this.temporalDoc = this.cp.createDocument(this.vp.getProperty("RepSchemaURL"), this.repSchemaNameAlias + "temporalRoot", null);
        Element newtemporalRoot = this.temporalDoc.getDocumentElement();
        Element importedtemporalRoot = (Element)this.temporalDoc.importNode(temporalRoot, true);
        NodeList nl = importedtemporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            newtemporalRoot.appendChild(nl.item(i));
        }
        newtemporalRoot.setAttribute("begin", temporalRoot.getAttribute("begin"));
        newtemporalRoot.setAttribute("end", temporalRoot.getAttribute("end"));
        newtemporalRoot.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        TimePeriod documentExistencePeriod = new TimePeriod(newtemporalRoot.getAttribute("begin"), newtemporalRoot.getAttribute("end"));
        Primitives primitives = new Primitives(this.ti, this.tav, this.pav, this.repSchemaNameAlias);
        primitives.physicalToTemporalConversion(this.temporalDoc);
        nl = newtemporalRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            originalRoot = (Element)nl.item(i);
            break;
        }
        this.collectItems(originalRoot);
        boolean valid = true;
        Enumeration items = this.itemTable.elements();
        while (items.hasMoreElements()) {
            Item item = (Item)items.nextElement();
            if (item.validate(documentExistencePeriod, this.tav, this.temporalDoc)) continue;
            valid = false;
        }
        return valid;
    }

    public Hashtable getItemTable() {
        return this.itemTable;
    }

    public boolean validateEdit2(String temporalDocument) {
        Document thisSlice;
        String strRepSchemaDoc = "";
        String strScratchBase = "";
        boolean valid = true;
        String tempDataDir = "/tmp";
        DecomposedRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
        IDoUnSquashing doUnSquashing = iRepFactory.createUnSquashingObj(tempDataDir, "./config.xml", this.schemaVersion);
        String configDir = Common.getDirectory(temporalDocument);
        String baseFileName = Common.getFileName(temporalDocument);
        Hashtable snapshots = doUnSquashing.unSquash(tempDataDir, temporalDocument);
        Element thisE = null;
        Element lastE = null;
        ArrayList<Document> docs = new ArrayList<Document>();
        Enumeration enumeration = snapshots.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            String path = (String)snapshots.get(enumeration.nextElement());
            thisSlice = this.cp.parseDocument(path, null, null, false);
            docs.add(thisSlice);
        }
        Iterator tItr = this.tav.getTargetIterator();
        while (tItr.hasNext()) {
            String tgt = (String)tItr.next();
            tgt = Common.getLastElementNameFromString(tgt);
            for (int j = 0; j < docs.size(); ++j) {
                thisSlice = (Document)docs.get(j);
                thisE = Common.getFirstElementNamed(thisSlice, tgt);
                if (thisE == null) {
                    TauLogger.logger.fatal((Object)("Slice doesn't have element \"" + tgt + "\" : " + Common.getFileName(thisSlice.getDocumentURI())));
                    return false;
                }
                if (i > 0) {
                    TauLogger.logger.info((Object)("Validating slice: " + Common.getFileName(thisSlice.getDocumentURI())));
                    if (!thisE.isEqualNode(lastE)) {
                        TauLogger.logger.fatal((Object)"Content is specified as CONTENT_CONSTANT but is not CONSTANT.");
                        return false;
                    }
                }
                ++i;
                lastE = thisE;
            }
        }
        return valid;
    }

    public boolean validateEdit(String temporalDocument) {
        boolean valid = true;
        String tempDataDir = "/tmp";
        DecomposedRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
        IDoUnSquashing doUnSquashing = iRepFactory.createUnSquashingObj(tempDataDir, "./config.xml", this.schemaVersion);
        Hashtable dummy = doUnSquashing.unSquash(tempDataDir, temporalDocument);
        ArrayList snapshots = doUnSquashing.getSnapshots();
        DoSquashing doSquashing = new DoSquashing();
        Document d = doSquashing.squashDefault(snapshots);
        return this.validateVer(d);
    }
}

