/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.IDoSquashing;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.tau.xml.Primitives;
import cs.arizona.tau.xml.RepItem;
import cs.arizona.tau.xml.SnapshotContainer;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DoSquashing
implements IDoSquashing {
    private Document temporalSchemaDoc;
    private String temporalSchema;
    private String conventionalSchema;
    private String annotation;
    private String mOutputFileName = "squashed.xml";
    private Document conventionalSchemaDoc;
    private Document temporalDoc = null;
    private Document annotationDoc;
    private Document defaultAnnotationDoc = null;
    TargetIdentifier ti;
    LogicalAnnotationValidator lav;
    PhysicalAnnotationValidator pav;
    PhysicalAnnotationValidator defaultPav;
    ValidatorProperties vp;
    ConventionalParser cp;
    String repSchemaNameAlias;

    private void init() {
        this.vp = ValidatorProperties.getInstance();
        this.cp = ConventionalParser.getInstance();
        this.repSchemaNameAlias = "";
        TauLogger.init();
    }

    private void init(int schemaVersion) {
        this.repSchemaNameAlias = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":" : "";
        this.temporalDoc = this.cp.createDocument("", this.repSchemaNameAlias + "temporalRoot", null);
        this.ti = new TargetIdentifier(this.conventionalSchemaDoc);
        this.defaultAnnotationDoc = Common.createDefaultAnnotationDoc(this.cp, Common.getTopLevelSchemaElementName(this.ti));
        this.lav = new LogicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.pav = new PhysicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        this.defaultPav = new PhysicalAnnotationValidator(this.defaultAnnotationDoc, this.conventionalSchemaDoc, this.ti, true);
        Common.validateAnnotations(this.lav, this.pav);
    }

    public DoSquashing(String temporalSchema, int schemaVersion) {
        this.init();
        this.temporalSchema = temporalSchema;
        TemporalSchema ts = new TemporalSchema(this.vp, this.cp, temporalSchema);
        this.temporalSchemaDoc = ts.getTemporalSchemaDoc();
        this.annotationDoc = ts.getAnnotationDoc();
        this.conventionalSchemaDoc = ts.getConventionalSchemaDoc();
        this.init(schemaVersion);
    }

    public DoSquashing() {
        this.init();
        this.temporalDoc = this.cp.createDocument("", "temporalRoot", null);
    }

    public DoSquashing(String snapshotSchema, String annotation, int schemaVersion) {
        this.init();
        this.conventionalSchema = snapshotSchema;
        this.annotation = annotation;
        this.init(schemaVersion);
    }

    @Override
    public void setOutputFileName(String tempDataDir, String name) {
        this.mOutputFileName = tempDataDir + "/" + name;
    }

    @Override
    public Document squash(String tempDataDir, String tempDataFile) {
        Document temporalDoc = null;
        String temporalDir = "";
        temporalDir = Common.getDirectory(tempDataFile);
        temporalDoc = this.cp.parseDocument(tempDataDir + "/" + tempDataFile, null, this.vp.getProperty("TDSchema"));
        if (this.pav.getRepType().equals("edit")) {
            System.out.println("edit based squashing");
            return this.squashEdit(temporalDir, temporalDoc.getDocumentElement());
        }
        if (this.pav.getRepType().equals("versioned")) {
            System.out.println("item based squashing");
            return this.squash(tempDataDir, temporalDir, temporalDoc.getDocumentElement());
        }
        TauLogger.logger.info((Object)("Unknown representation type \"" + this.pav.getRepType() + "\""));
        System.exit(3);
        return null;
    }

    public Document squashEdit(String temporalDir, Element temporalRootElement) {
        long t1e = System.nanoTime();
        String beginDate = "";
        String endDate = "";
        String snapshotFile = "";
        String firstDate = "";
        String lastDate = "";
        String lastFile = "";
        String newFile = "";
        String originalRoot = "";
        Document snapshotDoc = null;
        Element temporalRoot = this.temporalDoc.getDocumentElement();
        NodeList nl = temporalRootElement.getElementsByTagName("slice");
        int lastI = nl.getLength() - 1;
        Element root1 = null;
        TauLogger.logger.info((Object)"Squashing with edit-based representation.");
        long t1l = System.nanoTime();
        for (int i = lastI; i >= 0; --i) {
            Element currElement = (Element)nl.item(i);
            beginDate = currElement.getAttribute("begin");
            endDate = currElement.getAttribute("end");
            if (endDate == "") {
                endDate = "9999-12-31";
            }
            TimePeriod transactionPeriod = new TimePeriod(beginDate, endDate);
            snapshotFile = temporalDir + currElement.getAttribute("location");
            snapshotDoc = this.cp.parseURI(snapshotFile);
            Element time = transactionPeriod.toXML(1, 1, this.temporalDoc);
            Element root2 = this.temporalDoc.getDocumentElement();
            if (i == lastI) {
                lastDate = endDate;
                newFile = snapshotFile + ".tmp";
                Common.filterEditInput(snapshotFile, newFile);
                snapshotDoc = this.cp.parseURI(newFile);
                root1 = snapshotDoc.getDocumentElement();
                Node importedNode = this.temporalDoc.importNode(root1, true);
                time.appendChild(importedNode);
                root2.appendChild(time);
                lastFile = snapshotFile;
                originalRoot = root1.getLocalName();
                Common.deleteFile(newFile);
                continue;
            }
            firstDate = beginDate;
            Common.runDiffCommand(lastFile, snapshotFile, this.temporalDoc, root2, beginDate, endDate);
            lastFile = snapshotFile;
        }
        long t2l = System.nanoTime();
        Common.printElaspedTime("      loop", t1l, t2l);
        temporalRoot.setAttribute("begin", firstDate);
        temporalRoot.setAttribute("end", lastDate);
        temporalRoot.setAttribute("originalRoot", originalRoot);
        temporalRoot.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        temporalRoot.setAttribute("temporalSchemaLocation", "TODO");
        this.cp.writeDocument(this.temporalDoc, this.mOutputFileName);
        long t2e = System.nanoTime();
        Common.printElaspedTime("   squashEdit", t1e, t2e);
        return this.temporalDoc;
    }

    public Document squash(String tempDataDir, String temporalDir, Element temporalRootElement) {
        long t1 = System.nanoTime();
        TauLogger.logger.info((Object)"Squashing with item-based representation.");
        String beginDate = "";
        String endDate = "";
        String snapshotFile = "";
        String firstDate = "";
        Document snapshotDoc = null;
        Element importedElement = null;
        Element temporalRoot = this.temporalDoc.getDocumentElement();
        RepItem repItem = null;
        NodeList tempSchemaSet = temporalRootElement.getElementsByTagName("temporalSchema");
        Element temporalSchemaSet = this.temporalDoc.createElement("temporalSchemaSet");
        for (int i = 0; i < tempSchemaSet.getLength(); ++i) {
            Element temporalSchema = this.temporalDoc.createElement("temporalSchema");
            temporalSchema.setAttribute("schemaLocation", ((Element)tempSchemaSet.item(i)).getAttribute("schemaLocation"));
            temporalSchemaSet.appendChild(temporalSchema);
        }
        NodeList nl = temporalRootElement.getElementsByTagName("slice");
        long t1r = System.nanoTime();
        repItem = new RepItem(Common.getTopLevelSchemaElementName(this.ti), 1, 1);
        long t2r = System.nanoTime();
        Common.printElaspedTime("   RepItem", t1r, t2r);
        long t1l = System.nanoTime();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element currElement = (Element)nl.item(i);
            beginDate = currElement.getAttribute("begin");
            endDate = currElement.getAttribute("end");
            if (endDate == "") {
                endDate = "9999-12-31";
            }
            if (i == 0) {
                firstDate = beginDate;
            }
            TimePeriod transactionPeriod = new TimePeriod(beginDate, endDate);
            snapshotFile = tempDataDir + "/" + currElement.getAttribute("location");
            TauLogger.logger.info((Object)("Squashing slice " + snapshotFile));
            snapshotDoc = this.cp.parseURI(snapshotFile);
            importedElement = (Element)this.temporalDoc.importNode(snapshotDoc.getDocumentElement(), true);
            this.removeStandardAttributesFromRootNode(importedElement);
            repItem.addVersion(importedElement, transactionPeriod);
        }
        long t2l = System.nanoTime();
        Common.printElaspedTime("   Loop", t1l, t2l);
        temporalRoot.setAttribute("begin", firstDate);
        temporalRoot.setAttribute("end", endDate);
        temporalRoot.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        temporalRoot.appendChild(repItem.toXML(this.temporalDoc, this.repSchemaNameAlias));
        long t1p = System.nanoTime();
        TauLogger.logger.info((Object)"Physical to Temporal conversion");
        Primitives primitives = new Primitives(this.ti, this.lav, this.defaultPav, this.repSchemaNameAlias);
        primitives.physicalToTemporalConversion(this.temporalDoc);
        long t2p = System.nanoTime();
        Common.printElaspedTime("   PhysToTemp", t1p, t2p);
        long t1t = System.nanoTime();
        TauLogger.logger.info((Object)"Temporal to Physical conversion");
        primitives = new Primitives(this.ti, this.lav, this.pav, this.repSchemaNameAlias);
        primitives.temporalToPhysicalConversion(this.temporalDoc);
        long t2t = System.nanoTime();
        Common.printElaspedTime("   tempToPhys", t1t, t2t);
        temporalRoot.insertBefore(temporalSchemaSet, temporalRoot.getFirstChild());
        this.cp.writeDocument(this.temporalDoc, this.mOutputFileName);
        long t2 = System.nanoTime();
        Common.printElaspedTime("squashItem", t1, t2);
        return this.temporalDoc;
    }

    public Document squashDefault(ArrayList docs) {
        long t1 = System.nanoTime();
        TauLogger.logger.info((Object)"Squashing with item-based representation, default physical annotations.");
        String beginDate = "";
        String endDate = "";
        String snapshotFile = "";
        String firstDate = "";
        String lastDate = "";
        String originalRoot = "";
        Document snapshotDoc = null;
        Element importedElement = null;
        Element temporalRoot = this.temporalDoc.getDocumentElement();
        RepItem repItem = null;
        SnapshotContainer sc1 = (SnapshotContainer)docs.get(0);
        Document d = this.cp.parseDocument(sc1.fileName, null, "", false);
        String rootName = d.getDocumentElement().getLocalName();
        repItem = new RepItem(rootName, 1, 1);
        int i = 0;
        for (int j = docs.size() - 1; j >= 0; --j) {
            SnapshotContainer sc = (SnapshotContainer)docs.get(j);
            ITimePeriod tp = sc.tp;
            snapshotFile = sc.fileName;
            snapshotDoc = this.cp.parseDocument(snapshotFile, null, null, false);
            beginDate = Common.formatDate2(tp.getBeginDate());
            endDate = Common.formatDate2(tp.getEndDate());
            if (i++ == 0) {
                originalRoot = snapshotDoc.getDocumentElement().getLocalName();
                firstDate = beginDate;
            } else {
                lastDate = endDate;
            }
            importedElement = (Element)this.temporalDoc.importNode(snapshotDoc.getDocumentElement(), true);
            this.removeStandardAttributesFromRootNode(importedElement);
            repItem.addVersion(importedElement, tp);
        }
        temporalRoot.setAttribute("begin", firstDate);
        temporalRoot.setAttribute("end", lastDate);
        temporalRoot.setAttribute("originalRoot", originalRoot);
        temporalRoot.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        temporalRoot.appendChild(repItem.toXML(this.temporalDoc, this.repSchemaNameAlias));
        long t2 = System.nanoTime();
        Common.printElaspedTime("squashDefault", t1, t2);
        return this.temporalDoc;
    }

    private void removeStandardAttributesFromRootNode(Element element) {
        int i;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ArrayList<String> remAttrs = new ArrayList<String>();
        ht.put("attributeFormDefault", "");
        ht.put("elementFormDefault", "");
        NamedNodeMap nnm = element.getAttributes();
        for (i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            if (!ht.containsKey(n.getNodeName()) && !n.getNodeName().startsWith("xsi")) continue;
            remAttrs.add(n.getNodeName());
        }
        for (i = 0; i < remAttrs.size(); ++i) {
            element.removeAttribute((String)remAttrs.get(i));
            TauLogger.logger.debug((Object)("Removing attribute \"" + (String)remAttrs.get(i) + "\" from element \"" + element.getLocalName() + "\""));
        }
    }
}

