/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.xml.IDoSchemaMapping;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

public class DoSchemaMapping
implements IDoSchemaMapping {
    private int VALIDATE_TEMPORAL_ANNOTATION = 1;
    private int VALIDATE_PHYSICAL_ANNOTATION = 2;
    private int CREATE_REP_SCHEMA = 3;
    private String temporalSchema;
    private String conventionalSchema;
    private String annotation;
    private Document conventionalSchemaDoc;
    private Document annotationDoc;
    private String temporalAnnotation;
    private String physicalAnnotation;
    private String snapshotSchema;
    private Document snapshotSchemaDocument;
    private Document temporalAnnotationDocument;
    private Document physicalAnnotationDocument;
    TargetIdentifier ti;
    LogicalAnnotationValidator lav;
    PhysicalAnnotationValidator pav;
    ValidatorProperties vp;
    ConventionalParser cp;

    public DoSchemaMapping() {
        this.init();
    }

    private void init() {
        this.vp = ValidatorProperties.getInstance();
        this.cp = ConventionalParser.getInstance();
        TauLogger.init();
    }

    public boolean validateTemporalAnnotation(String temporalBundle) {
        this.parseInput(temporalBundle, this.VALIDATE_TEMPORAL_ANNOTATION);
        return true;
    }

    public boolean validatePhysicalAnnotation(String temporalBundle) {
        this.parseInput(temporalBundle, this.VALIDATE_PHYSICAL_ANNOTATION);
        return true;
    }

    public Document createRepresentationalSchema(String temporalSchema, int schemaVersion) {
        this.temporalSchema = temporalSchema;
        this.parseInput(temporalSchema, this.CREATE_REP_SCHEMA);
        this.performValidations();
        Hashtable<String, Element> targetElements = this.pav.getTargetElements();
        this.addTimeVaryingRoot(targetElements);
        Enumeration<String> targets = targetElements.keys();
        while (targets.hasMoreElements()) {
            String targetName = targets.nextElement();
            this.convertElement(targetName, targetElements.get(targetName));
        }
        return this.snapshotSchemaDocument;
    }

    public void writeDocument(Document doc, String fileName) {
        this.cp.writeDocument(doc, fileName);
    }

    public Document createRepresentationalSchema(String snapshotSchema, String temporalAnnotation, String physicalAnnotation, int schemaVersion) {
        this.snapshotSchemaDocument = this.cp.parseDocument(snapshotSchema, null, this.vp.getProperty("XMLSchema"));
        this.ti = new TargetIdentifier(this.snapshotSchemaDocument);
        this.temporalAnnotationDocument = this.cp.parseDocument(temporalAnnotation, null, this.vp.getProperty("TXSchema"));
        this.physicalAnnotationDocument = this.cp.parseDocument(physicalAnnotation, null, this.vp.getProperty("PXSchema"));
        this.lav = new LogicalAnnotationValidator(this.temporalAnnotationDocument, this.snapshotSchemaDocument, this.ti, false);
        this.lav.validateLogicalAnnotation();
        this.pav = new PhysicalAnnotationValidator(this.physicalAnnotationDocument, this.snapshotSchemaDocument, this.ti, false);
        this.pav.validatePhysicalAnnotation();
        boolean isVald = this.performValidations();
        if (!isVald) {
            TauLogger.logger.info((Object)"DoSchemaMapping: Temporal or Physical Annotation is incorrect. Exiting...");
            System.exit(1);
        } else {
            TauLogger.logger.info((Object)"DoSchemaMapping: Temporal and Physical Annotations are correct.");
        }
        this.modifySchemaElement(schemaVersion);
        Hashtable<String, Element> targetElements = this.pav.getTargetElements();
        this.addTimeVaryingRoot(targetElements);
        Enumeration<String> targets = targetElements.keys();
        while (targets.hasMoreElements()) {
            String targetName = targets.nextElement();
            this.convertElement(targetName, targetElements.get(targetName));
        }
        return this.snapshotSchemaDocument;
    }

    private void modifySchemaElement(int schemaVersion) {
        Element schemaElement = this.snapshotSchemaDocument.getDocumentElement();
        schemaElement.setAttribute("xmlns:xsi", this.vp.getProperty("XMLSchemaInstance"));
        schemaElement.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        schemaElement.setAttribute("attributeFormDefault", "qualified");
        schemaElement.setAttribute("elementFormDefault", "qualified");
        Element tvImportElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "import");
        tvImportElement.setAttribute("namespace", this.vp.getProperty("TVSchemaURL"));
        tvImportElement.setAttribute("schemaLocation", this.vp.getProperty("TVSchema"));
        NodeList nl = schemaElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            schemaElement.insertBefore(tvImportElement, nl.item(i));
            break;
        }
        String namespace = "";
        namespace = schemaVersion >= 0 ? this.vp.getProperty("RepSchemaURL") + schemaVersion : this.vp.getProperty("RepSchemaURL");
    }

    private boolean parseInput(String temporalSchema, int currentTask) {
        String temporalSchemaDir = temporalSchema.substring(0, temporalSchema.lastIndexOf("/")) + "/";
        TemporalSchema ts = new TemporalSchema(this.vp, this.cp, temporalSchema);
        Document temporalSchemaDoc = ts.getTemporalSchemaDoc();
        this.annotationDoc = ts.getAnnotationDoc();
        this.snapshotSchemaDocument = this.conventionalSchemaDoc = ts.getConventionalSchemaDoc();
        this.ti = new TargetIdentifier(this.conventionalSchemaDoc);
        if (currentTask == this.CREATE_REP_SCHEMA) {
            this.lav = new LogicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
            this.pav = new PhysicalAnnotationValidator(this.annotationDoc, this.conventionalSchemaDoc, this.ti, true);
        }
        return true;
    }

    private void convertElement(String targetElementName, Element targetElement) {
        Element root = this.snapshotSchemaDocument.getDocumentElement();
        Element parent = (Element)targetElement.getParentNode();
        targetElement.removeAttribute("abstract");
        this.modifyReferences(targetElementName, targetElement);
        parent.appendChild(this.createRepItemElement(targetElementName, targetElement));
    }

    private void addTimeVaryingRoot(Hashtable targetElements) {
        Element root = this.snapshotSchemaDocument.getDocumentElement();
        Element timeVaryingRootElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        timeVaryingRootElement.setAttribute("name", "temporalRoot");
        Element complexTypeElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "complexType");
        Element sequenceElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "sequence");
        Element beginDateAttr = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "attribute");
        beginDateAttr.setAttribute("name", "begin");
        beginDateAttr.setAttribute("type", this.vp.getProperty("XMLSchemaNameAlias") + "date");
        Element endDateAttr = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "attribute");
        endDateAttr.setAttribute("name", "end");
        endDateAttr.setAttribute("type", this.vp.getProperty("XMLSchemaNameAlias") + "date");
        String topLevelElement = this.ti.getTopLevelElement().getAttribute("name");
        Element refElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        if (targetElements.containsKey(topLevelElement)) {
            refElement.setAttribute("ref", topLevelElement + "_RepItem");
        } else {
            refElement.setAttribute("ref", topLevelElement);
        }
        Element tempSchemaSetEle = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        tempSchemaSetEle.setAttribute("name", "temporalElementSet");
        Element ts_complexTypeElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "complexType");
        Element ts_sequenceElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "sequence");
        Element tempSchemaEle = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        tempSchemaEle.setAttribute("name", "temporalElementSet");
        tempSchemaEle.setAttribute("type", this.vp.getProperty("XMLSchemaNameAlias") + "string");
        Element location_attribute = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "attribute");
        location_attribute.setAttribute("name", "schemaLocation");
        tempSchemaEle.appendChild(location_attribute);
        ts_complexTypeElement.appendChild(ts_sequenceElement);
        tempSchemaSetEle.appendChild(tempSchemaEle);
        tempSchemaSetEle.appendChild(ts_sequenceElement);
        timeVaryingRootElement.appendChild(tempSchemaSetEle);
        timeVaryingRootElement.appendChild(complexTypeElement);
        sequenceElement.appendChild(refElement);
        complexTypeElement.appendChild(sequenceElement);
        complexTypeElement.appendChild(beginDateAttr);
        complexTypeElement.appendChild(endDateAttr);
        root.appendChild(timeVaryingRootElement);
    }

    private Element createTimeVaryingElement(String name) {
        Element timeVaryingElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        Element complexTypeElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "complexType");
        Element attributeElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "attribute");
        timeVaryingElement.appendChild(complexTypeElement);
        complexTypeElement.appendChild(attributeElement);
        timeVaryingElement.setAttribute("name", name + "_TimeVarying");
        attributeElement.setAttribute("name", "itemRef");
        attributeElement.setAttribute("type", "IDREF");
        return timeVaryingElement;
    }

    private Element createRepItemElement(String name, Element targetElement) {
        Element itemElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        Element complexTypeElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "complexType");
        Element sequenceElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "sequence");
        Element versionElement = this.createVersionElement(name, targetElement);
        Element attributeElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "attribute");
        Element isItemAttrElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "attribute");
        isItemAttrElement.setAttribute("name", "isItem");
        isItemAttrElement.setAttribute("type", this.vp.getProperty("XMLSchemaNameAlias") + "string");
        Element originalItemAttrElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "attribute");
        originalItemAttrElement.setAttribute("name", "originalElement");
        originalItemAttrElement.setAttribute("type", this.vp.getProperty("XMLSchemaNameAlias") + "string");
        itemElement.appendChild(complexTypeElement);
        complexTypeElement.appendChild(sequenceElement);
        complexTypeElement.appendChild(isItemAttrElement);
        complexTypeElement.appendChild(originalItemAttrElement);
        sequenceElement.appendChild(versionElement);
        itemElement.setAttribute("name", name + "_RepItem");
        versionElement.setAttribute("minOccurs", "1");
        versionElement.setAttribute("maxOccurs", "unbounded");
        attributeElement.setAttribute("name", "itemID");
        attributeElement.setAttribute("type", "ID");
        return itemElement;
    }

    private Element createVersionElement(String name, Element targetElement) {
        Element versionElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        Element complexTypeElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "complexType");
        Element sequenceElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "sequence");
        Element tvElement = this.snapshotSchemaDocument.createElement(this.vp.getProperty("XMLSchemaNameAlias") + "element");
        versionElement.appendChild(complexTypeElement);
        complexTypeElement.appendChild(sequenceElement);
        sequenceElement.appendChild(tvElement);
        sequenceElement.appendChild(targetElement);
        versionElement.setAttribute("name", name + "_Version");
        tvElement.setAttribute("ref", this.vp.getProperty("TVSchemaNameAlias") + "timestamp_TransExtent");
        return versionElement;
    }

    private void modifyReferences(String targetElementName, Element targetElement) {
        ArrayList<Element> refElements = new ArrayList<Element>();
        if (targetElement.getParentNode().getLocalName() == "schema") {
            Element currentElement;
            String elementName = targetElement.getAttribute("name");
            XPathEvaluatorImpl evaluator = new XPathEvaluatorImpl(this.snapshotSchemaDocument);
            XPathNSResolver resolver = evaluator.createNSResolver(this.snapshotSchemaDocument);
            XPathResult result = (XPathResult)evaluator.evaluate("//" + this.vp.getProperty("XMLSchemaNameAlias") + "element[@ref='" + elementName + "']", this.snapshotSchemaDocument, resolver, (short)5, null);
            while ((currentElement = (Element)result.iterateNext()) != null) {
                System.out.println(currentElement.getAttribute("ref"));
                refElements.add(currentElement);
            }
            for (int i = 0; i < refElements.size(); ++i) {
                ((Element)refElements.get(i)).setAttribute("ref", targetElementName + "_RepItem");
            }
        }
    }

    private boolean performValidations() {
        Iterator tItr = this.lav.getTargetIterator();
        while (tItr.hasNext()) {
            String str = (String)tItr.next();
            Iterator pItr = this.pav.getTargetIterator();
            boolean found = false;
            while (!found && pItr.hasNext()) {
                if (!str.startsWith((String)pItr.next())) continue;
                found = true;
            }
            if (found) continue;
            TauLogger.logger.info((Object)("Cannot find \"" + str + "\""));
            return false;
        }
        return true;
    }
}

