/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.DoSVSchemaMapping;
import cs.arizona.tau.xml.DoUnSquashing;
import cs.arizona.tau.xml.IDoUnSquashing;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.ValidatorProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSException;

public class DoSVUnSquashing
implements IDoUnSquashing {
    private ConventionalParser cp;
    private ValidatorProperties vp;
    private NodeList snapshotElementList;

    public DoSVUnSquashing() {
        this.init();
    }

    @Override
    public ArrayList getSnapshots() {
        return null;
    }

    private void init() {
        this.cp = ConventionalParser.getInstance();
        this.vp = ValidatorProperties.getInstance();
    }

    @Override
    public Hashtable unSquash(String tempDataDir, String strTemporalDoc) {
        String snapshotSchema = null;
        String temporalAnnotation = null;
        String physicalAnnotation = null;
        Hashtable snapshots = new Hashtable();
        try {
            Document temporalDoc = this.cp.parseURI(strTemporalDoc);
            String strTemporalBundle = temporalDoc.getDocumentElement().getAttribute("bundle");
            if (null == strTemporalBundle || "".equals(strTemporalBundle.trim())) {
                System.out.println("The given document does not have bundle");
                throw new RuntimeException("The given document does not have bundle");
            }
            String temporalBundleDir = strTemporalBundle.substring(0, strTemporalBundle.lastIndexOf("/")) + "/";
            String strRepSchemaDoc = temporalBundleDir + "rep.xsd";
            try {
                DoSVSchemaMapping doSVSchemaMapping = new DoSVSchemaMapping();
                Document repSchemaDoc = doSVSchemaMapping.createRepresentationalSchema(strTemporalBundle);
                this.cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            temporalDoc = this.cp.parseDocument(strTemporalDoc, null, strRepSchemaDoc);
            Document temporalBundleDoc = this.cp.parseDocument(strTemporalBundle, null, this.vp.getProperty("TBSchema"));
            NodeList schemaVersions = temporalBundleDoc.getElementsByTagName("schemaAnnotation");
            for (int i = 0; i < schemaVersions.getLength(); ++i) {
                snapshotSchema = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("snapshotSchema");
                temporalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("temporalAnnotation");
                physicalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("physicalAnnotation");
                Element schemaVersionElement = (Element)temporalDoc.getElementsByTagName("schemaVersion" + i).item(0);
                Element temporalRoot = (Element)schemaVersionElement.getElementsByTagName(this.vp.getProperty("RepSchemaNameAlias") + i + ":temporalRoot").item(0);
                DoUnSquashing doUnSquashing = new DoUnSquashing(snapshotSchema, temporalAnnotation, physicalAnnotation, i);
                snapshots.putAll(doUnSquashing.unSquash(temporalRoot));
            }
            return snapshots;
        }
        catch (DOMException de) {
            System.out.println("Error occurred while parsing given Temporal Document.");
            return null;
        }
        catch (LSException le) {
            System.out.println("Unable to load Temporal Bundle Document.");
            le.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println("Some other error occurred.");
            e.printStackTrace();
            return null;
        }
    }

    public Document getSnapshot(String temporalDocument, String strDate) {
        Date date;
        String snapshotSchema = null;
        String temporalAnnotation = null;
        String physicalAnnotation = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(strDate);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        try {
            Document temporalDoc = this.cp.parseURI(temporalDocument);
            String strTemporalBundle = temporalDoc.getDocumentElement().getAttribute("bundle");
            if (null == strTemporalBundle || "".equals(strTemporalBundle.trim())) {
                System.out.println("The given document does not have bundle");
                throw new RuntimeException("The given document does not have bundle");
            }
            String temporalBundleDir = strTemporalBundle.substring(0, strTemporalBundle.lastIndexOf("/")) + "/";
            String strRepSchemaDoc = temporalBundleDir + "rep.xsd";
            try {
                DoSVSchemaMapping doSVSchemaMapping = new DoSVSchemaMapping();
                Document repSchemaDoc = doSVSchemaMapping.createRepresentationalSchema(strTemporalBundle);
                this.cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            temporalDoc = this.cp.parseDocument(temporalDocument, null, strRepSchemaDoc);
            Document temporalBundleDoc = this.cp.parseDocument(strTemporalBundle, null, this.vp.getProperty("TBSchema"));
            NodeList schemaVersions = temporalBundleDoc.getElementsByTagName("schemaAnnotation");
            for (int i = 0; i < schemaVersions.getLength(); ++i) {
                snapshotSchema = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("snapshotSchema");
                temporalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("temporalAnnotation");
                physicalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("physicalAnnotation");
                Element schemaVersionElement = (Element)temporalDoc.getElementsByTagName("schemaVersion" + i).item(0);
                Element temporalRoot = (Element)schemaVersionElement.getElementsByTagName(this.vp.getProperty("RepSchemaNameAlias") + i + ":temporalRoot").item(0);
                TimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
                if (!tp.getBeginDate().equals(date) && (!tp.getBeginDate().before(date) || !tp.getEndDate().after(date))) continue;
                DoUnSquashing doUnSquashing = new DoUnSquashing(snapshotSchema, temporalAnnotation, physicalAnnotation, i);
                return doUnSquashing.getSnapshot(temporalRoot, strDate);
            }
        }
        catch (DOMException de) {
            System.out.println("Error occurred while parsing given Temporal Document.");
            return null;
        }
        catch (LSException le) {
            System.out.println("Unable to load Temporal Bundle Document.");
            le.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println("Some other error occurred.");
            e.printStackTrace();
            return null;
        }
        return null;
    }
}

