/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.ITime;
import cs.arizona.tau.xml.DoSVSchemaMapping;
import cs.arizona.tau.xml.DoTemporalValidation;
import cs.arizona.tau.xml.IDoTemporalValidation;
import cs.arizona.tau.xml.Item;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.tau.xml.SchemaItem;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.ValidatorProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSException;

public class DoSVTemporalValidation
implements IDoTemporalValidation {
    private ConventionalParser cp;
    private ValidatorProperties vp;
    private ArrayList schemaItemList = new ArrayList();
    ArrayList itemIdCorrList = null;
    ArrayList scpTimeSpanList = null;
    ArrayList<TargetIdentifier> tiList = null;
    ArrayList<LogicalAnnotationValidator> tavList = null;
    Hashtable itemFragmentItemMap = null;

    public DoSVTemporalValidation() {
        this.init();
    }

    private void init() {
        this.cp = ConventionalParser.getInstance();
        this.vp = ValidatorProperties.getInstance();
        this.tiList = new ArrayList();
        this.tavList = new ArrayList();
        this.itemFragmentItemMap = new Hashtable();
    }

    @Override
    public boolean validate(String temp_data_dir, String strTemporalDoc) {
        String snapshotSchema = null;
        String temporalAnnotation = null;
        String physicalAnnotation = null;
        Document snapshotSchemaDoc = null;
        Document temporalAnnotationDoc = null;
        Document physicalAnnotationDoc = null;
        boolean valid = true;
        try {
            int i;
            Document temporalDoc = this.cp.parseURI(strTemporalDoc);
            String strTemporalBundle = temporalDoc.getDocumentElement().getAttribute("bundle");
            if (null == strTemporalBundle || "".equals(strTemporalBundle.trim())) {
                System.out.println("The given document does not have bundle");
                throw new RuntimeException("The given document does not have bundle");
            }
            String temporalBundleDir = strTemporalBundle.substring(0, strTemporalBundle.lastIndexOf("/")) + "/";
            String strRepSchemaDoc = temporalBundleDir + "rep.xsd";
            DoSVSchemaMapping doSchemaSchemaMapping = null;
            try {
                doSchemaSchemaMapping = new DoSVSchemaMapping();
                Document repSchemaDoc = doSchemaSchemaMapping.createRepresentationalSchema(strTemporalBundle);
                this.cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.itemIdCorrList = doSchemaSchemaMapping.getItemIdentifierCorrList();
            this.scpTimeSpanList = doSchemaSchemaMapping.getScpTimeSpanList();
            temporalDoc = this.cp.parseDocument(strTemporalDoc, null, strRepSchemaDoc);
            Document temporalBundleDoc = this.cp.parseDocument(strTemporalBundle, null, this.vp.getProperty("TBSchema"));
            NodeList schemaVersions = temporalBundleDoc.getElementsByTagName("schemaAnnotation");
            for (i = 0; i < schemaVersions.getLength(); ++i) {
                snapshotSchema = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("snapshotSchema");
                temporalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("temporalAnnotation");
                physicalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("physicalAnnotation");
                snapshotSchemaDoc = this.cp.parseDocument(snapshotSchema, null, this.vp.getProperty("XMLSchema"));
                TargetIdentifier ti = new TargetIdentifier(snapshotSchemaDoc);
                temporalAnnotationDoc = this.cp.parseDocument(temporalAnnotation, null, this.vp.getProperty("TXSchema"));
                physicalAnnotationDoc = this.cp.parseDocument(physicalAnnotation, null, this.vp.getProperty("PXSchema"));
                LogicalAnnotationValidator tav = new LogicalAnnotationValidator(temporalAnnotationDoc, snapshotSchemaDoc, ti, true);
                tav.validateLogicalAnnotation();
                PhysicalAnnotationValidator pav = new PhysicalAnnotationValidator(physicalAnnotationDoc, snapshotSchemaDoc, ti, true);
                pav.validatePhysicalAnnotation();
                this.tiList.add(ti);
                this.tavList.add(tav);
                Element schemaVersionElement = (Element)temporalDoc.getElementsByTagName("schemaVersion" + i).item(0);
                Element temporalRoot = (Element)schemaVersionElement.getElementsByTagName(this.vp.getProperty("RepSchemaNameAlias") + i + ":temporalRoot").item(0);
                DoTemporalValidation doTemporalValidation = new DoTemporalValidation(ti, tav, pav, i);
                valid = valid && doTemporalValidation.validate(temporalRoot);
                Hashtable itemTable = doTemporalValidation.getItemTable();
                this.bridgeItems(itemTable, i);
            }
            for (i = 0; i < this.schemaItemList.size(); ++i) {
                SchemaItem schemaItem = (SchemaItem)this.schemaItemList.get(i);
                valid = valid && schemaItem.validate(this.tiList, this.tavList, this.itemFragmentItemMap);
            }
            return valid;
        }
        catch (DOMException de) {
            System.out.println("Error occurred while parsing given Temporal Document.");
            return false;
        }
        catch (LSException le) {
            System.out.println("Unable to load Temporal Bundle Document.");
            le.printStackTrace();
            return false;
        }
        catch (Exception e) {
            System.out.println("Some other error occurred.");
            e.printStackTrace();
            return false;
        }
    }

    private void bridgeItems(Hashtable itemTable, int numScp) {
        Enumeration items = itemTable.elements();
        while (items.hasMoreElements()) {
            Item dataItem = (Item)items.nextElement();
            boolean bridged = false;
            int newRelation = dataItem.getTemporalElement().getTimeSpan().getRelationship((ITime)this.scpTimeSpanList.get(numScp));
            if (numScp > 0 && (3 == newRelation || 4 == newRelation)) {
                for (int j = 0; j < this.schemaItemList.size(); ++j) {
                    int oldRelation;
                    SchemaItem schemaItem = (SchemaItem)this.schemaItemList.get(j);
                    Item lastDataItemFragment = schemaItem.getItemFragment(numScp - 1);
                    if (null == lastDataItemFragment || 3 != (oldRelation = lastDataItemFragment.getTemporalElement().getTimeSpan().getRelationship((ITime)this.scpTimeSpanList.get(numScp - 1))) && 6 != oldRelation || !schemaItem.canBeBridged(dataItem, this.itemIdCorrList, numScp)) continue;
                    schemaItem.addItem(dataItem, numScp);
                    this.itemFragmentItemMap.put(dataItem, schemaItem);
                    bridged = true;
                    break;
                }
            }
            if (!bridged) {
                boolean bl = bridged = bridged && this.bridgeFromMappingFile(dataItem);
            }
            if (bridged) continue;
            SchemaItem schemaItem = new SchemaItem();
            schemaItem.addItem(dataItem, numScp);
            this.schemaItemList.add(schemaItem);
            this.itemFragmentItemMap.put(dataItem, schemaItem);
        }
    }

    private boolean bridgeFromMappingFile(Item dataItem) {
        return false;
    }
}

