/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.DoSquashing;
import cs.arizona.tau.xml.IDoSquashing;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.ValidatorProperties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSException;

public class DoSVSquashing
implements IDoSquashing {
    private NodeList snapshotElementList;
    private String mOutputFileName = "squashed.xml";
    ConventionalParser cp;
    ValidatorProperties vp;

    public DoSVSquashing() {
        this.init();
    }

    private void init() {
        this.cp = ConventionalParser.getInstance();
        this.vp = ValidatorProperties.getInstance();
    }

    @Override
    public void setOutputFileName(String tempDataDir, String name) {
        this.mOutputFileName = name;
    }

    @Override
    public Document squash(String tempDataDir, String configFile) {
        String endDate = "";
        Document temporalDoc = null;
        Document bundleDoc = null;
        Document configDoc = null;
        String configDir = configFile.substring(0, configFile.lastIndexOf("/")) + "/";
        configDoc = this.cp.parseDocument(configFile, null, this.vp.getProperty("ConfigSchema"));
        String temporalBundle = configDir + configDoc.getDocumentElement().getAttribute("bundle");
        String temporalBundleDir = temporalBundle.substring(0, temporalBundle.lastIndexOf("/")) + "/";
        temporalDoc = this.cp.createDocument(this.vp.getProperty("RepSchemaURL"), this.vp.getProperty("RepSchemaNameAlias") + ":sv_root", null);
        Element rootElement = temporalDoc.getDocumentElement();
        rootElement.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        rootElement.setAttribute("bundle", temporalBundle);
        Element schemaItemElement = temporalDoc.createElement("schemaItem");
        temporalDoc.getDocumentElement().appendChild(schemaItemElement);
        this.snapshotElementList = configDoc.getElementsByTagName("snapshot");
        try {
            bundleDoc = this.cp.parseDocument(temporalBundle, null, this.vp.getProperty("TBSchema"));
            NodeList schemaAnnotationNodes = bundleDoc.getElementsByTagName("schemaAnnotation");
            for (int i = 0; i < schemaAnnotationNodes.getLength(); ++i) {
                Element currElement = (Element)schemaAnnotationNodes.item(i);
                String beginDate = currElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
                if (i + 1 < schemaAnnotationNodes.getLength()) {
                    Element nextElement = (Element)schemaAnnotationNodes.item(i + 1);
                    endDate = nextElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
                } else {
                    endDate = "9999-12-31";
                }
                Element schemaConstantPeriodConfigRoot = this.getSchemaConstantPeriodConfigRoot(configDoc, beginDate, endDate);
                Element schemaVersion = temporalDoc.createElement("schemaVersion" + i);
                Element timePeriodElement = temporalDoc.createElement(this.vp.getProperty("TVSchemaNameAlias") + "timestamp_TransExtent");
                timePeriodElement.setAttribute("begin", beginDate);
                timePeriodElement.setAttribute("end", endDate);
                schemaVersion.appendChild(timePeriodElement);
                String snapshotSchema = temporalBundleDir + currElement.getAttribute("snapshotSchema");
                String temporalAnnotation = temporalBundleDir + currElement.getAttribute("temporalAnnotation");
                String physicalAnnotation = temporalBundleDir + currElement.getAttribute("physicalAnnotation");
                DoSquashing doSquashing = new DoSquashing(snapshotSchema, temporalAnnotation, i);
                Document dataVaryingTemporalDoc = doSquashing.squash(tempDataDir, configDir, schemaConstantPeriodConfigRoot);
                Element temporalRootElement = (Element)temporalDoc.importNode(dataVaryingTemporalDoc.getDocumentElement(), true);
                schemaVersion.appendChild(temporalRootElement);
                schemaItemElement.appendChild(schemaVersion);
                rootElement.setAttribute("xmlns:rep" + i, this.vp.getProperty("RepSchemaURL") + i);
            }
            return temporalDoc;
        }
        catch (DOMException de) {
            System.out.println("Error occurred while parsing Temporal Bundle Document.");
            return null;
        }
        catch (LSException le) {
            System.out.println("Unable to load Temporal Bundle Document.");
            le.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println("Some other error occurred.");
            e.printStackTrace();
            return null;
        }
    }

    private Element getSchemaConstantPeriodConfigRoot(Document doc, String strBeginDate, String strEndDate) {
        Element root = doc.createElement("config");
        try {
            TimePeriod tp = new TimePeriod(strBeginDate, strEndDate);
            for (int i = 0; i < this.snapshotElementList.getLength(); ++i) {
                String currEndDate;
                String currBeginDate = ((Element)this.snapshotElementList.item(i)).getAttribute("beginDate");
                TimePeriod currTP = new TimePeriod(currBeginDate, currEndDate = ((Element)this.snapshotElementList.item(i)).getAttribute("endDate"));
                int relation = currTP.getRelationship(tp);
                if (3 != relation && 8 != relation && 4 != relation && 6 != relation && 8 != relation) continue;
                root.appendChild(this.snapshotElementList.item(i).cloneNode(true));
            }
            return root;
        }
        catch (Exception e) {
            System.out.println("Some other error occurred.");
            return null;
        }
    }
}

