/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.DoSchemaMapping;
import cs.arizona.tau.xml.IDoSchemaMapping;
import cs.arizona.tau.xml.ItemIdentifierCorr;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.ValidatorProperties;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DoSVSchemaMapping
implements IDoSchemaMapping {
    private Document repSchema;
    private ConventionalParser cp;
    private ValidatorProperties vp;
    private String xmlSchemaName;
    private String tvSchemaName;
    private ArrayList itemIdCorrList;
    private ArrayList scpTimeSpanList;

    public DoSVSchemaMapping() {
        this.init();
    }

    private void init() {
        this.cp = ConventionalParser.getInstance();
        this.vp = ValidatorProperties.getInstance();
        this.xmlSchemaName = this.vp.getProperty("XMLSchemaNameAlias");
        this.tvSchemaName = this.vp.getProperty("TVSchemaNameAlias");
        this.itemIdCorrList = new ArrayList();
        this.scpTimeSpanList = new ArrayList();
    }

    public Document createRepresentationalSchema(String temporalBundle) {
        String beginDate = "";
        String endDate = "";
        String temporalBundleDir = temporalBundle.substring(0, temporalBundle.lastIndexOf("/")) + "/";
        Element schemaElement = this.createSchemaElement();
        Document bundleDoc = this.cp.parseDocument(temporalBundle, null, this.vp.getProperty("TBSchema"));
        NodeList schemaAnnotationNodes = bundleDoc.getElementsByTagName("schemaAnnotation");
        for (int i = 0; i < schemaAnnotationNodes.getLength(); ++i) {
            schemaElement.setAttribute("xmlns:rep" + i, this.vp.getProperty("RepSchemaURL") + i);
            Element importElement = this.repSchema.createElement(this.xmlSchemaName + "import");
            importElement.setAttribute("namespace", this.vp.getProperty("RepSchemaURL") + i);
            importElement.setAttribute("schemaLocation", temporalBundleDir + "rep" + i + ".xsd");
            schemaElement.appendChild(importElement);
        }
        Element schemaItemSequencecElement = this.addSchemaVaryingRoot();
        for (int i = 0; i < schemaAnnotationNodes.getLength(); ++i) {
            Element currElement = (Element)schemaAnnotationNodes.item(i);
            beginDate = currElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
            if (i + 1 < schemaAnnotationNodes.getLength()) {
                Element nextElement = (Element)schemaAnnotationNodes.item(i + 1);
                endDate = nextElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
            } else {
                endDate = "9999-12-31";
            }
            TimePeriod tp = new TimePeriod(beginDate, endDate);
            this.scpTimeSpanList.add(tp);
            String snapshotSchema = temporalBundleDir + currElement.getAttribute("snapshotSchema");
            String temporalAnnotation = temporalBundleDir + currElement.getAttribute("temporalAnnotation");
            String physicalAnnotation = temporalBundleDir + currElement.getAttribute("physicalAnnotation");
            DoSchemaMapping doDataSchemaMapping = new DoSchemaMapping();
            Document repSchemaDoc = doDataSchemaMapping.createRepresentationalSchema(snapshotSchema, temporalAnnotation, physicalAnnotation, i);
            this.cp.writeDocument(repSchemaDoc, temporalBundleDir + "/rep" + i + ".xsd");
            schemaItemSequencecElement.appendChild(this.createSchemaVersionElement(i));
            NodeList nlItemIdCorrList = currElement.getElementsByTagName("itemIdentifierCorrespondence");
            Hashtable<String, ItemIdentifierCorr> itemIdMap = new Hashtable<String, ItemIdentifierCorr>();
            for (int j = 0; j < nlItemIdCorrList.getLength(); ++j) {
                Element currCorr = (Element)nlItemIdCorrList.item(j);
                ItemIdentifierCorr itemIdCorr = new ItemIdentifierCorr(currCorr.getAttribute("oldRef"), currCorr.getAttribute("newRef"), currCorr.getAttribute("mappingType"));
                itemIdMap.put(currCorr.getAttribute("newRef"), itemIdCorr);
            }
            this.itemIdCorrList.add(itemIdMap);
        }
        return this.repSchema;
    }

    public ArrayList getItemIdentifierCorrList() {
        return this.itemIdCorrList;
    }

    public ArrayList getScpTimeSpanList() {
        return this.scpTimeSpanList;
    }

    private Element addSchemaVaryingRoot() {
        Element root = this.repSchema.getDocumentElement();
        Element svRoot = this.repSchema.createElement(this.xmlSchemaName + "element");
        svRoot.setAttribute("name", "sv_root");
        root.appendChild(svRoot);
        Element complexTypeElement = this.repSchema.createElement(this.xmlSchemaName + "complexType");
        svRoot.appendChild(complexTypeElement);
        Element sequenceElement = this.repSchema.createElement(this.xmlSchemaName + "sequence");
        complexTypeElement.appendChild(sequenceElement);
        Element schemaItemElement = this.repSchema.createElement(this.xmlSchemaName + "element");
        schemaItemElement.setAttribute("name", "schemaItem");
        sequenceElement.appendChild(schemaItemElement);
        Element complexTypeElement1 = this.repSchema.createElement(this.xmlSchemaName + "complexType");
        schemaItemElement.appendChild(complexTypeElement1);
        Element sequenceElement1 = this.repSchema.createElement(this.xmlSchemaName + "sequence");
        complexTypeElement1.appendChild(sequenceElement1);
        Element bundleAttribute = this.repSchema.createElement(this.xmlSchemaName + "attribute");
        bundleAttribute.setAttribute("name", "bundle");
        bundleAttribute.setAttribute("type", this.xmlSchemaName + "string");
        complexTypeElement.appendChild(bundleAttribute);
        return sequenceElement1;
    }

    private Element createSchemaElement() {
        this.repSchema = this.cp.createDocument(this.vp.getProperty("XMLSchemaURL"), this.xmlSchemaName + "schema", null);
        Element schemaElement = this.repSchema.getDocumentElement();
        schemaElement.setAttribute("xmlns", this.vp.getProperty("RepSchemaURL"));
        schemaElement.setAttribute("xmlns:tv", this.vp.getProperty("TVSchemaURL"));
        schemaElement.setAttribute("xmlns:xsi", this.vp.getProperty("XMLSchemaInstance"));
        schemaElement.setAttribute("elementFormDefault", "unqualified");
        schemaElement.setAttribute("targetNamespace", this.vp.getProperty("RepSchemaURL"));
        Element tvImportElement = this.repSchema.createElement(this.xmlSchemaName + "import");
        tvImportElement.setAttribute("namespace", this.vp.getProperty("TVSchemaURL"));
        tvImportElement.setAttribute("schemaLocation", this.vp.getProperty("TVSchema"));
        schemaElement.appendChild(tvImportElement);
        return schemaElement;
    }

    private Element createSchemaVersionElement(int schemaIndex) {
        Element schemaVersionElement = this.repSchema.createElement(this.xmlSchemaName + "element");
        schemaVersionElement.setAttribute("name", "schemaVersion" + schemaIndex);
        schemaVersionElement.setAttribute("minOccurs", "1");
        schemaVersionElement.setAttribute("maxOccurs", "1");
        Element complexTypeElement = this.repSchema.createElement(this.xmlSchemaName + "complexType");
        Element sequenceElement = this.repSchema.createElement(this.xmlSchemaName + "sequence");
        Element tvElement = this.repSchema.createElement(this.xmlSchemaName + "element");
        tvElement.setAttribute("ref", this.tvSchemaName + "timestamp_TransExtent");
        tvElement.setAttribute("minOccurs", "1");
        tvElement.setAttribute("maxOccurs", "1");
        Element temporalRootElement = this.repSchema.createElement(this.xmlSchemaName + "element");
        temporalRootElement.setAttribute("ref", "rep" + schemaIndex + ":temporalRoot");
        temporalRootElement.setAttribute("minOccurs", "1");
        temporalRootElement.setAttribute("maxOccurs", "1");
        schemaVersionElement.appendChild(complexTypeElement);
        complexTypeElement.appendChild(sequenceElement);
        sequenceElement.appendChild(tvElement);
        sequenceElement.appendChild(temporalRootElement);
        return schemaVersionElement;
    }
}

