/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.DoSVSchemaMapping;
import cs.arizona.tau.xml.DoSVSquashing;
import cs.arizona.tau.xml.DoSVTemporalValidation;
import cs.arizona.tau.xml.DoSVUnSquashing;
import cs.arizona.tau.xml.DoSchemaMapping;
import cs.arizona.tau.xml.DoSquashing;
import cs.arizona.tau.xml.DoTemporalValidation;
import cs.arizona.tau.xml.DoUnSquashing;
import cs.arizona.tau.xml.IDoSchemaMapping;
import cs.arizona.tau.xml.IDoSquashing;
import cs.arizona.tau.xml.IDoTemporalValidation;
import cs.arizona.tau.xml.IDoUnSquashing;
import cs.arizona.tau.xml.IRepresentationFactory;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.ValidatorProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DecomposedRepresentationFactory
implements IRepresentationFactory {
    @Override
    public IDoSchemaMapping createSchemaMappingObj(String dataFile, boolean schemaVersioningFlag) {
        if (schemaVersioningFlag) {
            return new DoSVSchemaMapping();
        }
        return new DoSchemaMapping();
    }

    @Override
    public IDoSquashing createSquashingObj(String tempDataDir, String tempDataFile, boolean schemaVersioningFlag) {
        if (schemaVersioningFlag) {
            return new DoSVSquashing();
        }
        String strTemporalSchema = tempDataDir + "/" + this.getTemporalSchema(tempDataDir + "/" + tempDataFile);
        if (null == strTemporalSchema || "".equals(strTemporalSchema)) {
            System.out.println("Passed temporal data file does not specify the temporal schema. Please provide correct file.");
        }
        return new DoSquashing(strTemporalSchema, -1);
    }

    @Override
    public IDoUnSquashing createUnSquashingObj(String tempDataDir, String dataFile, boolean schemaVersioningFlag) {
        if (schemaVersioningFlag) {
            return new DoSVUnSquashing();
        }
        String strTemporalBundle = tempDataDir + "/" + this.getTemporalSchema(tempDataDir + "/" + dataFile);
        if (null == strTemporalBundle || "".equals(strTemporalBundle)) {
            System.out.println("Passed config file does not specify the temporal bundle. Please provide correct configuration file.");
        }
        return new DoUnSquashing(strTemporalBundle, -1);
    }

    @Override
    public IDoTemporalValidation createTemporalValidationObj(String temp_data_dir, String dataFile, boolean schemaVersioningFlag) {
        if (schemaVersioningFlag) {
            return new DoSVTemporalValidation();
        }
        String strTemporalBundle = temp_data_dir + "/" + this.getTemporalSchema(temp_data_dir + "/" + dataFile);
        if (null == strTemporalBundle || "".equals(strTemporalBundle)) {
            System.out.println("Passed config file does not specify the temporal bundle. Please provide correct configuration file.");
        }
        return new DoTemporalValidation(strTemporalBundle, -1);
    }

    private String getTemporalSchema(String tempDataFile) {
        ValidatorProperties vp = ValidatorProperties.getInstance();
        ConventionalParser cp = ConventionalParser.getInstance();
        Document temporalDoc = null;
        temporalDoc = cp.parseDocument(tempDataFile, null, vp.getProperty("TDSchema"));
        Element temporalRoot = temporalDoc.getDocumentElement();
        Node tempSchemaSet = temporalRoot.getElementsByTagName("temporalSchemaSet").item(0);
        NodeList schemas = tempSchemaSet.getChildNodes();
        for (int i = 0; i < schemas.getLength(); ++i) {
            if (!Common.isElement(schemas.item(i))) continue;
            Element schema = (Element)schemas.item(i);
            return schema.getAttribute("schemaLocation");
        }
        return null;
    }
}

