/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Common {
    public static boolean validateAnnotations(LogicalAnnotationValidator lav, PhysicalAnnotationValidator pav) {
        if (!lav.validateLogicalAnnotation() || !pav.validatePhysicalAnnotation()) {
            TauLogger.logger.fatal((Object)"Temporal or Physical Annotations did not validate.");
            System.exit(3);
        }
        return true;
    }

    public static void checkFileExists(String path) {
        File f = new File(path);
        if (!f.exists() || !f.canRead()) {
            TauLogger.logger.fatal((Object)("Cannot access file \"" + path + "\""));
            System.exit(4);
        }
    }

    public static Element getNextElement(Node a) {
        NodeList nl = a.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!Common.isElement(nl.item(i))) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static boolean isElement(Node a) {
        return a.getNodeType() == 1;
    }

    public static boolean isNamed(Node a, String s) {
        return a.getLocalName().equals(s);
    }

    public static void deleteFile(String path) {
        File f = new File(path);
        if (!f.exists()) {
            TauLogger.logger.fatal((Object)("Delete: no such file or directory: " + path));
            return;
        }
        if (!f.canWrite()) {
            TauLogger.logger.fatal((Object)("Delete: write protected: " + path));
            return;
        }
        boolean success = f.delete();
        if (!success) {
            TauLogger.logger.fatal((Object)"Delete: deletion failed");
            return;
        }
    }

    public static void filterEditInput(String path, String newPath) {
        String command = "";
        int count = Common.getNumberOfLines(path);
        command = "cp " + path + " " + newPath + "\n";
        command = command + "perl -pi -e '$. > 1 && $. < " + count + " &&  s/\\n/<tXnl\\/>/g' " + newPath;
        Common.outputStringToFile(command, "tmpScript.sh");
        Common.runCommand("sh tmpScript.sh");
        Common.deleteFile("tmpScript.sh");
    }

    public static void filterEditOutput(String path) {
        String command = "";
        command = "perl -pi -e 's/\n//g' " + path + "\n";
        command = command + "perl -pi -e '$. == 1 && s/<\\?xml.*?>/<\\?xml version=\\\"1.0\\\"\\?>\\n/g' " + path + "\n";
        command = command + "perl -pi -e '$. > 1 &&  s/<tXnl\\/>/\\n/g' " + path;
        Common.outputStringToFile(command, "tmpScript.sh");
        Common.runCommand("sh tmpScript.sh");
        Common.deleteFile("tmpScript.sh");
    }

    public static int getNumberOfLines(String path) {
        int count = 0;
        try {
            FileReader fr = new FileReader(path);
            LineNumberReader ln = new LineNumberReader(fr);
            while (ln.readLine() != null) {
                ++count;
            }
        }
        catch (IOException e) {
            System.out.println("Exception reading number of lines: ");
            e.printStackTrace();
            System.exit(-1);
        }
        return count;
    }

    public static void runPatchCommand(Element a, String path1, String path2) {
        TauLogger.logger.debug((Object)("Patching " + path2 + " from " + path1));
        Common.runCommand("cp " + path1 + " " + path2);
        String editScript = "";
        NodeList nl2 = a.getChildNodes();
        for (int j = 0; j < nl2.getLength(); ++j) {
            Node b = nl2.item(j);
            if (!Common.isElement(b)) continue;
            String commandType = b.getNodeName();
            if (commandType.equals("change")) {
                commandType = "c";
            } else if (commandType.equals("add")) {
                commandType = "a";
            } else if (commandType.equals("delete")) {
                commandType = "d";
            }
            String changeText = ((Element)b).getTextContent() + "\n";
            changeText = changeText.replaceAll("&&#10;", "\n");
            editScript = editScript + ((Element)b).getAttribute("lines");
            editScript = editScript + commandType + "\n";
            editScript = editScript + changeText;
            editScript = editScript + ".\n";
        }
        Common.outputStringToFile(editScript, "tmpPatch");
        String command = "patch " + path2 + " < tmpPatch";
        Common.outputStringToFile(command, "tmpScript.sh");
        Common.runCommand("sh tmpScript.sh");
        Common.deleteFile("tmpScript.sh");
        Common.deleteFile("tmpPatch");
    }

    public static void runDiffCommand(String path1, String path2, Document temporalDoc, Element root2, String beginDate, String endDate) {
        String s = null;
        String lines = "";
        String action = "";
        String changeText = "";
        Pattern pEnd = Pattern.compile("^.$");
        Pattern pBegin = Pattern.compile("(^[0-9]+,?[0-9]*)([cad])");
        TimePeriod transactionPeriod = new TimePeriod(beginDate, endDate);
        Element time = transactionPeriod.toXML(1, 1, temporalDoc);
        try {
            String command = "diff -e " + path1 + " " + path2;
            TauLogger.logger.debug((Object)("Executing command " + command));
            Process pr = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            Node newEdit = null;
            Boolean first = false;
            while ((s = stdInput.readLine()) != null) {
                Matcher mBegin = pBegin.matcher(s);
                Matcher mEnd = pEnd.matcher(s);
                if (mBegin.matches()) {
                    lines = mBegin.group(1);
                    action = mBegin.group(2);
                    if (action.equals("c")) {
                        newEdit = temporalDoc.createElement("change");
                    } else if (action.equals("a")) {
                        newEdit = temporalDoc.createElement("add");
                    } else if (action.equals("d")) {
                        newEdit = temporalDoc.createElement("delete");
                    } else {
                        TauLogger.logger.fatal((Object)"Unknown diff output.");
                        System.exit(5);
                    }
                    newEdit.setAttribute("lines", lines);
                    first = true;
                    changeText = "";
                    continue;
                }
                if (mEnd.matches()) {
                    newEdit.setTextContent(changeText);
                    time.appendChild(newEdit);
                    continue;
                }
                String newSt = s;
                if (first.booleanValue()) {
                    first = false;
                } else {
                    changeText = changeText + "&&#10;";
                }
                changeText = changeText + newSt;
            }
            while ((s = stdError.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (IOException e) {
            System.out.println("Exception happened - here's what I know: ");
            e.printStackTrace();
            System.exit(-1);
        }
        root2.appendChild(time);
    }

    public static void runCommand(String command) {
        try {
            String s;
            Process pr = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                TauLogger.logger.info((Object)s);
            }
            while ((s = stdError.readLine()) != null) {
                TauLogger.logger.info((Object)s);
            }
        }
        catch (IOException e) {
            System.out.println("Exception running system command: ");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void outputStringToFile(String str, String path) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            out.write(str);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Exception outputting file: ");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static String getOriginalRootName(Document d) {
        Element tr = d.getDocumentElement();
        String result = tr.getAttribute("originalRoot");
        return result;
    }

    public static String formatDate2(Date a) {
        String result = String.format("%04d-%02d-%02d", a.getYear() + 1900, a.getMonth() + 1, a.getDate());
        return result;
    }

    public static String formatDate(Date a) {
        String result = String.format("%04d%02d%02d", a.getYear() + 1900, a.getMonth() + 1, a.getDate());
        return result;
    }

    public static String getDirectory(String path) {
        try {
            File myFile = new File(path);
            String ans = myFile.getCanonicalPath();
            return ans.substring(0, ans.lastIndexOf("/")) + "/";
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
            return null;
        }
    }

    public static String getFileName(String path) {
        File myFile = new File(path);
        return myFile.getName();
    }

    public static Element getFirstElementNamed(Document d, String name) {
        Element root = (Element)d.getFirstChild();
        if (Common.isNamed(root, name)) {
            return root;
        }
        NodeList nl1 = root.getElementsByTagName(name);
        return (Element)nl1.item(0);
    }

    public static String getLastElementNameFromString(String n) {
        return n.substring(n.lastIndexOf("/") + 1, n.length());
    }

    public static Document createDefaultAnnotationDoc(ConventionalParser cp, String topLevelElementName) {
        Document defaultAnnotationDoc = cp.createDocument(null, "annotationSet", null);
        Element rootElement = defaultAnnotationDoc.getDocumentElement();
        Element physicalElement = defaultAnnotationDoc.createElement("physical");
        Element stampElement = defaultAnnotationDoc.createElement("stamp");
        Element stampKindElement = defaultAnnotationDoc.createElement("stampKind");
        stampKindElement.setAttribute("timeDimension", "transactionTime");
        stampKindElement.setAttribute("stampBounds", "extent");
        stampElement.appendChild(stampKindElement);
        stampElement.setAttribute("target", topLevelElementName);
        stampElement.setAttribute("dataInclusion", "expandedVersion");
        physicalElement.appendChild(stampElement);
        rootElement.appendChild(physicalElement);
        return defaultAnnotationDoc;
    }

    public static String getTopLevelSchemaElementName(TargetIdentifier ti) {
        String name = ti.getTopLevelElement().getAttribute("name");
        return name;
    }

    public static void printElaspedTime(String s, long t1, long t2) {
        double e = (float)(t2 - t1) / 1.0E9f;
    }
}

