/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.xml;

import cs.arizona.tau.time.ITemporalElement;
import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TemporalElement;
import cs.arizona.tau.xml.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseItem {
    public static int CONTENT_VARYING = 1;
    public static int CONTENT_CONSTANT = 2;
    public static int EXISTENCE_CONSTANT = 1;
    public static int EXISTENCE_VARYING_WITHOUT_GAPS = 2;
    public static int EXISTENCE_VARYING_WITH_GAPS = 3;
    public static int KIND_STATE = 1;
    public static int KIND_EVENT = 2;
    protected ArrayList versions = new ArrayList();
    protected ITemporalElement temporalElement = new TemporalElement();
    protected String target = null;
    protected String itemID = null;
    protected int timeDimension;

    public BaseItem() {
    }

    public BaseItem(BaseItem baseItem) {
        this.target = baseItem.target;
        this.timeDimension = baseItem.timeDimension;
        Iterator versionIterator = baseItem.getVersionIterator();
        while (versionIterator.hasNext()) {
            this.versions.add(((Element)versionIterator.next()).cloneNode(true));
        }
        this.temporalElement = baseItem.temporalElement.cloneElement();
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Iterator getVersionIterator() {
        return this.versions.iterator();
    }

    public ITemporalElement getTemporalElement() {
        return this.temporalElement;
    }

    public void addVersion(Element e, ITime time1) {
        this.versions.add(e);
        this.temporalElement.add(time1);
    }

    public Element getVersion(int index) {
        return (Element)this.versions.get(index);
    }

    public void addVersionAll(Collection c1, ITemporalElement te) {
        this.versions.addAll(c1);
        this.temporalElement.addAll(te.getAll());
    }

    public void clearVersions() {
        this.versions.clear();
        this.temporalElement.clear();
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public Element createRefElement(Document doc) {
        Element itemRefElement = doc.createElement(this.target.replace('/', '_'));
        itemRefElement.setAttribute("itemRef", this.itemID);
        return itemRefElement;
    }

    public boolean removeVersion(Element ev) {
        Iterator versionIterator = this.versions.iterator();
        Iterator teIterator = this.temporalElement.iterator();
        while (versionIterator.hasNext()) {
            Element currVersion = (Element)versionIterator.next();
            ITime currTime1 = (ITime)teIterator.next();
            if (currVersion != ev) continue;
            this.versions.remove(ev);
            this.temporalElement.remove(currTime1);
            return true;
        }
        return false;
    }

    public int getTimeDimension() {
        return this.timeDimension;
    }

    public void setTimeDimension(int numDimensions) {
        this.timeDimension = numDimensions;
    }

    public int getVersionCount() {
        return this.versions.size();
    }

    public void merge(Item item) {
        Iterator versionIterator = item.getVersionIterator();
        Iterator teIterator = item.getTemporalElement().iterator();
        while (versionIterator.hasNext()) {
            this.versions.add(versionIterator.next());
            this.temporalElement.add((ITime)teIterator.next());
        }
    }

    public Collection getVersions() {
        return this.versions;
    }

    public Element getVersionElement(ITime time1) {
        Iterator teItr = this.temporalElement.iterator();
        Iterator versionItr = this.versions.iterator();
        while (teItr.hasNext()) {
            Element e = (Element)versionItr.next();
            ITime currTime = (ITime)teItr.next();
            if (this.getTimeDimension() != 1 || currTime.getRelationship(time1) != 3 && currTime.getRelationship(time1) != 5 && currTime.getRelationship(time1) != 7 && currTime.getRelationship(time1) != 9) continue;
            return e;
        }
        return null;
    }

    public Element getSnapshot(Date date) {
        Iterator versionIterator = this.versions.iterator();
        Iterator teIterator = this.temporalElement.iterator();
        while (versionIterator.hasNext() && teIterator.hasNext()) {
            ITimePeriod tp = (ITimePeriod)teIterator.next();
            Element version = (Element)versionIterator.next();
            if (!tp.getBeginDate().equals(date) && (!tp.getBeginDate().before(date) || !tp.getEndDate().after(date))) continue;
            return version;
        }
        return null;
    }
}

