/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.time;

import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.util.ValidatorProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimePeriod
implements ITimePeriod {
    private Date beginDate;
    private Date endDate;

    public TimePeriod() {
    }

    public String formatDate(Date a) {
        String result = String.format("%04d%02d%02d", a.getYear() + 1900, a.getMonth() + 1, a.getDate());
        return result;
    }

    public String toString() {
        return this.formatDate(this.beginDate) + " to " + this.formatDate(this.endDate);
    }

    public TimePeriod(Date beginDate, Date endDate) {
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    public TimePeriod(String strBeginDate, String strEndDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this.beginDate = sdf.parse(strBeginDate);
            this.endDate = sdf.parse(strEndDate);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public TimePeriod(ITimePeriod tp) {
        this.beginDate = tp.getBeginDate();
        this.endDate = tp.getEndDate();
    }

    public TimePeriod(Element xmlPeriodElement) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this.beginDate = sdf.parse(xmlPeriodElement.getAttribute("begin"));
            this.endDate = sdf.parse(xmlPeriodElement.getAttribute("end"));
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    @Override
    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public Date getBeginDate() {
        return this.beginDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public Element toXML(int timeDimension, int timeRepresentation, Document doc) {
        ValidatorProperties vp = ValidatorProperties.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Element xmlElement = timeDimension == 2 ? (timeRepresentation == 1 ? doc.createElement(vp.getProperty("TVSchemaNameAlias") + "timestamp_ValidExtent") : doc.createElement(vp.getProperty("TVSchemaNameAlias") + "timestamp_ValidStep")) : (timeRepresentation == 1 ? doc.createElement(vp.getProperty("TVSchemaNameAlias") + "timestamp_TransExtent") : doc.createElement(vp.getProperty("TVSchemaNameAlias") + "timestamp_TransStep"));
        xmlElement.setAttribute("begin", sdf.format(this.beginDate));
        xmlElement.setAttribute("end", sdf.format(this.endDate));
        return xmlElement;
    }

    @Override
    public int getRelationship(ITime tp1) {
        ITimePeriod tp = (ITimePeriod)tp1;
        Date b1 = this.beginDate;
        Date b2 = tp.getBeginDate();
        Date e1 = this.endDate;
        Date e2 = tp.getEndDate();
        if (b1.equals(b2) && e1.equals(e2)) {
            return 3;
        }
        if (b1.before(b2) && e1.before(b2)) {
            return -1;
        }
        if (b2.before(b1) && e2.before(b1)) {
            return -2;
        }
        if (b1.before(b2) && e1.equals(b2)) {
            return -3;
        }
        if (b2.before(b1) && e2.equals(b1)) {
            return -4;
        }
        if (b1.before(b2) && e1.before(e2) && e1.after(b2)) {
            return 1;
        }
        if (b2.before(b1) && e2.before(e1) && e2.after(b1)) {
            return 2;
        }
        if (b1.equals(b2) && e1.before(e2)) {
            return 4;
        }
        if (b2.equals(b1) && e2.before(e1)) {
            return 5;
        }
        if (b2.before(b1) && e1.equals(e2)) {
            return 6;
        }
        if (b1.before(b2) && e1.equals(e2)) {
            return 7;
        }
        if (b2.before(b1) && b1.before(e2) && e1.before(e2)) {
            return 8;
        }
        if (b1.before(b2) && b2.before(e1) && e2.before(e1)) {
            return 9;
        }
        return 0;
    }

    @Override
    public Iterator split(ITimePeriod tp) {
        ArrayList<TimePeriod> temporalElement = new ArrayList<TimePeriod>();
        Date s1 = this.beginDate;
        Date s2 = tp.getBeginDate();
        Date e1 = this.endDate;
        Date e2 = tp.getEndDate();
        switch (this.getRelationship(tp)) {
            case 1: {
                TimePeriod tp1 = new TimePeriod(s1, s2);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(s2, e1);
                temporalElement.add(tp2);
                TimePeriod tp3 = new TimePeriod(e1, e2);
                temporalElement.add(tp3);
                break;
            }
            case 2: {
                TimePeriod tp1 = new TimePeriod(s2, s1);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(s1, e2);
                temporalElement.add(tp2);
                TimePeriod tp3 = new TimePeriod(e2, e1);
                temporalElement.add(tp3);
                break;
            }
            case 3: {
                TimePeriod tp1 = new TimePeriod(s1, e1);
                temporalElement.add(tp1);
                break;
            }
            case 4: {
                TimePeriod tp1 = new TimePeriod(s1, e1);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(e1, e2);
                temporalElement.add(tp2);
                break;
            }
            case 5: {
                TimePeriod tp1 = new TimePeriod(s2, e2);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(e2, e1);
                temporalElement.add(tp2);
                break;
            }
            case 6: {
                TimePeriod tp1 = new TimePeriod(s2, s1);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(s1, e1);
                temporalElement.add(tp2);
                break;
            }
            case 7: {
                TimePeriod tp1 = new TimePeriod(s1, s2);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(s2, e2);
                temporalElement.add(tp2);
                break;
            }
            case 8: {
                TimePeriod tp1 = new TimePeriod(s2, s1);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(s1, e1);
                temporalElement.add(tp2);
                TimePeriod tp3 = new TimePeriod(e1, e2);
                temporalElement.add(tp3);
                break;
            }
            case 9: {
                TimePeriod tp1 = new TimePeriod(s1, s2);
                temporalElement.add(tp1);
                TimePeriod tp2 = new TimePeriod(s2, e2);
                temporalElement.add(tp2);
                TimePeriod tp3 = new TimePeriod(e2, e1);
                temporalElement.add(tp3);
            }
        }
        return temporalElement.iterator();
    }

    @Override
    public String getInterfaceName() {
        return "ITimePeriod";
    }

    @Override
    public ITime cloneTime() {
        TimePeriod tp = new TimePeriod();
        tp.setBeginDate((Date)this.beginDate.clone());
        tp.setEndDate((Date)this.endDate.clone());
        return tp;
    }
}

