/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.time;

import cs.arizona.tau.time.ITemporalRegion;
import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;
import java.util.Iterator;

public class TemporalRegion
implements ITemporalRegion {
    private int numDimensions;
    private ITimePeriod validPeriod;
    private ITimePeriod transactionPeriod;

    public TemporalRegion() {
    }

    public TemporalRegion(int numDimensions, ITimePeriod validPeriod, ITimePeriod transactionPeriod) {
        this.numDimensions = numDimensions;
        this.validPeriod = validPeriod;
        this.transactionPeriod = transactionPeriod;
    }

    public TemporalRegion(ITemporalRegion tr) {
        this.numDimensions = tr.getNumDimensions();
        this.validPeriod = tr.getValidPeriod();
        this.transactionPeriod = tr.getTransactionPeriod();
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    @Override
    public void setValidPeriod(ITimePeriod validPeriod) {
        this.validPeriod = validPeriod;
    }

    @Override
    public void setTransactionPeriod(ITimePeriod transactionPeriod) {
        this.transactionPeriod = transactionPeriod;
    }

    @Override
    public ITimePeriod getValidPeriod() {
        return this.validPeriod;
    }

    @Override
    public ITimePeriod getTransactionPeriod() {
        return this.transactionPeriod;
    }

    @Override
    public boolean overlap(ITemporalRegion tr) {
        return this.validPeriod.getRelationship(tr.getValidPeriod()) > 0 || this.transactionPeriod.getRelationship(tr.getTransactionPeriod()) > 0;
    }

    @Override
    public boolean isEqual(ITemporalRegion tr) {
        return this.validPeriod.getRelationship(tr.getValidPeriod()) == 3 && this.transactionPeriod.getRelationship(tr.getTransactionPeriod()) == 3;
    }

    @Override
    public Iterator split(ITemporalRegion tr) {
        return null;
    }

    @Override
    public String getInterfaceName() {
        return "ITemporalRegion";
    }

    @Override
    public ITime cloneTime() {
        TemporalRegion tr = new TemporalRegion(this.numDimensions, (ITimePeriod)this.validPeriod.cloneTime(), (ITimePeriod)this.transactionPeriod.cloneTime());
        return tr;
    }

    @Override
    public int getRelationship(ITime time1) {
        return 0;
    }
}

