/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.time;

import cs.arizona.tau.time.ISCPList;
import cs.arizona.tau.time.TimePeriod;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class SCPList<E>
implements ISCPList<E>,
Iterable {
    private ArrayList<PPair> scplist = new ArrayList();

    @Override
    public void add(TimePeriod tp, E ele) {
        this.scplist.add(new PPair(tp, ele));
    }

    @Override
    public E get(Date b) {
        for (PPair pair : this.scplist) {
            Date before = pair.tp.getBeginDate();
            Date end = pair.tp.getEndDate();
            if (before.compareTo(b) > 0 || end.compareTo(b) <= 0) continue;
            return pair.ele;
        }
        return null;
    }

    @Override
    public E get(TimePeriod tp2) {
        for (PPair pair : this.scplist) {
            int relationship = pair.tp.getRelationship(tp2);
            if (relationship != 3 && relationship != 8 && relationship != 4) continue;
            return pair.ele;
        }
        return null;
    }

    @Override
    public E remove(Date b) {
        int i = 0;
        for (PPair pair : this.scplist) {
            Date before = pair.tp.getBeginDate();
            Date end = pair.tp.getEndDate();
            if (before.compareTo(b) <= 0 && end.compareTo(b) >= 0) {
                return this.scplist.remove((int)i).ele;
            }
            ++i;
        }
        return null;
    }

    @Override
    public E remove(TimePeriod tp2) {
        int i = 0;
        for (PPair pair : this.scplist) {
            if (pair.tp.getRelationship(tp2) == 3) {
                return this.scplist.remove((int)i).ele;
            }
            ++i;
        }
        return null;
    }

    public Iterator<E> iterator() {
        return new SCPIterator();
    }

    private class SCPIterator<E>
    implements Iterator<E> {
        ArrayList<PPair> list;
        int size;
        int i;

        public SCPIterator() {
            this.list = SCPList.this.scplist;
            this.i = 0;
            this.size = this.list.size();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public E next() {
            return this.list.get((int)this.i).ele;
        }

        @Override
        public void remove() {
        }
    }

    private class PPair {
        TimePeriod tp;
        E ele;

        PPair(TimePeriod tp, E ele) {
            this.tp = tp;
            this.ele = ele;
        }
    }
}

