/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.docs;

import cs.arizona.tau.docs.AnnotationDocument;
import cs.arizona.tau.docs.ConventionalSchema;
import cs.arizona.tau.time.Period;
import cs.arizona.tau.time.TemporalMap;
import cs.arizona.tau.xml.Common;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSException;

public class TemporalSchemaOld {
    private Document temporalSchemaDoc;
    private Element temporalSchema;
    private TemporalMap<ConventionalSchema> conventionalSchemas;
    private TemporalMap<AnnotationDocument> annotationDocuments;
    private String temporalSchemaDir;

    public TemporalSchemaOld(String tempSchema) {
        ValidatorProperties vp = ValidatorProperties.getInstance();
        ConventionalParser cp = ConventionalParser.getInstance();
        this.temporalSchemaDir = tempSchema.substring(0, tempSchema.lastIndexOf("/")) + "/";
        this.temporalSchemaDoc = cp.parseDocument(tempSchema, null, vp.getProperty("TSSchema"), false);
        if (this.temporalSchemaDoc.getDocumentElement().getLocalName().equals("schema")) {
            this.temporalSchemaDoc = cp.createDocument(null, "tempralSchema", null);
            this.temporalSchema = this.temporalSchemaDoc.getDocumentElement();
            this.buildTemporalSchema(tempSchema);
        } else {
            this.temporalSchema = this.temporalSchemaDoc.getDocumentElement();
        }
        this.conventionalSchemas = new TemporalMap();
        this.annotationDocuments = new TemporalMap();
        this.parseTemporalSchema(cp);
    }

    public TemporalSchemaOld(Document tempSchemaDoc) {
        ConventionalParser cp = ConventionalParser.getInstance();
        String tempSchema = tempSchemaDoc.getDocumentURI();
        this.temporalSchemaDir = tempSchema.substring(0, tempSchema.lastIndexOf("/")) + "/";
        if (tempSchemaDoc.getDocumentElement().getLocalName().equals("schema")) {
            this.temporalSchemaDoc = cp.createDocument(null, "temporalSchema", null);
            this.temporalSchema = this.temporalSchemaDoc.getDocumentElement();
            this.buildTemporalSchema(tempSchemaDoc.getDocumentURI());
        } else {
            this.temporalSchemaDoc = tempSchemaDoc;
            this.temporalSchema = this.temporalSchemaDoc.getDocumentElement();
        }
        this.conventionalSchemas = new TemporalMap();
        this.annotationDocuments = new TemporalMap();
        this.parseTemporalSchema(cp);
    }

    public TemporalMap<AnnotationDocument> getAnnotationDocuments() {
        return this.annotationDocuments;
    }

    public TemporalMap<ConventionalSchema> getConventionalSchemas() {
        return this.conventionalSchemas;
    }

    public AnnotationDocument getAnnotationDocument(Period b) {
        return this.annotationDocuments.get(b);
    }

    public ConventionalSchema getConventionalSchema(Period b) {
        return this.conventionalSchemas.get(b);
    }

    private boolean parseTemporalSchema(ConventionalParser cp) {
        long t1 = System.nanoTime();
        try {
            String end;
            Element slice;
            int j;
            NodeList slices;
            int i;
            NodeList conventionalSchemaNode = this.temporalSchemaDoc.getElementsByTagNameNS("*", "conventionalSchema");
            if (conventionalSchemaNode.getLength() > 0) {
                NodeList convSchemasList = conventionalSchemaNode.item(0).getChildNodes();
                for (i = 0; i < convSchemasList.getLength(); ++i) {
                    if (!Common.isElement(convSchemasList.item(i))) continue;
                    Element conventionalSchema = (Element)convSchemasList.item(i);
                    if (conventionalSchema.getTagName().equals("include")) {
                        this.conventionalSchemas.add(new Period("0001-01-01", "9999-12-31"), new ConventionalSchema(this.temporalSchemaDir + conventionalSchema.getAttribute("schemaLocation")));
                        continue;
                    }
                    if (!conventionalSchema.getTagName().equals("sliceSequence")) continue;
                    slices = conventionalSchema.getElementsByTagName("slice");
                    for (j = 0; j < slices.getLength(); ++j) {
                        slice = (Element)slices.item(i);
                        end = slice.getAttribute("end");
                        if (end.equals("") && i + 1 == slices.getLength()) {
                            end = "9999-12-31";
                        } else if (end.equals("")) {
                            end = ((Element)slices.item(i + 1)).getAttribute("begin");
                        }
                        this.conventionalSchemas.add(new Period(slice.getAttribute("begin"), end), new ConventionalSchema(this.temporalSchemaDir + slice.getAttribute("location")));
                    }
                }
            } else {
                TauLogger.logger.info((Object)"No \"conventionalSchema\" elements in temporal schema!");
            }
            NodeList annotationNode = this.temporalSchemaDoc.getElementsByTagNameNS("*", "annotationSet");
            if (annotationNode.getLength() > 0) {
                annotationNode = annotationNode.item(0).getChildNodes();
                for (i = 0; i < annotationNode.getLength(); ++i) {
                    if (!Common.isElement(annotationNode.item(i))) continue;
                    Element annotation = (Element)annotationNode.item(i);
                    if (annotation.getTagName().equals("include")) {
                        this.annotationDocuments.add(new Period("0001-01-01", "9999-12-31"), new AnnotationDocument(this.temporalSchemaDir + annotation.getAttribute("location")));
                        continue;
                    }
                    if (!annotation.getTagName().equals("sliceSequence")) continue;
                    slices = annotation.getElementsByTagName("slice");
                    for (j = 0; j < slices.getLength(); ++j) {
                        slice = (Element)slices.item(i);
                        end = slice.getAttribute("end");
                        if (end.equals("") && i + 1 == slices.getLength()) {
                            end = "9999-12-31";
                        } else if (end.equals("")) {
                            end = ((Element)slices.item(i + 1)).getAttribute("begin");
                        }
                        this.annotationDocuments.add(new Period(slice.getAttribute("begin"), end), new AnnotationDocument(this.temporalSchemaDir + slice.getAttribute("location")));
                    }
                }
            } else {
                TauLogger.logger.info((Object)"No \"annotationSet\" element in temporal schema");
            }
        }
        catch (DOMException de) {
            System.out.println("Error occurred while parsing Temporal Bundle Document.");
            return false;
        }
        catch (LSException le) {
            System.out.println("Unable to load Temporal Bundle Document.");
            le.printStackTrace();
            return false;
        }
        catch (Exception e) {
            System.out.println("Some other error occurred.");
            e.printStackTrace();
            return false;
        }
        long t2 = System.nanoTime();
        Common.printElaspedTime("parseBundle", t1, t2);
        return true;
    }

    private void buildTemporalSchema(String conventionalSchema) {
        Element conventionalSchemaEle = this.temporalSchemaDoc.createElement("conventionalSchema");
        Element includeEle = this.temporalSchemaDoc.createElement("include");
        includeEle.setAttribute("schemaLocation", conventionalSchema);
        conventionalSchemaEle.appendChild(includeEle);
        this.temporalSchema.appendChild(conventionalSchemaEle);
    }
}

