/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.docs;

import cs.arizona.tau.xml.Common;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSException;

public class TemporalSchema {
    private Document temporal_schema_doc_;
    private Document annotation_doc_;
    private Document conventional_schema_doc_;
    private String conventional_schema_name_;
    private String annotation_name_;
    private String temporal_schema_dir_;

    public TemporalSchema(ValidatorProperties vp, ConventionalParser cp, String temporal_schema_name) {
        this.ParseTemporalSchema(vp, cp, temporal_schema_name);
    }

    private boolean ParseTemporalSchema(ValidatorProperties vp, ConventionalParser cp, String temporal_schema_name) {
        this.temporal_schema_dir_ = temporal_schema_name.substring(0, temporal_schema_name.lastIndexOf("/")) + "/";
        long t1 = System.nanoTime();
        try {
            int i;
            this.temporal_schema_doc_ = cp.parseDocument(temporal_schema_name, null, vp.getProperty("TSSchema"));
            NodeList conventionalSchemaNode = this.temporal_schema_doc_.getElementsByTagNameNS("*", "conventionalSchema");
            if (conventionalSchemaNode.getLength() > 0) {
                NodeList conventionalSchemas = conventionalSchemaNode.item(0).getChildNodes();
                if (conventionalSchemas.getLength() > 0) {
                    for (i = 0; i < conventionalSchemas.getLength(); ++i) {
                        if (!Common.isElement(conventionalSchemas.item(i)) || !((Element)conventionalSchemas.item(i)).getTagName().equals("include")) continue;
                        this.conventional_schema_name_ = this.temporal_schema_dir_ + conventionalSchemas.item(i).getAttributes().getNamedItem("schemaLocation").getNodeValue();
                        this.conventional_schema_doc_ = cp.parseDocument(this.conventional_schema_name_, null, vp.getProperty("XMLSchema"), false);
                    }
                } else {
                    System.out.println("conventionalSchemas length = 0");
                }
            } else {
                TauLogger.logger.info((Object)"No \"conventionalSchema\" elements in temporal schema!");
            }
            NodeList annotationNode = this.temporal_schema_doc_.getElementsByTagNameNS("*", "annotationSet");
            if (annotationNode.getLength() > 0) {
                if ((annotationNode = annotationNode.item(0).getChildNodes()).getLength() > 0) {
                    for (i = 0; i < annotationNode.getLength(); ++i) {
                        if (!Common.isElement(annotationNode.item(i)) || !((Element)annotationNode.item(i)).getTagName().equals("include")) continue;
                        this.annotation_name_ = this.temporal_schema_dir_ + annotationNode.item(i).getAttributes().getNamedItem("location").getNodeValue();
                        this.annotation_doc_ = cp.parseDocument(this.annotation_name_, null, vp.getProperty("ASchema"));
                    }
                }
            } else {
                TauLogger.logger.info((Object)"No \"annotationSet\" element in temporal schema");
            }
        }
        catch (DOMException de) {
            System.out.println("Error occurred while parsing Temporal Bundle Document.");
            return false;
        }
        catch (LSException le) {
            System.out.println("Unable to load Temporal Bundle Document.");
            le.printStackTrace();
            return false;
        }
        catch (Exception e) {
            System.out.println("Some other error occurred.");
            e.printStackTrace();
            return false;
        }
        long t2 = System.nanoTime();
        Common.printElaspedTime("parseSchema", t1, t2);
        return true;
    }

    public Document getTemporalSchemaDoc() {
        return this.temporal_schema_doc_;
    }

    public Document getConventionalSchemaDoc() {
        return this.conventional_schema_doc_;
    }

    public Document getAnnotationDoc() {
        return this.annotation_doc_;
    }

    public String getAnnotationName() {
        return this.annotation_name_;
    }

    public String getConventionalSchemaName() {
        return this.conventional_schema_name_;
    }

    public String getTemporalSchemaDir() {
        return this.temporal_schema_dir_;
    }
}

