/*
 * Decompiled with CFR 0.152.
 */
package cs.arizona.tau.docs;

import cs.arizona.tau.xml.Common;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.Pair;
import cs.arizona.util.ValidatorProperties;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConventionalSchema {
    private Document conventional_schema_doc_;
    private List<Pair<Element, ConventionalSchema>> imports;

    public ConventionalSchema(String conventional_schema_doc_name) {
        ValidatorProperties vp = ValidatorProperties.getInstance();
        ConventionalParser cp = ConventionalParser.getInstance();
        this.conventional_schema_doc_ = cp.parseDocument(conventional_schema_doc_name, null, vp.getProperty("XMLSchema"), false);
        this.imports = new LinkedList<Pair<Element, ConventionalSchema>>();
        NodeList nl = this.conventional_schema_doc_.getElementsByTagName("import");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!Common.isElement(n)) continue;
            Element e = (Element)n;
            String schemaLocation = e.getAttribute("schemaLocation");
            this.imports.add(new Pair<Element, ConventionalSchema>(e, new ConventionalSchema(schemaLocation)));
        }
    }

    public List<Pair<Element, ConventionalSchema>> getImports() {
        return this.imports;
    }

    public Document GetConventionalSchemaDocument() {
        return this.conventional_schema_doc_;
    }
}

