/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class tGenerator {
    static double INITIAL_PERCENTAGE = 10.0;
    static int OUTPUT_XML_SLICES = 0;
    static int OUTPUT_RELATION_SLICES = 0;
    static int OUTPUT_XML = 0;
    static int OUTPUT_RELATIONS = 0;
    static String START_TIME = "2010-01-01";
    static String FOREVER_TIME = "2099-12-31";
    static int TIME_STEP = 5;
    static int REQUIRED_CHANGES = 600000;
    static String OUTPUT_DIR = "output";
    static String INPUT_FILE = "catalog.xml";
    static String NULL_VALUE = "";
    static String SELECTION_TYPE = "uniform";
    static double SELECTION_STDDEV = 10.0;
    static int[] ITEM_PER_TIME_STEP = new int[3];
    static int[] AUTHOR_PER_TIME_STEP = new int[3];
    static int[] PUBLISHER_PER_TIME_STEP = new int[4];
    static int[] RELATED_PER_TIME_STEP = new int[4];
    static int DEBUG_OUTPUT = 0;
    static int NUMBER_SLICES = 100000;
    static ArrayList<Node> pool = new ArrayList();
    static ArrayList<Node> poolAuthor = new ArrayList();
    static ArrayList<Node> poolPublisher = new ArrayList();
    static ArrayList<Node> poolRelated = new ArrayList();
    static Random generator = new Random(1L);
    static final int CHANGE_INSERT = 0;
    static final int CHANGE_DELETE = 1;
    static final int CHANGE_UPDATE = 2;
    static final int CHANGE_DELETEINSERT = 3;
    static ArrayList<String> cols = new ArrayList();
    static ArrayList<String> colsAuthor = new ArrayList();
    static ArrayList<String> colsPublisher = new ArrayList();
    static ArrayList<String> colsRelated = new ArrayList();
    static int numChanges = 0;
    static int numEdits = 0;
    static int numInserts = 0;
    static int numDeletes = 0;
    static final int TYPE_ITEM = 1;
    static final int TYPE_AUTHOR = 2;
    static final int TYPE_PUBLISHER = 3;
    static final int TYPE_RELATED = 4;
    static String lastTime = "";
    static HashMap<String, Integer> usedIDs = new HashMap();
    static HashMap<String, String> idMap = new HashMap();
    static ArrayList<String> activeIDs = new ArrayList();
    static int aCounter = 0;
    static int pCounter = 0;
    static int rCounter = 0;
    static final int minAuthors = 1;
    static final int maxAuthors = 4;
    static HashMap<String, Integer> numberAuthors = new HashMap();
    static final int maxAuthorsNS = 6;
    static HashMap<String, Integer> numberAuthorsNS = new HashMap();
    static Document inputDocument;
    static Document outputDocument;
    static XPath xpath;
    static HashMap<String, ArrayList<String>> sliceListings;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Node> arrayList;
        Element element;
        int n;
        System.out.println("tGenerator: Reading parameters file...");
        String string = "parameters.txt";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        tGenerator.readSettings(string);
        for (n = 1; n < stringArray.length; n += 2) {
            tGenerator.setSetting(stringArray[n], stringArray[n + 1]);
        }
        n = new File(OUTPUT_DIR).mkdir() ? 1 : 0;
        outputDocument = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            outputDocument = documentBuilder.newDocument();
            element = outputDocument.createElement("catalog");
            outputDocument.appendChild(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            tGenerator.handleError(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            tGenerator.handleError(factoryConfigurationError);
        }
        element = outputDocument.getDocumentElement();
        if (!new File(INPUT_FILE).exists()) {
            System.out.printf("tGenerator: Error! File \"" + INPUT_FILE + "\" doesn't exist.", new Object[0]);
            System.exit(2);
        }
        System.out.println("tGenerator: Reading catalog file...");
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(INPUT_FILE);
        inputDocument = dOMParser.getDocument();
        Element element2 = inputDocument.getDocumentElement();
        List<Element> list = tGenerator.findAllElementsByTagName(element2, "item");
        int n2 = list.size();
        cols.add("ISBN");
        cols.add("title");
        cols.add("subject");
        cols.add("number_of_pages");
        cols.add("type_of_book");
        cols.add("length");
        cols.add("width");
        cols.add("height");
        cols.add("suggested_retail_price");
        cols.add("cost");
        cols.add("when_is_available");
        cols.add("quantity_in_stock");
        cols.add("date_of_release");
        cols.add("description");
        colsAuthor.add("first_name");
        colsAuthor.add("middle_name");
        colsAuthor.add("last_name");
        colsAuthor.add("date_of_birth");
        colsAuthor.add("biography");
        colsAuthor.add("street_address");
        colsAuthor.add("name_of_city");
        colsAuthor.add("name_of_state");
        colsAuthor.add("zip_code");
        colsAuthor.add("name_of_country");
        colsAuthor.add("phone_number");
        colsAuthor.add("email_address");
        colsPublisher.add("street_address");
        colsPublisher.add("name_of_city");
        colsPublisher.add("name_of_state");
        colsPublisher.add("zip_code");
        colsPublisher.add("phone_number");
        colsPublisher.add("web_site");
        colsRelated.add("item_id");
        Object object4 = START_TIME;
        System.out.println("tGenerator: Adding IDs to authors and publishers...");
        tGenerator.addIDs(element2);
        int n3 = (int)(INITIAL_PERCENTAGE / 100.0 * (double)n2);
        int n4 = (int)((float)n2 / (float)n3);
        System.out.println("tGenerator: Building initial snapshot and pools...");
        int n5 = 0;
        int n6 = 0;
        Object object5 = element2.getFirstChild();
        while (object5 != null) {
            Node node = object5.getNextSibling();
            if (object5.getNodeType() == 1) {
                ++n5;
                Node node2 = outputDocument.importNode((Node)object5, true);
                arrayList = tGenerator.wrapItem(outputDocument, node2);
                object3 = arrayList.getElementsByTagName("author").item(0);
                object2 = (Element)tGenerator.wrapAllElements(outputDocument, (Node)object3, "author", true);
                object = arrayList.getElementsByTagName("publisher").item(0);
                Element element3 = (Element)tGenerator.wrapAllElements(outputDocument, (Node)object, "publisher", true);
                Node node3 = arrayList.getElementsByTagName("related_items").item(0);
                Element element4 = (Element)tGenerator.wrapAllElements(outputDocument, node3, "related_items", true);
                if (n5 % n4 == 0) {
                    ++n6;
                    element.appendChild((Node)((Object)arrayList));
                    activeIDs.add(tGenerator.getMyID((Node)((Object)arrayList), 1));
                } else if (generator.nextInt(2) + 1 == 1) {
                    pool.add((Node)((Object)arrayList));
                } else {
                    poolAuthor.add((Node)object2);
                    poolPublisher.add(element3);
                    poolRelated.add(element4);
                }
            }
            object5 = node;
        }
        tGenerator.ensureRelatedIntegrity(element);
        System.out.println("");
        System.out.println("tGenerator: Number of <item>s read from input:        " + n5);
        System.out.println("tGenerator: Number of <item>s put into initial slice: " + n6);
        System.out.println("tGenerator: Size of <item>  pool:                     " + pool.size());
        System.out.println("tGenerator: Size of <author>  pool:                   " + poolAuthor.size());
        System.out.println("tGenerator: Size of <publisher>  pool:                " + poolPublisher.size());
        System.out.println("tGenerator: Size of <related_item>  pool:             " + poolRelated.size() + "\n");
        object5 = START_TIME;
        int n7 = 1;
        int n8 = 0;
        if (OUTPUT_XML_SLICES == 1) {
            if (DEBUG_OUTPUT == 1) {
                System.out.println("Printing XML slice...");
            }
            arrayList = "output." + (String)object5 + ".xml";
            tGenerator.outputXmlSlice(outputDocument, (String)object5, (String)((Object)arrayList));
            object3 = new ArrayList();
            ((ArrayList)object3).add(object4);
            ((ArrayList)object3).add(object5);
            sliceListings.put((String)((Object)arrayList), (ArrayList<String>)object3);
            object4 = object5;
        }
        if (OUTPUT_RELATION_SLICES == 1) {
            tGenerator.shredXmlSlice(outputDocument, (String)object5);
        }
        while (numChanges < REQUIRED_CHANGES && n7++ < NUMBER_SLICES) {
            int n9;
            Node node;
            int n10;
            n8 = 0;
            object5 = tGenerator.getDateString((String)object5, TIME_STEP);
            if (DEBUG_OUTPUT == 1) {
                System.out.println("Starting time step " + (String)object5);
            }
            tGenerator.updateActiveIDs(element, (String)object5);
            arrayList = tGenerator.getAllCurrentItems(outputDocument, "author", (String)object5);
            for (n10 = 0; n10 < 3; ++n10) {
                for (int i = 0; i < AUTHOR_PER_TIME_STEP[n10]; ++i) {
                    ++n8;
                    int n11 = tGenerator.getIdToChange(arrayList.size() - 1, (String)object5, 2, n10, arrayList);
                    Node node4 = (Node)arrayList.get(n11);
                    if (DEBUG_OUTPUT == 1) {
                        String string2 = tGenerator.getMyID(node4, 2);
                        String string3 = idMap.get(string2);
                    }
                    tGenerator.makeChanges(outputDocument, (String)object5, node4, 2, n10);
                }
            }
            arrayList = tGenerator.getAllCurrentItems(outputDocument, "publisher", (String)object5);
            for (n10 = 2; n10 < 4; ++n10) {
                for (int i = 0; i < PUBLISHER_PER_TIME_STEP[n10]; ++i) {
                    ++n8;
                    int n12 = tGenerator.getIdToChange(arrayList.size() - 1, (String)object5, 3, n10, arrayList);
                    Node node5 = (Node)arrayList.get(n12);
                    tGenerator.makeChanges(outputDocument, (String)object5, node5, 3, n10);
                }
            }
            arrayList = tGenerator.getAllCurrentItems(outputDocument, "item", (String)object5);
            object3 = new ArrayList<String>();
            object2 = new ArrayList();
            ((ArrayList)object3).add(1);
            ((ArrayList)object3).add(0);
            ((ArrayList)object3).add(2);
            for (int i = 0; i < 2; ++i) {
                int n13 = (Integer)((ArrayList)object3).get(i);
                int n14 = 0;
                for (int j = 0; j < ITEM_PER_TIME_STEP[n13]; ++j) {
                    ++n8;
                    n14 = tGenerator.getIdToChange(arrayList.size() - 1, (String)object5, 1, n13, arrayList);
                    node = arrayList.get(n14);
                    tGenerator.makeChanges(outputDocument, (String)object5, node, 1, n13);
                    if (i != 0) continue;
                    String string4 = tGenerator.getMyID(node, 1);
                    ((ArrayList)object2).add(string4);
                }
                if (i != 0) continue;
                tGenerator.updateActiveIDs(element, (String)object5);
            }
            tGenerator.updateActiveIDs(element, (String)object5);
            arrayList = tGenerator.getAllCurrentItems(outputDocument, "related_items", (String)object5);
            object = tGenerator.whichRelatedItemsPointTo(arrayList, (ArrayList<String>)object2, (String)object5);
            int n15 = 2;
            for (n9 = 0; n9 < ((ArrayList)object).size(); ++n9) {
                Node node6 = arrayList.get((Integer)((ArrayList)object).get(n9));
                tGenerator.makeChanges(outputDocument, (String)object5, node6, 4, n15);
            }
            for (n15 = 2; n15 < 4; ++n15) {
                for (n9 = 0; n9 < RELATED_PER_TIME_STEP[n15]; ++n9) {
                    ++n8;
                    int n16 = tGenerator.getIdToChange(arrayList.size() - 1, (String)object5, 4, n15, arrayList);
                    node = arrayList.get(n16);
                    tGenerator.makeChanges(outputDocument, (String)object5, node, 4, n15);
                }
            }
            System.out.printf("tGenerator: %3d changes at %s (%4d total, %5d required); %d slices\n", n8, object5, numChanges += n8, REQUIRED_CHANGES, n7);
            if (OUTPUT_XML_SLICES == 1) {
                if (DEBUG_OUTPUT == 1) {
                    System.out.println("Printing XML slice...");
                }
                String string5 = "output." + (String)object5 + ".xml";
                tGenerator.outputXmlSlice(outputDocument, (String)object5, string5);
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(object4);
                arrayList2.add(object5);
                sliceListings.put(string5, arrayList2);
                object4 = object5;
            }
            if (OUTPUT_RELATION_SLICES == 1) {
                tGenerator.shredXmlSlice(outputDocument, (String)object5);
            }
            if (DEBUG_OUTPUT != 1) continue;
            System.out.println("At end of time loop:");
        }
        System.out.println("\ntGenerator: Number of elements changed:  " + numEdits);
        System.out.println("tGenerator: Number of elements inserted: " + numInserts);
        System.out.println("tGenerator: Number of elements deleted:  " + numDeletes);
        System.out.println("\ntGenerator: Simulation complete.");
        if (OUTPUT_XML == 1) {
            System.out.println("tGenerator: Writing final XML output file.");
            arrayList = outputDocument.createElement("catalog_RepItem");
            arrayList.setAttribute("isItem", "yes");
            arrayList.setAttribute("originalElement", "catalog");
            object3 = outputDocument.createElement("catalog_Version");
            object3.setAttribute("begin", START_TIME);
            object3.setAttribute("end", (String)object5);
            object2 = outputDocument.getDocumentElement();
            object3.appendChild((Node)object2);
            arrayList.appendChild((Node)object3);
            outputDocument.appendChild((Node)((Object)arrayList));
            tGenerator.writeXmlFile(outputDocument, OUTPUT_DIR + "/output.final.xml", true, (String)object5);
        }
        if (OUTPUT_XML_SLICES == 1) {
            tGenerator.writeXmlSliceListingsFile(OUTPUT_DIR + "/output.final.slices.xml", (String)object5);
            int n17 = sliceListings.size();
            System.out.println("tGenerator: Wrote " + n17 + " slices.");
        }
        if (OUTPUT_RELATIONS == 1) {
            System.out.println("tGenerator: Shredding XML output file into 5 tables.");
            tGenerator.shredXmlFile(outputDocument, "final");
        }
        System.out.println("\ntGenerator: Done.");
    }

    private static ArrayList<Integer> whichRelatedItemsPointTo(ArrayList<Node> arrayList, ArrayList<String> arrayList2, String string) {
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            Node node = arrayList.get(i);
            String string2 = tGenerator.findAttribute(node, "end");
            String string3 = tGenerator.findAttribute(node, "begin");
            String string4 = tGenerator.getItemID(4, node);
            List<Element> list = tGenerator.findAllElementsByTagName((Element)node, "item_id");
            for (int j = 0; j < list.size(); ++j) {
                Node node2 = list.get(j);
                Node node3 = node2.getParentNode();
                Node node4 = node3.getParentNode();
                String string5 = ((Element)node4).getAttribute("related_items_id");
                String string6 = node2.getTextContent();
                if (!arrayList2.contains(string6)) continue;
                arrayList3.add(i);
                continue block0;
            }
        }
        return arrayList3;
    }

    private static void updateActiveIDs(Element element, String string) {
        if (DEBUG_OUTPUT == 1) {
            System.out.println("entering updateActiveIDs\n");
        }
        activeIDs.clear();
        NodeList nodeList = tGenerator.getAllNodesXPath(".//item_Version", element);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            String string2;
            Element element3 = (Element)nodeList.item(i);
            String string3 = element3.getAttribute("end");
            if (string3.compareTo(string) <= 0 || activeIDs.contains(string2 = (element2 = (Element)element3.getFirstChild()).getAttribute("id"))) continue;
            activeIDs.add(string2);
        }
        if (DEBUG_OUTPUT == 1) {
            System.out.println("exiting updateActiveIDs\n");
        }
    }

    private static void writeXmlSliceListingsFile(String string, String string2) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Element element = document.createElement("sliceSequence");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(sliceListings.keySet());
        Collections.sort(arrayList);
        for (String string3 : arrayList) {
            ArrayList<String> arrayList2 = sliceListings.get(string3);
            Element element2 = document.createElement("slice");
            element2.setAttribute("location", string3);
            element2.setAttribute("begin", arrayList2.get(0));
            element2.setAttribute("end", arrayList2.get(1));
            element.appendChild(element2);
        }
        document.appendChild(element);
        tGenerator.writeXmlFile(document, string, true, string2);
    }

    private static String getItemID(int n, Node node) {
        if (n == 1) {
            String string = tGenerator.findAttribute(node, "id");
            return string;
        }
        Element element = (Element)node;
        if (element.hasAttribute("id")) {
            return element.getAttribute("id");
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            return tGenerator.getItemID(n, node2);
        }
        return null;
    }

    private static void makeChanges(Document document, String string, Node node, int n, int n2) {
        ArrayList<String> arrayList;
        String string2 = "";
        if (n == 1) {
            arrayList = cols;
            string2 = "item";
        } else if (n == 2) {
            arrayList = colsAuthor;
            string2 = "author";
        } else if (n == 3) {
            arrayList = colsPublisher;
            string2 = "publisher";
        } else {
            arrayList = colsRelated;
            string2 = "related_item";
        }
        if (n2 == 2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (DEBUG_OUTPUT == 1) {
                object4 = tGenerator.getMyID(node, n);
                object3 = idMap.get(object4);
                System.out.printf("   %s: Updating %s with associated itemID (%s) (%s)\n", string, string2, object3, object4);
            }
            ++numEdits;
            object4 = tGenerator.getFromPool(n, string);
            object3 = tGenerator.getLastVersion(node);
            Node node2 = object3.cloneNode(true);
            tGenerator.makeEdits(document, (Element)object4, (Element)node2, arrayList);
            if (n == 1) {
                tGenerator.removeExpiredSubelements(node2, string);
            }
            if (n == 4) {
                node2 = tGenerator.getFirstElement((Node)object4);
                object2 = tGenerator.getFirstElement(node2);
                object = tGenerator.getFirstElement((Node)object3);
                object2.setAttribute("related_items_id", object.getAttribute("related_items_id"));
            }
            tGenerator.setEndTime((Element)object3, string);
            tGenerator.setAllChildrenEndTime((Element)object3, "" + string);
            tGenerator.setBeginTime((Element)node2, string);
            tGenerator.setAllChildrenBeginTime((Element)node2, string);
            node.appendChild(node2);
            object2 = tGenerator.getMyID((Element)node2, n);
            object = tGenerator.getItemID(n, (Element)node2);
            idMap.put((String)object2, (String)object);
            usedIDs.put((String)object, 1);
        } else if (n2 == 0) {
            ++numInserts;
            Node node3 = tGenerator.getFromPool(n, string);
            tGenerator.setBeginTime((Element)node3.getFirstChild(), string);
            tGenerator.setAllChildrenBeginTime((Element)node3.getFirstChild(), "" + string);
            node.getParentNode().appendChild(node3);
            String string3 = tGenerator.getMyID((Element)node3, n);
            String string4 = tGenerator.getItemID(n, (Element)node3);
            idMap.put(string3, string4);
            usedIDs.put(string4, 1);
            activeIDs.add(string4);
            if (n == 2) {
                tGenerator.addNumAuthors(string4);
                tGenerator.addNumAuthorsNS(string4, tGenerator.getYearFromString(string));
            }
            if (DEBUG_OUTPUT == 1) {
                System.out.printf("   %s: Inserting %s with associated itemID (%s) (%s)\n", string, string2, string4, string3);
            }
        } else if (n2 == 1) {
            ++numDeletes;
            Element element = (Element)tGenerator.getLastVersion(node);
            tGenerator.setEndTime(element, "" + string);
            tGenerator.setAllChildrenEndTime(element, "" + string);
            String string5 = tGenerator.getMyID(node, n);
            String string6 = idMap.get(string5);
            usedIDs.put(string6, 1);
            activeIDs.remove(string6);
            if (n == 2) {
                tGenerator.deleteNumAuthors(string6);
            }
            if (DEBUG_OUTPUT == 1) {
                System.out.printf("   %s: Deleting %s with associated itemID (%s) (%s)\n", string, string2, string6, string5);
            }
        } else if (n2 == 3) {
            Element element = (Element)tGenerator.getLastVersion(node);
            tGenerator.setEndTime(element, "" + string);
            tGenerator.setAllChildrenEndTime(element, "" + string);
            Node node4 = tGenerator.getFromPool(n, string);
            tGenerator.setBeginTime((Element)node4.getFirstChild(), string);
            tGenerator.setAllChildrenBeginTime((Element)node4.getFirstChild(), string);
            node.getParentNode().appendChild(node4);
            String string7 = tGenerator.getMyID(node, n);
            String string8 = tGenerator.getMyID(node4, n);
            String string9 = tGenerator.getItemID(n, (Element)node4);
            idMap.put(string8, string9);
            usedIDs.put(string9, 1);
            if (DEBUG_OUTPUT == 1) {
                System.out.printf("   %s: Delete/Inserting %s with associated itemID (%s) (%s) (%s)\n", string, string2, string9, string7, string8);
            }
        }
    }

    private static void ensureRelatedIntegrityAtTime(Node node) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        List<Element> list = tGenerator.findAllElementsByTagName((Element)node, "item_id");
        for (int i = 0; i < list.size(); ++i) {
            Element element = list.get(i);
            String string = element.getFirstChild().getNodeValue();
            if (!activeIDs.contains(string) || hashMap.containsKey(string)) {
                int n;
                String string2;
                while (hashMap.containsKey(string2 = activeIDs.get(n = generator.nextInt(activeIDs.size())))) {
                }
                element.getFirstChild().setNodeValue(string2);
                hashMap.put(string2, 1);
                usedIDs.put(string2, 1);
                continue;
            }
            hashMap.put(string, 1);
        }
    }

    private static void ensureRelatedIntegrity(Element element) {
        List<Element> list = tGenerator.findAllElementsByTagName(element, "related_items");
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = list.get(i);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            List<Element> list2 = tGenerator.findAllElementsByTagName(element2, "item_id");
            for (int j = 0; j < list2.size(); ++j) {
                Element element3 = list2.get(j);
                String string = element3.getFirstChild().getNodeValue();
                if (!activeIDs.contains(string) || hashMap.containsKey(string)) {
                    int n;
                    String string2;
                    while (hashMap.containsKey(string2 = activeIDs.get(n = generator.nextInt(activeIDs.size())))) {
                    }
                    hashMap.put(string2, 1);
                    element3.getFirstChild().setNodeValue(string2);
                    continue;
                }
                hashMap.put(string, 1);
            }
        }
    }

    private static void removeExpiredSubelements(Node node, String string) {
        NodeList nodeList;
        Object object;
        int n = 0;
        while ((n = tGenerator.removeExpiredSubelements2((Node)(object = ((Element)node).getElementsByTagName("authors").item(0)), nodeList = ((Element)node).getElementsByTagName("author_Version"), string)) > 0) {
        }
        n = 0;
        do {
            object = ((Element)node).getElementsByTagName("publisher_Version");
        } while ((n = tGenerator.removeExpiredSubelements2(node.getFirstChild(), (NodeList)object, string)) > 0);
        n = 0;
        do {
            object = ((Element)node).getElementsByTagName("related_items_Version");
        } while ((n = tGenerator.removeExpiredSubelements2(node.getFirstChild(), (NodeList)object, string)) > 0);
    }

    private static int removeExpiredSubelements2(Node node, NodeList nodeList, String string) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !(element = (Element)node2).hasAttribute("end") || element.getAttribute("end").compareTo(string) >= 0) continue;
            Node node3 = node2.getParentNode();
            node3.removeChild(node2);
            if (node3.getChildNodes().getLength() == 0) {
                Node node4 = node3.getParentNode();
                node4.removeChild(node3);
            }
            return 1;
        }
        return 0;
    }

    private static String getMyID(Node node, int n) {
        String string = "";
        if (n == 2) {
            string = tGenerator.findAttribute(node, "author_id");
        } else if (n == 3) {
            string = tGenerator.findAttribute(node, "publisher_id");
        } else if (n == 4) {
            string = tGenerator.findAttribute(node, "related_items_id");
        } else if (n == 1) {
            string = tGenerator.findAttribute(node, "id");
        }
        if (string.equals("") || string == null) {
            System.out.println("Warning: getMyID is funky!\n");
        }
        return string;
    }

    private static String findAttribute(Node node, String string) {
        Element element = (Element)node;
        if (element.hasAttribute(string)) {
            return element.getAttribute(string);
        }
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            return tGenerator.findAttribute(node2, string);
        }
        return null;
    }

    private static Node getLastVersion(Node node) {
        return node.getLastChild();
    }

    private static void makeEdits(Document document, Element element, Element element2, ArrayList<String> arrayList) {
        int n = generator.nextInt(arrayList.size());
        Node node = null;
        Node node2 = null;
        node = element.getElementsByTagName(arrayList.get(n)).item(0);
        node2 = element2.getElementsByTagName(arrayList.get(n)).item(0);
        if (node != null && node2 != null) {
            node2.getFirstChild().setNodeValue(node.getFirstChild().getNodeValue());
        }
    }

    private static Element wrapItem(Document document, Node node) {
        Element element = (Element)tGenerator.wrapAllElements(document, node, "author", false);
        Element element2 = (Element)tGenerator.wrapAllElements(document, element, "publisher", false);
        Element element3 = (Element)tGenerator.wrapAllElements(document, element2, "related_items", false);
        Element element4 = (Element)tGenerator.wrapAllElements(document, element3, "item", true);
        return element4;
    }

    private static void addIDs(Element element) {
        Element element2 = element;
        String string = "";
        String string2 = tGenerator.getYearFromString(START_TIME);
        Node node = element2.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 1) {
                String string3;
                Element element3 = (Element)node;
                if (element3.getNodeName().equals("author")) {
                    string = "A" + aCounter;
                    element3.setAttribute("author_id", string);
                    ++aCounter;
                    string3 = tGenerator.getItemID(2, element3);
                    if (numberAuthors.containsKey(string3)) {
                        numberAuthors.put(string3, numberAuthors.get(string3) + 1);
                    } else {
                        numberAuthors.put(string3, 1);
                    }
                    if (numberAuthorsNS.containsKey(string3 + string2)) {
                        numberAuthorsNS.put(string3 + string2, numberAuthorsNS.get(string3 + string2) + 1);
                    } else {
                        numberAuthorsNS.put(string3 + string2, 1);
                    }
                    idMap.put(string, string3);
                } else if (element3.getNodeName().equals("publisher")) {
                    string = "P" + pCounter;
                    element3.setAttribute("publisher_id", string);
                    string3 = tGenerator.getItemID(3, element3);
                    idMap.put(string, string3);
                    ++pCounter;
                } else if (element3.getNodeName().equals("related_items")) {
                    string = "R" + rCounter;
                    string3 = tGenerator.getItemID(4, element3);
                    element3.setAttribute("related_items_id", string);
                    idMap.put(string, string3);
                    ++rCounter;
                } else if (element3.getNodeName().equals("item")) {
                    string = element3.getAttribute("id");
                    idMap.put(string, string);
                }
                tGenerator.addIDs(element3);
            }
            node = node2;
        }
    }

    private static void setAllChildrenEndTime(Element element, String string) {
        Element element2 = element;
        Node node = element2.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 1) {
                Element element3 = (Element)node;
                if (element3.hasAttribute("end") && element3.getAttribute("end").equals(FOREVER_TIME)) {
                    element3.setAttribute("end", string);
                }
                tGenerator.setAllChildrenEndTime(element3, string);
            }
            node = node2;
        }
    }

    private static void setAllChildrenBeginTime(Element element, String string) {
        Element element2 = element;
        Node node = element2.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 1) {
                Element element3 = (Element)node;
                if (element3.hasAttribute("begin")) {
                    element3.setAttribute("begin", string);
                }
                tGenerator.setAllChildrenBeginTime(element3, string);
            }
            node = node2;
        }
    }

    private static void setEndTime(Element element, String string) {
        element.setAttribute("end", string);
    }

    private static void setBeginTime(Element element, String string) {
        element.setAttribute("begin", string);
    }

    private static Node wrapAllElements(Document document, Node node, String string, Boolean bl) {
        String string2 = string + "_RepItem";
        String string3 = string + "_Version";
        List<Element> list = tGenerator.findAllElementsByTagName((Element)node, string);
        for (int i = 0; i < list.size(); ++i) {
            Element element = list.get(i);
            Element element2 = document.createElement(string2);
            element2.setAttribute("isItem", "y");
            element2.setAttribute("originalElement", string);
            Element element3 = document.createElement(string3);
            element3.setAttribute("begin", START_TIME);
            element3.setAttribute("end", FOREVER_TIME);
            element3.appendChild(element.cloneNode(true));
            element2.appendChild(element3);
            if (bl.booleanValue()) {
                return element2;
            }
            element.getParentNode().replaceChild(element2, element);
        }
        return node;
    }

    private static ArrayList<Node> getAllCurrentItems(Document document, String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = document.getElementsByTagName(string + "_RepItem");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getElementsByTagName(string + "_Version");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                if (element2 == null) {
                    System.err.println("Error: something bad happened.");
                    System.exit(1);
                }
                if (element2.getAttribute("begin").compareTo(string2) > 0 || !element2.getAttribute("end").equals(FOREVER_TIME)) continue;
                arrayList.add(element);
            }
        }
        return arrayList;
    }

    static int rollDice() {
        return generator.nextInt(3) + 1;
    }

    static Node getFromPool(int n, String string) {
        if (n == 1) {
            if (pool.size() == 0) {
                System.out.println("\ntGenerator: Error! Item pool empty. Exiting.");
                System.exit(1);
            }
            int n2 = tGenerator.getIdToChange(pool.size() - 1, string, 1, 0, null);
            Node node = pool.remove(n2);
            Node node2 = tGenerator.findAllElementsByTagName((Element)node, "related_items_RepItem").get(0);
            tGenerator.ensureRelatedIntegrityAtTime(node2);
            return node;
        }
        if (n == 2) {
            if (poolAuthor.size() == 0) {
                System.out.println("\ntGenerator: Error! Author pool empty. Exiting.");
                System.exit(1);
            }
            return poolAuthor.remove(0);
        }
        if (n == 3) {
            if (poolPublisher.size() == 0) {
                System.out.println("\ntGenerator: Error! Publisher pool empty. Exiting.");
                System.exit(1);
            }
            return poolPublisher.remove(0);
        }
        if (poolRelated.size() == 0) {
            System.out.println("\ntGenerator: Error! Related pool empty. Exiting.");
            System.exit(1);
        }
        Node node = poolRelated.remove(0);
        tGenerator.ensureRelatedIntegrityAtTime(node);
        return node;
    }

    private static int getIdToChange(int n, String string, int n2, int n3, ArrayList<Node> arrayList) {
        int n4 = 1;
        if (!string.equals(lastTime)) {
            lastTime = string;
            usedIDs.clear();
        }
        boolean bl = true;
        int n5 = 0;
        while (bl && n5 < 5000) {
            if (SELECTION_TYPE.equalsIgnoreCase("gaussian")) {
                n4 = (int)(generator.nextGaussian() * SELECTION_STDDEV + (double)(n / 2));
                if (n4 > n) {
                    n4 = n;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
            } else if (SELECTION_TYPE.equalsIgnoreCase("uniform")) {
                n4 = generator.nextInt(n);
            } else {
                System.err.println("tGenerator: Unknown Selection Type: " + SELECTION_TYPE);
                System.exit(1);
            }
            if (arrayList != null) {
                String string2 = tGenerator.getMyID(arrayList.get(n4), n2);
                String string3 = idMap.get(string2);
                if (n2 == 2) {
                    int n6 = tGenerator.getNumAuthors(string3);
                    int n7 = tGenerator.getNumAuthorsNS(string3, tGenerator.getYearFromString(string));
                    if (n3 == 1 && n6 == 1) {
                        ++n5;
                        continue;
                    }
                    if (n3 == 0 && (n6 == 4 || n7 == 6)) {
                        ++n5;
                        continue;
                    }
                }
                if (!usedIDs.containsKey(string3)) {
                    usedIDs.put(string3, 1);
                    bl = false;
                    continue;
                }
                ++n5;
                continue;
            }
            bl = false;
        }
        if (n5 >= 5000) {
            if (DEBUG_OUTPUT == 1) {
                System.out.println(" getIdToChange: Last resort. max = " + n);
            }
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                String string4 = tGenerator.getMyID(arrayList.get(i), n2);
                String string5 = idMap.get(string4);
                if (usedIDs.containsKey(string5)) continue;
                n4 = i;
                usedIDs.put(string5, 1);
                bl = false;
                bl2 = true;
                if (DEBUG_OUTPUT != 1) break;
                System.out.printf(" getIdToChange: Selected id (%d) (%s) (%s)\n", i, string5, string4);
                break;
            }
            if (!bl2) {
                System.err.println("Warning: couldn't find ID to select (all used). Try reducing number of changes, or increasingg the initial slice size.");
                System.exit(1);
            }
        }
        return n4;
    }

    private static void addNumAuthorsNS(String string, String string2) {
        String string3 = string + string2;
        int n = 0;
        if (numberAuthorsNS.containsKey(string3)) {
            n = numberAuthorsNS.get(string3);
        }
        numberAuthorsNS.put(string3, n + 1);
    }

    private static int getNumAuthorsNS(String string, String string2) {
        String string3 = string + string2;
        if (numberAuthorsNS.containsKey(string3)) {
            return numberAuthorsNS.get(string3);
        }
        return 0;
    }

    private static void deleteNumAuthors(String string) {
        if (numberAuthors.containsKey(string)) {
            numberAuthors.put(string, numberAuthors.get(string) - 1);
        }
    }

    private static void addNumAuthors(String string) {
        int n = 0;
        if (numberAuthors.containsKey(string)) {
            n = numberAuthors.get(string);
        }
        numberAuthors.put(string, n + 1);
    }

    private static int getNumAuthors(String string) {
        if (numberAuthors.containsKey(string)) {
            return numberAuthors.get(string);
        }
        return 0;
    }

    private static final void handleError(Throwable throwable) {
        System.err.println("tGenerator: Error with DOM: " + throwable.getMessage());
        throwable.printStackTrace();
        System.exit(2);
    }

    public static void writeXmlFile(Document document, String string, boolean bl, String string2) {
        DocumentBuilder documentBuilder;
        Object object;
        XMLSerializer xMLSerializer;
        Document document2 = null;
        if (bl) {
            xMLSerializer = null;
            try {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                document2 = documentBuilder.newDocument();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            Element element = document.getDocumentElement();
            Element element2 = document2.createElement("temporalRoot");
            Element element3 = document2.createElement("temporalSchemaSet");
            Element element4 = document2.createElement("temporalSchema");
            element4.setAttribute("schemaLocation", "ts.xml");
            element2.setAttribute("begin", START_TIME);
            element2.setAttribute("end", string2);
            element3.appendChild(element4);
            element2.appendChild(element3);
            Node node = document2.importNode(element, true);
            element2.appendChild(node);
            document2.appendChild(element2);
        } else {
            document2 = document;
        }
        try {
            object = new FileOutputStream(string);
            documentBuilder = new OutputFormat("XML", "ISO-8859-1", true);
            documentBuilder.setIndent(1);
            documentBuilder.setIndenting(true);
            xMLSerializer = new XMLSerializer((OutputStream)object, (OutputFormat)documentBuilder);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document2.getDocumentElement());
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            tGenerator.handleError(exception);
        }
    }

    public static List<Element> findAllElementsByTagName(Element element, String string) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        tGenerator.findAllElementsByTagName(element, string, linkedList);
        return linkedList;
    }

    private static void findAllElementsByTagName(Element element, String string, List<Element> list) {
        if (string.equals(element.getTagName())) {
            list.add(element);
        }
        Element element2 = tGenerator.getFirstElement(element);
        while (element2 != null) {
            tGenerator.findAllElementsByTagName(element2, string, list);
            element2 = tGenerator.getNextElement(element2);
        }
    }

    public static Element getFirstElement(Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && 1 != node2.getNodeType(); node2 = node2.getNextSibling()) {
        }
        if (node2 == null) {
            return null;
        }
        return (Element)node2;
    }

    public static Element getNextElement(Element element) {
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    private static String getDateString(String string, int n) {
        String string2 = "yyyy-MM-dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Calendar calendar = Calendar.getInstance();
        int n2 = Integer.parseInt(string.substring(0, 4));
        int n3 = Integer.parseInt(string.substring(5, 7));
        int n4 = Integer.parseInt(string.substring(8, 10));
        calendar.set(1, n2);
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        calendar.add(5, n);
        String string3 = simpleDateFormat.format(calendar.getTime());
        return string3;
    }

    private static void outputXmlSlice(Document document, String string, String string2) {
        Document document2 = tGenerator.getXmlSlice(document, string);
        tGenerator.writeXmlFile(document2, OUTPUT_DIR + "/" + string2, false, null);
    }

    private static Document getXmlSlice(Document document, String string) {
        Document document2 = tGenerator.copyDocument(document);
        Document document3 = null;
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document3 = documentBuilder.newDocument();
            element = document3.createElement("catalog");
            document3.appendChild(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            tGenerator.handleError(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            tGenerator.handleError(factoryConfigurationError);
        }
        NodeList nodeList = document2.getElementsByTagName("item_Version");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            Object object;
            Object object2;
            Object object3;
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getAttribute("end");
            if (string2.compareTo(string) <= 0) continue;
            Node node = element2.getFirstChild();
            Node node2 = document3.importNode(node, true);
            Element element3 = null;
            NodeList nodeList2 = tGenerator.getAllNodesXPath(".//authors", node2);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                element3 = (Element)nodeList2.item(j);
                object3 = tGenerator.getAllNodesXPath(".//author_Version", element3);
                for (int k = 0; k < object3.getLength(); ++k) {
                    object2 = (Element)object3.item(k);
                    object = object2.getAttribute("end");
                    Node node3 = object2.getFirstChild();
                    if (((String)object).compareTo(string) > 0) {
                        element3.appendChild(node3);
                        continue;
                    }
                    object2.removeChild(node3);
                }
            }
            NodeList nodeList3 = tGenerator.getAllNodesXPath(".//publisher_Version", node2);
            for (n = 0; n < nodeList3.getLength(); ++n) {
                Element element4 = (Element)nodeList3.item(n);
                object2 = element4.getAttribute("end");
                object = element4.getFirstChild();
                if (((String)object2).compareTo(string) <= 0) continue;
                node2.appendChild((Node)object);
            }
            nodeList3 = tGenerator.getAllNodesXPath(".//related_items_Version", node2);
            for (n = 0; n < nodeList3.getLength(); ++n) {
                Element element5 = (Element)nodeList3.item(n);
                object2 = element5.getAttribute("end");
                object = element5.getFirstChild();
                if (((String)object2).compareTo(string) <= 0) continue;
                node2.appendChild((Node)object);
            }
            nodeList2 = tGenerator.getAllNodesXPath(".//authors", node2);
            for (n = 0; n < nodeList2.getLength(); ++n) {
                Node node4 = nodeList2.item(n);
                object2 = node4.getFirstChild();
                while (object2 != null) {
                    object = object2.getNextSibling();
                    if (object2.getNodeName().equals("author_RepItem")) {
                        node4.removeChild((Node)object2);
                    }
                    object2 = object;
                }
            }
            object3 = node2.getFirstChild();
            while (object3 != null) {
                Node node5 = object3.getNextSibling();
                if (object3.getNodeName().equals("publisher_RepItem")) {
                    node2.removeChild((Node)object3);
                } else if (object3.getNodeName().equals("related_items_RepItem")) {
                    node2.removeChild((Node)object3);
                }
                object3 = node5;
            }
            element.appendChild(node2);
        }
        return document3;
    }

    private static void shredXmlSlice(Document document, String string) {
        try {
            int n;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            String string15;
            String string16;
            String string17;
            Object object;
            Element element;
            Element element2;
            int n2;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/author." + string + ".csv", false));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item." + string + ".csv", false));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/publisher." + string + ".csv", false));
            BufferedWriter bufferedWriter4 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/related_item." + string + ".csv", false));
            BufferedWriter bufferedWriter5 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item_author." + string + ".csv", false));
            BufferedWriter bufferedWriter6 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item_publisher." + string + ".csv", false));
            Document document2 = tGenerator.getXmlSlice(document, string);
            NodeList nodeList = document2.getElementsByTagName("author");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                element2 = (Element)nodeList.item(n2);
                element = (Element)element2.getParentNode().getParentNode();
                object = element.getAttribute("id");
                string17 = element2.getAttribute("author_id");
                string16 = tGenerator.getElementValue(element2, "first_name");
                string15 = tGenerator.getElementValue(element2, "middle_name");
                string14 = tGenerator.getElementValue(element2, "last_name");
                string13 = tGenerator.getElementValue(element2, "date_of_birth");
                string12 = tGenerator.getElementValue(element2, "biography");
                string11 = tGenerator.getElementValue(element2, "street_address");
                string10 = tGenerator.getElementValue(element2, "name_of_city");
                string9 = tGenerator.getElementValue(element2, "name_of_state");
                string8 = tGenerator.getElementValue(element2, "zip_code");
                string7 = tGenerator.getElementValue(element2, "name_of_country");
                string6 = tGenerator.getElementValue(element2, "phone_number");
                string5 = tGenerator.getElementValue(element2, "email_address");
                string4 = tGenerator.buildString(13);
                string3 = String.format(string4, string17, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string5);
                string2 = tGenerator.buildString(2);
                String string18 = String.format(string2, object, string17);
                bufferedWriter.write(string3);
                bufferedWriter5.write(string18);
            }
            bufferedWriter.close();
            bufferedWriter5.close();
            nodeList = document2.getElementsByTagName("publisher");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                element2 = (Element)nodeList.item(n2);
                element = (Element)element2.getParentNode();
                object = element.getAttribute("id");
                string17 = element2.getAttribute("publisher_id");
                string16 = tGenerator.getElementValue(element2, "name");
                string15 = tGenerator.getElementValue(element2, "street_address");
                string14 = tGenerator.getElementValue(element2, "name_of_city");
                string13 = tGenerator.getElementValue(element2, "name_of_state");
                string12 = tGenerator.getElementValue(element2, "zip_code");
                string11 = tGenerator.getElementValue(element2, "exchange_rate");
                string10 = tGenerator.getElementValue(element2, "currency");
                string9 = tGenerator.getElementValue(element2, "phone_number");
                string8 = tGenerator.getElementValue(element2, "web_site");
                string7 = tGenerator.getElementValue(element2, "FAX_number");
                string6 = tGenerator.buildString(11);
                string5 = String.format(string6, string17, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7);
                string4 = tGenerator.buildString(2);
                string3 = String.format(string4, object, string17);
                bufferedWriter3.write(string5);
                bufferedWriter6.write(string3);
            }
            bufferedWriter3.close();
            bufferedWriter6.close();
            NodeList nodeList2 = document2.getElementsByTagName("item");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                element = (Element)nodeList2.item(n);
                object = element.getAttribute("id");
                string17 = tGenerator.getElementValue(element, "ISBN");
                string16 = tGenerator.getElementValue(element, "title");
                string15 = tGenerator.getElementValue(element, "subject");
                string14 = tGenerator.getElementValue(element, "number_of_pages");
                string13 = tGenerator.getElementValue(element, "type_of_book");
                string12 = tGenerator.getElementValue(element, "length");
                string11 = tGenerator.getElementValue(element, "width");
                string10 = tGenerator.getElementValue(element, "height");
                string9 = tGenerator.getElementValue(element, "suggested_retail_price");
                string8 = tGenerator.getElementValue(element, "cost");
                string7 = tGenerator.getElementValue(element, "when_is_available");
                string6 = tGenerator.getElementValue(element, "quantity_in_stock");
                string5 = tGenerator.getElementValue(element, "date_of_release");
                string4 = tGenerator.getElementValue(element, "description");
                string3 = tGenerator.buildString(15);
                string2 = String.format(string3, object, string17, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string5, string4);
                bufferedWriter2.write(string2);
            }
            bufferedWriter2.close();
            nodeList2 = document2.getElementsByTagName("related_item");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                element = (Element)nodeList2.item(n);
                object = element.getParentNode().getParentNode();
                string17 = ((Element)object).getAttribute("id");
                string16 = tGenerator.getElementValue(element, "item_id");
                string15 = tGenerator.buildString(2);
                string14 = String.format(string15, string17, string16);
                bufferedWriter4.write(string14);
            }
            bufferedWriter4.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private static void shredXmlSlice2(Document document, String string) {
        try {
            int n;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            String string15;
            String string16;
            Object object;
            Object object2;
            String string17;
            Object object3;
            Object object4;
            Object object5;
            int n2;
            Object object6;
            Element element;
            int n3;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/author." + string + ".csv", false));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item." + string + ".csv", false));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/publisher." + string + ".csv", false));
            BufferedWriter bufferedWriter4 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/related_item." + string + ".csv", false));
            BufferedWriter bufferedWriter5 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item_author." + string + ".csv", false));
            BufferedWriter bufferedWriter6 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item_publisher." + string + ".csv", false));
            NodeList nodeList = document.getElementsByTagName("author_RepItem");
            for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                element = (Element)nodeList.item(n3);
                object6 = element.getElementsByTagName("author_Version");
                for (n2 = 0; n2 < object6.getLength(); ++n2) {
                    object5 = (Element)object6.item(n2);
                    object4 = (Element)object5.getParentNode().getParentNode().getParentNode();
                    object3 = object4.getAttribute("id");
                    string17 = object5.getAttribute("begin");
                    object2 = object5.getAttribute("end");
                    if (((String)object2).compareTo(string) <= 0) continue;
                    object = (Element)object5.getFirstChild();
                    string16 = object.getAttribute("author_id");
                    string15 = tGenerator.getElementValue((Element)object, "first_name");
                    string14 = tGenerator.getElementValue((Element)object, "middle_name");
                    string13 = tGenerator.getElementValue((Element)object, "last_name");
                    string12 = tGenerator.getElementValue((Element)object, "date_of_birth");
                    string11 = tGenerator.getElementValue((Element)object, "biography");
                    string10 = tGenerator.getElementValue((Element)object, "street_address");
                    string9 = tGenerator.getElementValue((Element)object, "name_of_city");
                    string8 = tGenerator.getElementValue((Element)object, "name_of_state");
                    string7 = tGenerator.getElementValue((Element)object, "zip_code");
                    string6 = tGenerator.getElementValue((Element)object, "name_of_country");
                    string5 = tGenerator.getElementValue((Element)object, "phone_number");
                    string4 = tGenerator.getElementValue((Element)object, "email_address");
                    string3 = tGenerator.buildString(13);
                    string2 = String.format(string3, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string5, string4);
                    String string18 = tGenerator.buildString(2);
                    String string19 = String.format(string18, object3, string16);
                    bufferedWriter.write(string2);
                    bufferedWriter5.write(string19);
                }
            }
            bufferedWriter.close();
            bufferedWriter5.close();
            nodeList = document.getElementsByTagName("publisher_RepItem");
            for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                element = (Element)nodeList.item(n3);
                object6 = element.getElementsByTagName("publisher_Version");
                for (n2 = 0; n2 < object6.getLength(); ++n2) {
                    object5 = (Element)object6.item(n2);
                    object4 = (Element)object5.getParentNode().getParentNode();
                    object3 = object4.getAttribute("id");
                    string17 = object5.getAttribute("begin");
                    object2 = object5.getAttribute("end");
                    if (((String)object2).compareTo(string) <= 0) continue;
                    object = (Element)object5.getFirstChild();
                    string16 = object.getAttribute("publisher_id");
                    string15 = tGenerator.getElementValue((Element)object, "name");
                    string14 = tGenerator.getElementValue((Element)object, "street_address");
                    string13 = tGenerator.getElementValue((Element)object, "name_of_city");
                    string12 = tGenerator.getElementValue((Element)object, "name_of_state");
                    string11 = tGenerator.getElementValue((Element)object, "zip_code");
                    string10 = tGenerator.getElementValue((Element)object, "exchange_rate");
                    string9 = tGenerator.getElementValue((Element)object, "currency");
                    string8 = tGenerator.getElementValue((Element)object, "phone_number");
                    string7 = tGenerator.getElementValue((Element)object, "web_site");
                    string6 = tGenerator.getElementValue((Element)object, "FAX_number");
                    string5 = tGenerator.buildString(11);
                    string4 = String.format(string5, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6);
                    string3 = tGenerator.buildString(2);
                    string2 = String.format(string3, object3, string16);
                    bufferedWriter3.write(string4);
                    bufferedWriter6.write(string2);
                }
            }
            bufferedWriter3.close();
            bufferedWriter6.close();
            NodeList nodeList2 = document.getElementsByTagName("item_Version");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                object6 = (Element)nodeList2.item(n);
                String string20 = object6.getAttribute("begin");
                object5 = object6.getAttribute("end");
                if (((String)object5).compareTo(string) <= 0) continue;
                object4 = (Element)object6.getFirstChild();
                object3 = object4.getAttribute("id");
                string17 = tGenerator.getElementValue((Element)object4, "ISBN");
                object2 = tGenerator.getElementValue((Element)object4, "title");
                object = tGenerator.getElementValue((Element)object4, "subject");
                string16 = tGenerator.getElementValue((Element)object4, "number_of_pages");
                string15 = tGenerator.getElementValue((Element)object4, "type_of_book");
                string14 = tGenerator.getElementValue((Element)object4, "length");
                string13 = tGenerator.getElementValue((Element)object4, "width");
                string12 = tGenerator.getElementValue((Element)object4, "height");
                string11 = tGenerator.getElementValue((Element)object4, "suggested_retail_price");
                string10 = tGenerator.getElementValue((Element)object4, "cost");
                string9 = tGenerator.getElementValue((Element)object4, "when_is_available");
                string8 = tGenerator.getElementValue((Element)object4, "quantity_in_stock");
                string7 = tGenerator.getElementValue((Element)object4, "date_of_release");
                string6 = tGenerator.getElementValue((Element)object4, "description");
                string5 = tGenerator.buildString(15);
                string4 = String.format(string5, object3, string17, object2, object, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6);
                bufferedWriter2.write(string4);
            }
            bufferedWriter2.close();
            nodeList2 = document.getElementsByTagName("related_items_Version");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                object6 = (Element)nodeList2.item(n);
                if (object6.getFirstChild().getFirstChild() == null) continue;
                Element element2 = (Element)object6.getParentNode().getParentNode();
                object5 = object6.getAttribute("begin");
                object4 = object6.getAttribute("end");
                if (((String)object4).compareTo(string) <= 0) continue;
                object3 = object6.getElementsByTagName("related_item");
                for (int i = 0; i < object3.getLength(); ++i) {
                    object2 = (Element)object3.item(i);
                    object = element2.getAttribute("id");
                    string16 = tGenerator.getElementValue((Element)object2, "item_id");
                    string15 = tGenerator.buildString(2);
                    string14 = String.format(string15, object, string16);
                    bufferedWriter4.write(string14);
                }
            }
            bufferedWriter4.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void shredXmlFile(Document document, String string) {
        try {
            int n;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            String string15;
            String string16;
            Object object;
            Object object2;
            String string17;
            Object object3;
            Object object4;
            Object object5;
            int n2;
            Object object6;
            Element element;
            int n3;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/author." + string + ".csv", false));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item." + string + ".csv", false));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/publisher." + string + ".csv", false));
            BufferedWriter bufferedWriter4 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/related_item." + string + ".csv", false));
            BufferedWriter bufferedWriter5 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item_author." + string + ".csv", false));
            BufferedWriter bufferedWriter6 = new BufferedWriter(new FileWriter(OUTPUT_DIR + "/item_publisher." + string + ".csv", false));
            NodeList nodeList = document.getElementsByTagName("author_RepItem");
            for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                element = (Element)nodeList.item(n3);
                object6 = element.getElementsByTagName("author_Version");
                for (n2 = 0; n2 < object6.getLength(); ++n2) {
                    object5 = (Element)object6.item(n2);
                    object4 = (Element)object5.getParentNode().getParentNode().getParentNode();
                    object3 = object4.getAttribute("id");
                    string17 = object5.getAttribute("begin");
                    object2 = object5.getAttribute("end");
                    object = (Element)object5.getFirstChild();
                    string16 = object.getAttribute("author_id");
                    string15 = tGenerator.getElementValue((Element)object, "first_name");
                    string14 = tGenerator.getElementValue((Element)object, "middle_name");
                    string13 = tGenerator.getElementValue((Element)object, "last_name");
                    string12 = tGenerator.getElementValue((Element)object, "date_of_birth");
                    string11 = tGenerator.getElementValue((Element)object, "biography");
                    string10 = tGenerator.getElementValue((Element)object, "street_address");
                    string9 = tGenerator.getElementValue((Element)object, "name_of_city");
                    string8 = tGenerator.getElementValue((Element)object, "name_of_state");
                    string7 = tGenerator.getElementValue((Element)object, "zip_code");
                    string6 = tGenerator.getElementValue((Element)object, "name_of_country");
                    string5 = tGenerator.getElementValue((Element)object, "phone_number");
                    string4 = tGenerator.getElementValue((Element)object, "email_address");
                    string3 = tGenerator.buildString(15);
                    string2 = String.format(string3, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string5, string4, string17, object2);
                    String string18 = tGenerator.buildString(4);
                    String string19 = String.format(string18, object3, string16, string17, object2);
                    bufferedWriter.write(string2);
                    bufferedWriter5.write(string19);
                }
            }
            bufferedWriter.close();
            bufferedWriter5.close();
            nodeList = document.getElementsByTagName("publisher_RepItem");
            for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                element = (Element)nodeList.item(n3);
                object6 = element.getElementsByTagName("publisher_Version");
                for (n2 = 0; n2 < object6.getLength(); ++n2) {
                    object5 = (Element)object6.item(n2);
                    object4 = (Element)object5.getParentNode().getParentNode();
                    object3 = object4.getAttribute("id");
                    string17 = object5.getAttribute("begin");
                    object2 = object5.getAttribute("end");
                    object = (Element)object5.getFirstChild();
                    string16 = object.getAttribute("publisher_id");
                    string15 = tGenerator.getElementValue((Element)object, "name");
                    string14 = tGenerator.getElementValue((Element)object, "street_address");
                    string13 = tGenerator.getElementValue((Element)object, "name_of_city");
                    string12 = tGenerator.getElementValue((Element)object, "name_of_state");
                    string11 = tGenerator.getElementValue((Element)object, "zip_code");
                    string10 = tGenerator.getElementValue((Element)object, "exchange_rate");
                    string9 = tGenerator.getElementValue((Element)object, "currency");
                    string8 = tGenerator.getElementValue((Element)object, "phone_number");
                    string7 = tGenerator.getElementValue((Element)object, "web_site");
                    string6 = tGenerator.getElementValue((Element)object, "FAX_number");
                    string5 = tGenerator.buildString(13);
                    string4 = String.format(string5, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string17, object2);
                    string3 = tGenerator.buildString(4);
                    string2 = String.format(string3, object3, string16, string17, object2);
                    bufferedWriter3.write(string4);
                    bufferedWriter6.write(string2);
                }
            }
            bufferedWriter3.close();
            bufferedWriter6.close();
            NodeList nodeList2 = document.getElementsByTagName("item_Version");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                object6 = (Element)nodeList2.item(n);
                String string20 = object6.getAttribute("begin");
                object5 = object6.getAttribute("end");
                object4 = (Element)object6.getFirstChild();
                object3 = object4.getAttribute("id");
                string17 = tGenerator.getElementValue((Element)object4, "ISBN");
                object2 = tGenerator.getElementValue((Element)object4, "title");
                object = tGenerator.getElementValue((Element)object4, "subject");
                string16 = tGenerator.getElementValue((Element)object4, "number_of_pages");
                string15 = tGenerator.getElementValue((Element)object4, "type_of_book");
                string14 = tGenerator.getElementValue((Element)object4, "length");
                string13 = tGenerator.getElementValue((Element)object4, "width");
                string12 = tGenerator.getElementValue((Element)object4, "height");
                string11 = tGenerator.getElementValue((Element)object4, "suggested_retail_price");
                string10 = tGenerator.getElementValue((Element)object4, "cost");
                string9 = tGenerator.getElementValue((Element)object4, "when_is_available");
                string8 = tGenerator.getElementValue((Element)object4, "quantity_in_stock");
                string7 = tGenerator.getElementValue((Element)object4, "date_of_release");
                string6 = tGenerator.getElementValue((Element)object4, "description");
                string5 = tGenerator.buildString(17);
                string4 = String.format(string5, object3, string17, object2, object, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string20, object5);
                bufferedWriter2.write(string4);
            }
            bufferedWriter2.close();
            nodeList2 = document.getElementsByTagName("related_items_Version");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                object6 = (Element)nodeList2.item(n);
                if (object6.getFirstChild().getFirstChild() == null) continue;
                Element element2 = (Element)object6.getParentNode().getParentNode();
                object5 = object6.getAttribute("begin");
                object4 = object6.getAttribute("end");
                object3 = object6.getElementsByTagName("related_item");
                for (int i = 0; i < object3.getLength(); ++i) {
                    object2 = (Element)object3.item(i);
                    object = element2.getAttribute("id");
                    string16 = tGenerator.getElementValue((Element)object2, "item_id");
                    string15 = tGenerator.buildString(4);
                    string14 = String.format(string15, object, string16, object5, object4);
                    bufferedWriter4.write(string14);
                }
            }
            bufferedWriter4.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getYearFromString(String string) {
        return string.substring(0, 4);
    }

    private static String buildString(int n) {
        String string = "%s";
        for (int i = 1; i < n; ++i) {
            string = string + "&%s";
        }
        return string + "\n";
    }

    private static Document copyDocument(Document document) {
        Document document2 = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document2 = documentBuilder.newDocument();
            document2.appendChild(document2.importNode(document.getDocumentElement(), true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document2;
    }

    private static void printNode(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(node);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            System.out.println(string);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    private static String getElementValue(Element element, String string) {
        Node node = element.getElementsByTagName(string).item(0);
        if (node != null) {
            return node.getFirstChild().getNodeValue();
        }
        return NULL_VALUE;
    }

    private static void readSettings(String string) {
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.matches("^ *$") || string2.matches("#.*")) continue;
                String string3 = string2.split(" +")[0];
                String string4 = string2.split(" +")[1];
                tGenerator.setSetting(string3, string4);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("tGenerator: Reading input error: " + exception.getMessage());
            System.exit(1);
        }
    }

    private static void setSetting(String string, String string2) {
        if (string.equals("INITIAL_PERCENTAGE")) {
            INITIAL_PERCENTAGE = Double.parseDouble(string2);
        } else if (string.equals("OUTPUT_XML_SLICES")) {
            OUTPUT_XML_SLICES = Integer.parseInt(string2);
        } else if (string.equals("OUTPUT_RELATION_SLICES")) {
            OUTPUT_RELATION_SLICES = Integer.parseInt(string2);
        } else if (string.equals("OUTPUT_XML")) {
            OUTPUT_XML = Integer.parseInt(string2);
        } else if (string.equals("OUTPUT_RELATIONS")) {
            OUTPUT_RELATIONS = Integer.parseInt(string2);
        } else if (string.equals("TIME_STEP")) {
            TIME_STEP = Integer.parseInt(string2);
        } else if (string.equals("NUMBER_SLICES")) {
            NUMBER_SLICES = Integer.parseInt(string2);
        } else if (string.equals("REQUIRED_CHANGES")) {
            REQUIRED_CHANGES = Integer.parseInt(string2);
        } else if (string.equals("INPUT_FILE")) {
            INPUT_FILE = string2;
        } else if (string.equals("OUTPUT_DIR")) {
            OUTPUT_DIR = string2;
        } else if (string.equals("START_TIME")) {
            START_TIME = string2;
        } else if (string.equals("FOREVER_TIME")) {
            FOREVER_TIME = string2;
        } else if (string.equals("SELECTION_TYPE")) {
            SELECTION_TYPE = string2;
        } else if (string.equals("SELECTION_STDDEV")) {
            SELECTION_STDDEV = Double.parseDouble(string2);
        } else if (string.equals("NULL_VALUE")) {
            NULL_VALUE = string2.replaceAll("\"", "");
        } else if (string.equals("DEBUG_OUTPUT")) {
            DEBUG_OUTPUT = Integer.parseInt(string2);
        } else if (string.equals("ITEM_PER_TIME_STEP_INSERTS")) {
            tGenerator.ITEM_PER_TIME_STEP[0] = Integer.parseInt(string2);
        } else if (string.equals("ITEM_PER_TIME_STEP_DELETES")) {
            tGenerator.ITEM_PER_TIME_STEP[1] = Integer.parseInt(string2);
        } else if (string.equals("ITEM_PER_TIME_STEP_UPDATES")) {
            tGenerator.ITEM_PER_TIME_STEP[2] = Integer.parseInt(string2);
        } else if (string.equals("AUTHOR_PER_TIME_STEP_INSERTS")) {
            tGenerator.AUTHOR_PER_TIME_STEP[0] = Integer.parseInt(string2);
        } else if (string.equals("AUTHOR_PER_TIME_STEP_DELETES")) {
            tGenerator.AUTHOR_PER_TIME_STEP[1] = Integer.parseInt(string2);
        } else if (string.equals("AUTHOR_PER_TIME_STEP_UPDATES")) {
            tGenerator.AUTHOR_PER_TIME_STEP[2] = Integer.parseInt(string2);
        } else if (string.equals("PUBLISHER_PER_TIME_STEP_DELETES_INSERTS")) {
            tGenerator.PUBLISHER_PER_TIME_STEP[3] = Integer.parseInt(string2);
        } else if (string.equals("PUBLISHER_PER_TIME_STEP_UPDATES")) {
            tGenerator.PUBLISHER_PER_TIME_STEP[2] = Integer.parseInt(string2);
        } else if (string.equals("RELATED_PER_TIME_STEP_DELETES_INSERTS")) {
            tGenerator.RELATED_PER_TIME_STEP[3] = Integer.parseInt(string2);
        } else if (string.equals("RELATED_PER_TIME_STEP_UPDATES")) {
            tGenerator.RELATED_PER_TIME_STEP[2] = Integer.parseInt(string2);
        } else {
            System.err.println("tGenerator: Unknown parameter-pair: " + string);
        }
    }

    private static void printItem(Node node, String string) {
        Object object;
        Node node2;
        String string2 = node.getNodeName();
        if ((string2.contains("item") || string2.contains("author") || string2.contains("publisher") || string2.contains("related_item")) && node.getNodeType() == 1) {
            System.out.print(string + node.getNodeName() + ": ");
            node2 = (Element)node;
            object = node2.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                System.out.print(object.item(i) + " ");
            }
            if (string2.equals("item_id")) {
                System.out.println(node.getTextContent());
            }
            System.out.println("");
        }
        if ((node2 = node.getFirstChild()) != null) {
            tGenerator.printItem(node2, string + "  ");
        }
        if ((object = node.getNextSibling()) != null) {
            tGenerator.printItem((Node)object, string);
        }
    }

    private static NodeList getAllNodesXPath(String string, Object object) {
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(string, object, XPathConstants.NODESET);
            return nodeList;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private static Node getItemFromXPath(String string, Document document) {
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(string, document, XPathConstants.NODESET);
            return nodeList.item(0);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private static void printNodeXPath(String string, Document document) {
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(string, document, XPathConstants.NODESET);
            System.out.println("xpath \"" + string + " found " + nodeList.getLength() + " items:");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                System.out.println(i + 1 + " of " + nodeList.getLength() + ":");
                tGenerator.printItem(node, "");
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    static {
        xpath = XPathFactory.newInstance().newXPath();
        sliceListings = new HashMap();
    }
}

