/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class tCorruptor {
    static Random generator = new Random(1L);
    static Document inputDocument;
    static Document outputDocument;
    static XPath xpath;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("tCorruptor: Incorrect Usage.");
            System.out.println("tCorruptor input_file action");
        }
        String inputFile = args[0];
        int action = Integer.parseInt(args[1]);
        if (!new File(inputFile).exists()) {
            System.err.printf("Error! File \"" + inputFile + "\" doesn't exist.", new Object[0]);
            System.exit(2);
        }
        System.out.println("tCorruptor: Reading input file...");
        DOMParser parser = new DOMParser();
        parser.parse(inputFile);
        inputDocument = parser.getDocument();
        System.out.println("tCorruptor: done.");
        outputDocument = tCorruptor.copyDocument(inputDocument);
        System.out.println("tCorruptor: Corrupting...");
        switch (action) {
            case 0: {
                break;
            }
            case 1: {
                tCorruptor.corruptAuthorsSequenced();
                break;
            }
            case 2: {
                tCorruptor.corruptRelatedItemSequenced();
                break;
            }
            case 3: {
                tCorruptor.corruptISBNSequenced();
                break;
            }
            case 4: {
                tCorruptor.corruptNumberOfPagesSequenced();
                break;
            }
            case 5: {
                tCorruptor.corruptItemIDNonseqquenced();
                break;
            }
            case 6: {
                tCorruptor.corruptRelatedItemNonsequenced();
                break;
            }
            case 7: {
                tCorruptor.corruptAuthorsNonsequenced();
                break;
            }
            default: {
                System.err.println("Error: action " + action + " unknown.");
            }
        }
        System.out.println("tCorruptor: done.");
        System.out.println("tCorruptor: Writing output file...");
        tCorruptor.writeXmlFile(outputDocument, "output.new.xml");
        System.out.println("tCorruptor: done.");
    }

    private static void corruptAuthorsNonsequenced() {
        Node victim = tCorruptor.getSingleNodeXPath("//author_RepItem", outputDocument);
        Node parent = victim.getParentNode();
        for (int i = 1; i <= 6; ++i) {
            Node newNode = victim.cloneNode(true);
            NodeList authors = tCorruptor.getAllNodesXPath(".//author", newNode);
            for (int j = 0; j < authors.getLength(); ++j) {
                Node thisAuthor = authors.item(j);
                String thisId = ((Element)thisAuthor).getAttribute("author_id");
                ((Element)thisAuthor).setAttribute("author_id", thisId + "321342" + i);
            }
            parent.appendChild(newNode);
        }
    }

    private static void corruptRelatedItemNonsequenced() {
        String firstTime = tCorruptor.getTimeFromXPath("", outputDocument, 1);
        Node victim = tCorruptor.getSingleNodeXPath("//item_id[../../../../../../@begin='" + firstTime + "']", outputDocument);
        tCorruptor.printNode(victim);
        String thisId = ((Element)victim).getTextContent();
        ((Element)victim).setTextContent(thisId + "321342009989");
        tCorruptor.printNode(victim);
    }

    private static void corruptItemIDNonseqquenced() {
        String time1 = tCorruptor.getTimeFromXPath("", outputDocument, 1);
        String time2 = tCorruptor.getTimeFromXPath("", outputDocument, 10);
        Node source = tCorruptor.getSingleNodeXPath("//item[../@begin='" + time1 + "']", outputDocument);
        Node victim = tCorruptor.getSingleNodeXPath("//item[../@begin='" + time2 + "']", outputDocument);
        tCorruptor.printNode(victim);
        String thisId = ((Element)source).getAttribute("id");
        ((Element)victim).setAttribute("id", thisId);
        tCorruptor.printNode(victim);
    }

    private static void corruptNumberOfPagesSequenced() {
        Node victim = tCorruptor.getSingleNodeXPath("//number_of_pages", outputDocument);
        tCorruptor.printNode(victim);
        ((Element)victim).setTextContent("NotAShort");
        tCorruptor.printNode(victim);
    }

    private static void corruptISBNSequenced() {
        Node source = tCorruptor.getSingleNodeXPath("//ISBN", outputDocument);
        Node victim = tCorruptor.getSingleNodeXPath("//ISBN", outputDocument);
        tCorruptor.printNode(victim);
        String thisISBN = ((Element)source).getTextContent();
        ((Element)victim).setTextContent(thisISBN);
        tCorruptor.printNode(victim);
    }

    private static void corruptRelatedItemSequenced() {
        Node victim = tCorruptor.getSingleNodeXPath("//item_id", outputDocument);
        tCorruptor.printNode(victim);
        String thisId = ((Element)victim).getTextContent();
        ((Element)victim).setTextContent(thisId + "321342009988");
        tCorruptor.printNode(victim);
    }

    static void corruptAuthorsSequenced() {
        Node victim = tCorruptor.getSingleNodeXPath("//authors", outputDocument);
        Node versionToCopy = tCorruptor.getSingleNodeXPath(".//author_Version", victim);
        Node parent = versionToCopy.getParentNode();
        for (int i = 1; i < 10; ++i) {
            Node newNode = versionToCopy.cloneNode(true);
            Element thisAuthor = tCorruptor.getFirstElement(newNode);
            String thisId = thisAuthor.getAttribute("author_id");
            thisAuthor.setAttribute("author_id", thisId + "321342" + i);
            parent.appendChild(newNode);
        }
    }

    static int rollDice() {
        return generator.nextInt(3) + 1;
    }

    private static final void handleError(Throwable ex) {
        System.out.println("tCorrputor: Error with DOM");
    }

    public static void writeXmlFile(Document output, String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            OutputFormat of = new OutputFormat("XML", "ISO-8859-1", true);
            of.setIndent(1);
            of.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer((OutputStream)fos, of);
            serializer.asDOMSerializer();
            serializer.serialize(output.getDocumentElement());
            fos.close();
        }
        catch (Exception e) {
            tCorruptor.handleError(e);
        }
    }

    public static List<Element> findAllElementsByTagName(Element elem, String tagName) {
        LinkedList<Element> ret = new LinkedList<Element>();
        tCorruptor.findAllElementsByTagName(elem, tagName, ret);
        return ret;
    }

    private static void findAllElementsByTagName(Element el, String tagName, List<Element> elementList) {
        if (tagName.equals(el.getTagName())) {
            elementList.add(el);
        }
        Element elem = tCorruptor.getFirstElement(el);
        while (elem != null) {
            tCorruptor.findAllElementsByTagName(elem, tagName, elementList);
            elem = tCorruptor.getNextElement(elem);
        }
    }

    public static Element getFirstElement(Node parent) {
        Node n;
        for (n = parent.getFirstChild(); n != null && 1 != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return (Element)n;
    }

    public static Element getNextElement(Element el) {
        for (Node nd = el.getNextSibling(); nd != null; nd = nd.getNextSibling()) {
            if (nd.getNodeType() != 1) continue;
            return (Element)nd;
        }
        return null;
    }

    private static Document copyDocument(Document d1) {
        Document d2 = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder loader = factory.newDocumentBuilder();
            d2 = loader.newDocument();
            d2.appendChild(d2.importNode(d1.getDocumentElement(), true));
        }
        catch (Exception e) {
            // empty catch block
        }
        return d2;
    }

    private static void printNode(Node node) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            trans.transform(source, result);
            String xmlString = sw.toString();
            System.out.println(xmlString);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private static void printItem(Node n, String sep) {
        Node next;
        Node child;
        String name = n.getNodeName();
        if ((name.contains("item") || name.contains("author") || name.contains("publisher") || name.contains("related_item")) && n.getNodeType() == 1) {
            System.out.print(sep + n.getNodeName() + ": ");
            Element e = (Element)n;
            NamedNodeMap nnm = e.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                System.out.print(nnm.item(i) + " ");
            }
            System.out.println("");
        }
        if ((child = n.getFirstChild()) != null) {
            tCorruptor.printItem(child, sep + "  ");
        }
        if ((next = n.getNextSibling()) != null) {
            tCorruptor.printItem(next, sep);
        }
    }

    private static Node getSingleNodeXPath(String path, Object p) {
        try {
            NodeList e = (NodeList)xpath.evaluate(path, p, XPathConstants.NODESET);
            int i = e.getLength();
            int id = generator.nextInt(e.getLength());
            return e.item(id);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private static NodeList getAllNodesXPath(String path, Object p) {
        try {
            NodeList e = (NodeList)xpath.evaluate(path, p, XPathConstants.NODESET);
            return e;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private static String getTimeFromXPath(String path, Object p, int index) {
        try {
            path = "//@begin";
            NodeList e = (NodeList)xpath.evaluate(path, (Document)p, XPathConstants.NODESET);
            return e.item(index).getTextContent();
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    static {
        xpath = XPathFactory.newInstance().newXPath();
    }
}

