/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;

public class ToxVector
extends Vector {
    private int pagesize;
    private int size;
    private int numElements;
    private int numPages;
    ArrayList pages;

    public ToxVector() {
        this(10, 10, null);
    }

    public ToxVector(int n) {
        this(n, n, null);
    }

    public ToxVector(int n, int n2, String string) {
        this.pagesize = n2;
        int n3 = n / n2 + 1;
        this.pages = new ArrayList(n3);
        this.pages.add(new Page(n2, 0, n2 - 1));
    }

    public boolean add(Object object) {
        try {
            Page page = (Page)this.pages.get(this.pages.size() - 1);
            if (this.numElements <= page.end) {
                page.add(object);
            } else {
                Page page2 = new Page(this.pagesize, page.end + 1, page.end + this.pagesize);
                page2.add(object);
                this.pages.add(page2);
            }
            ++this.numElements;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.freePage();
            this.add(object);
        }
        return true;
    }

    public void addAll(ToxVector toxVector) {
        int n = 0;
        while (n < toxVector.size()) {
            Object object = toxVector.get(n);
            this.add(object);
            ++n;
        }
    }

    public void setElementAt(Object object, int n) {
        Page page = this.findRightPage(n);
        page.setElementAt(object, n);
    }

    private Page findRightPage(int n) {
        Page page;
        block8: {
            page = null;
            if (n >= this.numElements) break block8;
            int n2 = n / this.pagesize;
            page = (Page)this.pages.get(n2);
            if (n < page.start || n > page.end) {
                if (n < page.start) {
                    int n3 = n2 - 1;
                    while (n3 >= 0) {
                        page = (Page)this.pages.get(n3);
                        if (n < page.start || n > page.end) {
                            --n3;
                            continue;
                        }
                        break;
                    }
                } else if (n > page.end) {
                    int n4 = n2 + 1;
                    while (n4 < this.pages.size()) {
                        page = (Page)this.pages.get(n4);
                        if (n < page.start || n > page.end) {
                            ++n4;
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        return page;
    }

    public Object get(int n) {
        Object object = null;
        Page page = this.findRightPage(n);
        if (page == null) {
            System.out.println("aaa");
            System.exit(0);
        }
        try {
            object = page.get(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.freePage();
            object = page.get(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return object;
    }

    public Object elementAt(int n) {
        return this.get(n);
    }

    public void removeElementAt(int n) {
        Object object = null;
        Page page = this.findRightPage(n);
        try {
            object = page.remove(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.freePage();
            object = page.get(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.updatePageIndices(page);
        --this.numElements;
    }

    private void updatePageIndices(Page page) {
        int n = this.pages.indexOf(page);
        int n2 = n + 1;
        while (n2 < this.pages.size()) {
            Page page2 = (Page)this.pages.get(n2);
            --page2.start;
            --page2.end;
            ++n2;
        }
    }

    public void freePage() {
        Runtime runtime = Runtime.getRuntime();
        System.out.println("freePage() - no. of pages: " + this.pages.size() + " free memory: " + runtime.freeMemory() + " total memory: " + runtime.totalMemory());
        try {
            int n = 0;
            while (n < this.pages.size()) {
                Page page = (Page)this.pages.get(n);
                if (page.getElements() != null) {
                    page.writeToFile();
                }
                ++n;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println(outOfMemoryError);
        }
        System.out.println("Free memory after: " + runtime.freeMemory());
    }

    public int size() {
        return this.numElements;
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.numElements) {
            string = string + this.get(n).toString();
            ++n;
        }
        return string;
    }

    protected class Page
    implements Serializable {
        public int start;
        public int end;
        private boolean fileExists;
        private boolean written;
        private ArrayList elements;
        private File file;
        private String tempDirName;
        private FileInputStream fin;
        private FileOutputStream fout;
        private ObjectInputStream inStream;
        private ObjectOutputStream outStream;

        public Page(int n, int n2, int n3) {
            this.elements = new ArrayList(n);
            this.start = n2;
            this.end = n3;
        }

        public Page(int n, int n2, int n3, String string) {
            this(n, n2, n3);
            this.tempDirName = string;
        }

        public void add(Object object) throws OutOfMemoryError {
            if ((this.elements != null || this.fileExists) && this.elements == null && this.fileExists) {
                this.readFromFile();
            }
            this.elements.add(object);
        }

        public Object get(int n) throws OutOfMemoryError {
            if (n >= this.start && n <= this.end) {
                if (this.elements == null && !this.fileExists) {
                    return null;
                }
                if (this.elements == null && this.fileExists) {
                    this.readFromFile();
                }
                return this.elements.get(n - this.start);
            }
            return null;
        }

        public Object remove(int n) throws OutOfMemoryError {
            if (this.elements == null && !this.fileExists) {
                return null;
            }
            if (this.elements == null && this.fileExists) {
                this.readFromFile();
            }
            Object e = this.elements.remove(n - this.start);
            --this.end;
            if (this.end < this.start) {
                this.start = -1;
            }
            return e;
        }

        public void setElementAt(Object object, int n) {
            if ((this.elements != null || this.fileExists) && this.elements == null && this.fileExists) {
                this.readFromFile();
            }
            this.elements.set(n - this.start, object);
        }

        private void writeToFile() {
            this.file = this.tempDirName == null ? new File("temp" + this.toString()) : new File(this.tempDirName, "temp" + this.toString());
            try {
                if (!this.fileExists) {
                    this.file.createNewFile();
                    this.fileExists = true;
                }
                this.file.deleteOnExit();
                this.fout = new FileOutputStream(this.file);
            }
            catch (IOException iOException) {
                System.err.println("\nCould not access file: " + this.file.toString());
                iOException.printStackTrace();
                System.exit(1);
            }
            try {
                this.outStream = new ObjectOutputStream(this.fout);
                this.outStream.writeObject(this.elements);
                this.outStream.close();
                this.fout.close();
            }
            catch (IOException iOException) {
                System.err.println("\nCould not write to file: " + this.file.toString());
                System.exit(1);
            }
            this.file = null;
            this.fout = null;
            this.outStream = null;
            this.elements = null;
        }

        private void readFromFile() {
            System.out.println("readFromFile()");
            this.file = this.tempDirName == null ? new File("temp" + this.toString()) : new File(this.tempDirName, "temp" + this.toString());
            try {
                this.fin = new FileInputStream(this.file);
                this.inStream = new ObjectInputStream(this.fin);
                this.elements = (ArrayList)this.inStream.readObject();
                this.inStream.close();
                this.fin.close();
            }
            catch (IOException iOException) {
                System.err.println("\nCould not read from file: " + this.file.toString());
                System.exit(1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("\nCould not read from file: " + this.file.toString());
                System.exit(1);
            }
            this.file = null;
            this.fin = null;
            this.inStream = null;
        }

        public ArrayList getElements() {
            return this.elements;
        }
    }
}

