/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;
import util.DuplicateKeyException;
import util.KeyNotFoundException;
import util.StringObjectPair;

public class Dictionary
implements Serializable {
    private Vector original;
    private Vector entries;
    private int size = 0;

    public Dictionary() {
        this.entries = new Vector();
        this.original = new Vector();
    }

    public Dictionary(int n) {
        this.entries = new Vector(n);
        this.original = new Vector(n);
    }

    public Dictionary(Dictionary dictionary) {
        int n = dictionary.size();
        this.entries = new Vector(n);
        this.original = new Vector(n);
        this.addAll(dictionary);
    }

    public Vector values() {
        Vector<Object> vector = new Vector<Object>(this.size);
        int n = 0;
        while (n < this.size) {
            vector.add(((StringObjectPair)this.original.elementAt(n)).value());
            ++n;
        }
        return vector;
    }

    public void add(String string, Object object) throws DuplicateKeyException {
        StringObjectPair stringObjectPair = new StringObjectPair(string, object);
        int n = Collections.binarySearch(this.entries, string);
        if (n < 0) {
            this.original.add(stringObjectPair);
            this.entries.add(-1 - n, stringObjectPair);
            ++this.size;
        } else {
            throw new DuplicateKeyException("Key value \"" + string + "\" already used!");
        }
    }

    public void addAll(Dictionary dictionary) {
        this.entries.addAll(dictionary.entries);
        this.original.addAll(dictionary.original);
    }

    public Object get(String string) throws KeyNotFoundException {
        int n = Collections.binarySearch(this.entries, string);
        if (n < 0) {
            throw new KeyNotFoundException("Key value \"" + string + "\" not found!");
        }
        return ((StringObjectPair)this.entries.elementAt(n)).value();
    }

    public void remove(String string) throws KeyNotFoundException {
        int n = Collections.binarySearch(this.entries, string);
        if (n < 0) {
            throw new KeyNotFoundException("Key value \"" + string + "\" not found!");
        }
        this.entries.remove(n);
    }

    public int size() {
        return this.size;
    }

    public boolean contains(String string) {
        int n = Collections.binarySearch(this.entries, string);
        return n >= 0;
    }

    public Object getValueAt(int n) throws ArrayIndexOutOfBoundsException {
        return ((StringObjectPair)this.entries.elementAt(n)).value();
    }

    public Object getKeyAt(int n) throws ArrayIndexOutOfBoundsException {
        return ((StringObjectPair)this.entries.elementAt(n)).key();
    }
}

