/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import util.DateFormatException;

public class Date
implements Comparable,
Serializable {
    public static final int MAX_DATE = 1;
    public static final int MIN_DATE = 2;
    private GregorianCalendar calendar;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public Date() {
        this.calendar = new GregorianCalendar();
    }

    public Date(Date date) {
        this.calendar = (GregorianCalendar)date.calendar.clone();
    }

    public Date(String string) throws DateFormatException {
        try {
            this.df.parse(string);
            this.calendar = (GregorianCalendar)this.df.getCalendar();
        }
        catch (ParseException parseException) {
            throw new DateFormatException();
        }
    }

    public Date(int n, int n2, int n3) {
        this.calendar = new GregorianCalendar(n, n2, n3);
    }

    public Date(int n) {
        switch (n) {
            case 1: {
                this.calendar = new GregorianCalendar(4000, 1, 1);
                break;
            }
            case 2: {
                this.calendar = new GregorianCalendar(0, 1, 1);
            }
        }
    }

    public static Date parseDate(String string) throws DateFormatException {
        return new Date(string);
    }

    public static Date valueOf(String string) throws DateFormatException {
        return new Date(string);
    }

    public static String toString(Date date) {
        return date.toString();
    }

    public boolean before(Date date) {
        return this.calendar.before(date.getCalendar());
    }

    public boolean after(Date date) {
        return this.calendar.after(date.getCalendar());
    }

    public java.util.Date getTime() {
        return this.calendar.getTime();
    }

    public boolean on(Date date) {
        GregorianCalendar gregorianCalendar = date.getCalendar();
        return this.calendar.get(5) == gregorianCalendar.get(5) && this.calendar.get(2) == gregorianCalendar.get(2) && this.calendar.get(1) == gregorianCalendar.get(1);
    }

    public GregorianCalendar getCalendar() {
        return this.calendar;
    }

    public int compareTo(Object object) {
        GregorianCalendar gregorianCalendar = ((Date)object).getCalendar();
        if (this.before((Date)object)) {
            return -1;
        }
        if (this.after((Date)object)) {
            return 1;
        }
        return 0;
    }

    public Date add(int n) {
        this.calendar.add(5, n);
        return this;
    }

    public Date sub(int n) {
        this.calendar.add(5, -n);
        return this;
    }

    public Date add(Date date) {
        GregorianCalendar gregorianCalendar = date.getCalendar();
        return new Date(this.calendar.get(5) + gregorianCalendar.get(5), this.calendar.get(2) + gregorianCalendar.get(2), this.calendar.get(1) + gregorianCalendar.get(1));
    }

    public Date sub(Date date) {
        GregorianCalendar gregorianCalendar = date.getCalendar();
        return new Date(this.calendar.get(5) - gregorianCalendar.get(5), this.calendar.get(2) - gregorianCalendar.get(2), this.calendar.get(1) - gregorianCalendar.get(1));
    }

    public String toString() {
        return this.df.format(this.calendar.getTime());
    }

    public int difference(Date date) {
        int n;
        GregorianCalendar gregorianCalendar = date.calendar;
        int n2 = this.calendar.get(1) - gregorianCalendar.get(1);
        if (n2 < 0) {
            n2 *= -1;
        }
        if ((n = this.calendar.get(6) - gregorianCalendar.get(6)) < 0) {
            n *= -1;
        }
        return 365 * n2 + n;
    }
}

