/*
 * Decompiled with CFR 0.152.
 */
package toxgene;

import genes.lists.ToxList;
import genes.trees.ToxFile;
import java.util.Random;
import java.util.Vector;
import org.w3c.dom.Node;
import parser.ToxParser;
import util.Dictionary;
import util.KeyNotFoundException;

public class ToXgene {
    public static boolean verbose = false;
    public static Random seedGenerator = new Random(System.currentTimeMillis());
    public static final String version = "1.1a";
    public static Dictionary toxLists = new Dictionary();
    public static Dictionary simpleTypes = new Dictionary();
    public static Dictionary randomGenerators = new Dictionary();
    public static boolean addNewLine = false;
    private static ToxParser parser;
    private static int nWarnings;
    private static boolean showWarnings;
    private static boolean showTime;
    private static Vector tagNames;
    private static Dictionary tagIndex;

    public static void main(String[] stringArray) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = stringArray.length;
        boolean bl = true;
        int n2 = 1;
        String string = "ToXgene 1.1a - (c) 2001 by University of Toronto and IBM Corporation\n\n";
        String string2 = new String("Usage: toxGene <options> <template file>\nwhere possible options include ([default value]):\n  -c\tCheck template only; do not generate files [false]\n  -h\tPrints this message\n  -v\tVerbose mode [false]\n  -w\tOmit warning messages [false]\n  -n\tAdd a new line after each element closing tag\n  -t\tShow elapsed time [false]\n  -m<t> Uses t threads\n  -s<v> Uses v as initial random seed.");
        if (n == 0) {
            System.err.println(string + string2);
            System.exit(1);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char[] cArray = stringArray[n4].toCharArray();
            if (cArray[0] == '-') {
                ++n3;
                switch (cArray[1]) {
                    case 'c': {
                        bl = false;
                        break;
                    }
                    case 'h': {
                        System.out.println(string + string2);
                        System.exit(0);
                        break;
                    }
                    case 'v': {
                        verbose = true;
                        break;
                    }
                    case 'w': {
                        showWarnings = false;
                        break;
                    }
                    case 't': {
                        showTime = true;
                        break;
                    }
                    case 'n': {
                        addNewLine = true;
                        break;
                    }
                    case 's': {
                        int n5 = Integer.parseInt(stringArray[n4].substring(2));
                        seedGenerator = new Random(n5);
                        break;
                    }
                    case 'm': {
                        n2 = Integer.parseInt(stringArray[n4].substring(2));
                        if (n2 >= 2) break;
                        ToXgene.error("numThreads has to be greater than 1");
                        break;
                    }
                    default: {
                        System.out.println("Ignoring unrecognized option: " + cArray[1]);
                    }
                }
            }
            ++n4;
        }
        l = System.currentTimeMillis();
        if (n3 < n) {
            String string3 = stringArray[n - 1];
            System.out.print(string);
            try {
                System.out.print(" ***** Parsing template: ");
                parser = new ToxParser();
                parser.parse(string3);
                System.out.println("Done! \n");
                if (bl) {
                    Vector vector = parser.lists();
                    Vector vector2 = parser.documents();
                    int n6 = vector2.size();
                    l2 = System.currentTimeMillis();
                    int n7 = 0;
                    while (n7 < vector.size()) {
                        ((ToxList)vector.get(n7)).generate(n2);
                        ++n7;
                    }
                    l3 = System.currentTimeMillis();
                    System.out.println();
                    if (n6 > 0) {
                        System.out.println(" ***** Generating XML documents *****");
                        int n8 = 0;
                        while (n8 < n6) {
                            ((ToxFile)vector2.get(n8)).generate();
                            ++n8;
                        }
                    } else {
                        ToXgene.warning("no document genes found");
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("\n***** UNRECOGNIZED ERROR: An unrecognized error has occurred.\nPlease report the following debug information to toxgene-bugs@cs.toronto.edu\nPlease include the template that causes this problem.\n");
                exception.printStackTrace();
            }
        } else {
            System.out.println(string + string2);
            System.exit(1);
        }
        if (nWarnings > 0) {
            System.out.println("There were " + nWarnings + " warning messages");
        }
        l4 = System.currentTimeMillis();
        if (showTime) {
            System.out.println("Total elapsed time: " + (l4 - l) + "ms.");
            System.out.println("Parsing time: " + (l2 - l) + "ms.");
            System.out.println("List processing time: " + (l3 - l2) + "ms.");
        }
        System.exit(0);
    }

    public static void deleteList(String string) {
        parser.deleteList(string);
        System.gc();
    }

    public static void warning(String string) {
        ++nWarnings;
        if (showWarnings) {
            System.out.println("\n***** WARNING: " + string);
        }
    }

    public static void error(String string) {
        System.out.println("\n***** ERROR: " + string);
        System.exit(1);
    }

    public static void error(String string, Node node) {
        ToXgene.error(string, parser.findElement(node));
    }

    public static void error(String string, String string2) {
        System.out.println("\n***** ERROR: " + string);
        System.out.println("***** LOCATION: " + string2);
        System.exit(1);
    }

    public static void explain(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    public static String getTagName(int n) {
        return (String)tagNames.elementAt(n);
    }

    public static int getTagNumber(String string) {
        int n = 0;
        try {
            n = (Integer)tagIndex.get(string);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            n = tagNames.size();
            tagNames.add(n, string);
            tagIndex.add(string, new Integer(n));
        }
        return n;
    }

    public static int queryTagNumber(String string) {
        int n = 0;
        try {
            n = (Integer)tagIndex.get(string);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            // empty catch block
        }
        return n;
    }

    static {
        showWarnings = true;
        showTime = false;
        tagNames = new Vector();
        tagIndex = new Dictionary();
    }
}

