/*
 * Decompiled with CFR 0.152.
 */
package random;

import java.io.Serializable;
import java.util.Random;
import java.util.Vector;
import random.ToxRandom;
import toxgene.ToXgene;
import util.FloatObjectPair;

public class ToxUserDefined
implements ToxRandom,
Serializable {
    private Vector options;
    private float min;
    private float max;
    private float sum;
    private Random rand;

    public ToxUserDefined(float f, float f2) {
        this.min = f;
        this.max = f2;
        if (f2 < f) {
            System.out.println("***** ERROR: invalid min and max values for ToxGaussian random generator!");
            System.exit(1);
        }
        this.options = new Vector();
        this.sum = 0.0f;
        this.rand = new Random(ToXgene.seedGenerator.nextLong());
    }

    public long nextInt() {
        return Math.round((double)this.nextFloat());
    }

    public float nextFloat() {
        float f = 100.0f * this.rand.nextFloat();
        int n = 0;
        while (n < this.options.size()) {
            if (f < ((FloatObjectPair)this.options.elementAt(n)).key()) {
                return ((Float)((FloatObjectPair)this.options.elementAt(n)).value()).floatValue();
            }
            ++n;
        }
        return 0.0f;
    }

    public void addOption(float f, float f2) {
        if (f < this.min || f > this.max) {
            System.out.println("***** ERROR: invalid distribution value");
            System.exit(1);
        }
        this.sum += f2;
        this.options.add(new FloatObjectPair(this.sum, new Float(f)));
    }

    public float minValue() {
        return this.min;
    }

    public float maxValue() {
        return this.max;
    }

    public void setMaxValue(float f) {
        if (f < this.min) {
            System.out.println("***** ERROR: cannot update distribution max value: " + f + " is smaller than minimum value: " + this.min);
            System.exit(1);
        }
        this.min = f;
    }

    public long nextInt(float f) {
        if (f < this.min) {
            System.out.println("***** ERROR: cannot update distribution max value: " + f + " is smaller than minimum value: " + this.min);
            System.exit(1);
        }
        return Math.round((double)this.min + (double)((f - this.min) * this.rand.nextFloat()));
    }

    public void resetRandomGen() {
        this.rand.setSeed(ToXgene.seedGenerator.nextLong());
    }
}

