/*
 * Decompiled with CFR 0.152.
 */
package random;

import java.io.Serializable;
import java.util.Random;
import random.ToxRandom;
import toxgene.ToXgene;

public class ToxUniform
implements ToxRandom,
Serializable {
    private float min;
    private float max;
    private Random rand;

    public ToxUniform(float f, float f2) {
        this.min = f;
        this.max = f2;
        if (f2 < f) {
            ToXgene.error(" invalid (min,max) values for uniform distribution: (" + f + "," + f2 + ")");
        }
        this.rand = new Random(ToXgene.seedGenerator.nextLong());
    }

    public long nextInt() {
        return Math.round((double)this.nextFloat());
    }

    public float nextFloat() {
        return this.min + (this.max - this.min) * this.rand.nextFloat();
    }

    public float minValue() {
        return this.min;
    }

    public float maxValue() {
        return this.max;
    }

    public long nextInt(float f) throws RuntimeException {
        if (f < this.min) {
            throw new RuntimeException();
        }
        return Math.round((double)this.min + (double)((f - this.min) * this.rand.nextFloat()));
    }

    public void resetRandomGen() {
        this.rand.setSeed(ToXgene.seedGenerator.nextLong());
    }
}

